// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteIntentInput struct {
	_ struct{} `type:"structure"`

	// The name of the intent. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteIntentInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteIntentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteIntentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteIntentOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteIntent = "DeleteIntent"

// DeleteIntentRequest returns a request value for making API operation for
// Amazon Lex Model Building Service.
//
// Deletes all versions of the intent, including the $LATEST version. To delete
// a specific version of the intent, use the DeleteIntentVersion operation.
//
// You can delete a version of an intent only if it is not referenced. To delete
// an intent that is referred to in one or more bots (see how-it-works), you
// must remove those references first.
//
// If you get the ResourceInUseException exception, it provides an example reference
// that shows where the intent is referenced. To remove the reference to the
// intent, either update the bot or delete it. If you get the same exception
// when you attempt to delete the intent again, repeat until the intent has
// no references and the call to DeleteIntent is successful.
//
// This operation requires permission for the lex:DeleteIntent action.
//
//    // Example sending a request using DeleteIntentRequest.
//    req := client.DeleteIntentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntent
func (c *Client) DeleteIntentRequest(input *DeleteIntentInput) DeleteIntentRequest {
	op := &aws.Operation{
		Name:       opDeleteIntent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/intents/{name}",
	}

	if input == nil {
		input = &DeleteIntentInput{}
	}

	req := c.newRequest(op, input, &DeleteIntentOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteIntentRequest{Request: req, Input: input, Copy: c.DeleteIntentRequest}
}

// DeleteIntentRequest is the request type for the
// DeleteIntent API operation.
type DeleteIntentRequest struct {
	*aws.Request
	Input *DeleteIntentInput
	Copy  func(*DeleteIntentInput) DeleteIntentRequest
}

// Send marshals and sends the DeleteIntent API request.
func (r DeleteIntentRequest) Send(ctx context.Context) (*DeleteIntentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteIntentResponse{
		DeleteIntentOutput: r.Request.Data.(*DeleteIntentOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteIntentResponse is the response type for the
// DeleteIntent API operation.
type DeleteIntentResponse struct {
	*DeleteIntentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteIntent request.
func (r *DeleteIntentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
