// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CopySnapshotInput struct {
	_ struct{} `type:"structure"`

	// The date of the source automatic snapshot to copy. Use the get auto snapshots
	// operation to identify the dates of the available automatic snapshots.
	//
	// Constraints:
	//
	//    * Must be specified in YYYY-MM-DD format.
	//
	//    * This parameter cannot be defined together with the use latest restorable
	//    auto snapshot parameter. The restore date and use latest restorable auto
	//    snapshot parameters are mutually exclusive.
	//
	//    * Define this parameter only when copying an automatic snapshot as a manual
	//    snapshot. For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
	RestoreDate *string `locationName:"restoreDate" type:"string"`

	// The AWS Region where the source manual or automatic snapshot is located.
	//
	// SourceRegion is a required field
	SourceRegion RegionName `locationName:"sourceRegion" type:"string" required:"true" enum:"true"`

	// The name of the source instance or disk from which the source automatic snapshot
	// was created.
	//
	// Constraint:
	//
	//    * Define this parameter only when copying an automatic snapshot as a manual
	//    snapshot. For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
	SourceResourceName *string `locationName:"sourceResourceName" type:"string"`

	// The name of the source manual snapshot to copy.
	//
	// Constraint:
	//
	//    * Define this parameter only when copying a manual snapshot as another
	//    manual snapshot.
	SourceSnapshotName *string `locationName:"sourceSnapshotName" type:"string"`

	// The name of the new manual snapshot to be created as a copy.
	//
	// TargetSnapshotName is a required field
	TargetSnapshotName *string `locationName:"targetSnapshotName" type:"string" required:"true"`

	// A Boolean value to indicate whether to use the latest available automatic
	// snapshot of the specified source instance or disk.
	//
	// Constraints:
	//
	//    * This parameter cannot be defined together with the restore date parameter.
	//    The use latest restorable auto snapshot and restore date parameters are
	//    mutually exclusive.
	//
	//    * Define this parameter only when copying an automatic snapshot as a manual
	//    snapshot. For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots).
	UseLatestRestorableAutoSnapshot *bool `locationName:"useLatestRestorableAutoSnapshot" type:"boolean"`
}

// String returns the string representation
func (s CopySnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopySnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CopySnapshotInput"}
	if len(s.SourceRegion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SourceRegion"))
	}

	if s.TargetSnapshotName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CopySnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CopySnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Copies a manual snapshot of an instance or disk as another manual snapshot,
// or copies an automatic snapshot of an instance or disk as a manual snapshot.
// This operation can also be used to copy a manual or automatic snapshot of
// an instance or a disk from one AWS Region to another in Amazon Lightsail.
//
// When copying a manual snapshot, be sure to define the source region, source
// snapshot name, and target snapshot name parameters.
//
// When copying an automatic snapshot, be sure to define the source region,
// source resource name, target snapshot name, and either the restore date or
// the use latest restorable auto snapshot parameters.
//
//    // Example sending a request using CopySnapshotRequest.
//    req := client.CopySnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CopySnapshot
func (c *Client) CopySnapshotRequest(input *CopySnapshotInput) CopySnapshotRequest {
	op := &aws.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	req := c.newRequest(op, input, &CopySnapshotOutput{})

	return CopySnapshotRequest{Request: req, Input: input, Copy: c.CopySnapshotRequest}
}

// CopySnapshotRequest is the request type for the
// CopySnapshot API operation.
type CopySnapshotRequest struct {
	*aws.Request
	Input *CopySnapshotInput
	Copy  func(*CopySnapshotInput) CopySnapshotRequest
}

// Send marshals and sends the CopySnapshot API request.
func (r CopySnapshotRequest) Send(ctx context.Context) (*CopySnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CopySnapshotResponse{
		CopySnapshotOutput: r.Request.Data.(*CopySnapshotOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CopySnapshotResponse is the response type for the
// CopySnapshot API operation.
type CopySnapshotResponse struct {
	*CopySnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CopySnapshot request.
func (r *CopySnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
