// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateContactMethodInput struct {
	_ struct{} `type:"structure"`

	// The destination of the contact method, such as an email address or a mobile
	// phone number.
	//
	// Use the E.164 format when specifying a mobile phone number. E.164 is a standard
	// for the phone number structure used for international telecommunication.
	// Phone numbers that follow this format can have a maximum of 15 digits, and
	// they are prefixed with the plus character (+) and the country code. For example,
	// a U.S. phone number in E.164 format would be specified as +1XXX5550100. For
	// more information, see E.164 (https://en.wikipedia.org/wiki/E.164) on Wikipedia.
	//
	// ContactEndpoint is a required field
	ContactEndpoint *string `locationName:"contactEndpoint" min:"1" type:"string" required:"true"`

	// The protocol of the contact method, such as Email or SMS (text messaging).
	//
	// The SMS protocol is supported only in the following AWS Regions.
	//
	//    * US East (N. Virginia) (us-east-1)
	//
	//    * US West (Oregon) (us-west-2)
	//
	//    * Europe (Ireland) (eu-west-1)
	//
	//    * Asia Pacific (Tokyo) (ap-northeast-1)
	//
	//    * Asia Pacific (Singapore) (ap-southeast-1)
	//
	//    * Asia Pacific (Sydney) (ap-southeast-2)
	//
	// For a list of countries/regions where SMS text messages can be sent, and
	// the latest AWS Regions where SMS text messaging is supported, see Supported
	// Regions and Countries (https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html)
	// in the Amazon SNS Developer Guide.
	//
	// For more information about notifications in Amazon Lightsail, see Notifications
	// in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
	//
	// Protocol is a required field
	Protocol ContactProtocol `locationName:"protocol" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateContactMethodInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactMethodInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateContactMethodInput"}

	if s.ContactEndpoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactEndpoint"))
	}
	if s.ContactEndpoint != nil && len(*s.ContactEndpoint) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContactEndpoint", 1))
	}
	if len(s.Protocol) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateContactMethodOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateContactMethodOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateContactMethod = "CreateContactMethod"

// CreateContactMethodRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Creates an email or SMS text message contact method.
//
// A contact method is used to send you notifications about your Amazon Lightsail
// resources. You can add one email address and one mobile phone number contact
// method in each AWS Region. However, SMS text messaging is not supported in
// some AWS Regions, and SMS text messages cannot be sent to some countries/regions.
// For more information, see Notifications in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
//
//    // Example sending a request using CreateContactMethodRequest.
//    req := client.CreateContactMethodRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContactMethod
func (c *Client) CreateContactMethodRequest(input *CreateContactMethodInput) CreateContactMethodRequest {
	op := &aws.Operation{
		Name:       opCreateContactMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContactMethodInput{}
	}

	req := c.newRequest(op, input, &CreateContactMethodOutput{})

	return CreateContactMethodRequest{Request: req, Input: input, Copy: c.CreateContactMethodRequest}
}

// CreateContactMethodRequest is the request type for the
// CreateContactMethod API operation.
type CreateContactMethodRequest struct {
	*aws.Request
	Input *CreateContactMethodInput
	Copy  func(*CreateContactMethodInput) CreateContactMethodRequest
}

// Send marshals and sends the CreateContactMethod API request.
func (r CreateContactMethodRequest) Send(ctx context.Context) (*CreateContactMethodResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateContactMethodResponse{
		CreateContactMethodOutput: r.Request.Data.(*CreateContactMethodOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateContactMethodResponse is the response type for the
// CreateContactMethod API operation.
type CreateContactMethodResponse struct {
	*CreateContactMethodOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateContactMethod request.
func (r *CreateContactMethodResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
