// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteAlarmInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm to delete.
	//
	// AlarmName is a required field
	AlarmName *string `locationName:"alarmName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlarmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAlarmInput"}

	if s.AlarmName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlarmName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAlarmOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAlarm = "DeleteAlarm"

// DeleteAlarmRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Deletes an alarm.
//
// An alarm is used to monitor a single metric for one of your resources. When
// a metric condition is met, the alarm can notify you by email, SMS text message,
// and a banner displayed on the Amazon Lightsail console. For more information,
// see Alarms in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
//
//    // Example sending a request using DeleteAlarmRequest.
//    req := client.DeleteAlarmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAlarm
func (c *Client) DeleteAlarmRequest(input *DeleteAlarmInput) DeleteAlarmRequest {
	op := &aws.Operation{
		Name:       opDeleteAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAlarmInput{}
	}

	req := c.newRequest(op, input, &DeleteAlarmOutput{})

	return DeleteAlarmRequest{Request: req, Input: input, Copy: c.DeleteAlarmRequest}
}

// DeleteAlarmRequest is the request type for the
// DeleteAlarm API operation.
type DeleteAlarmRequest struct {
	*aws.Request
	Input *DeleteAlarmInput
	Copy  func(*DeleteAlarmInput) DeleteAlarmRequest
}

// Send marshals and sends the DeleteAlarm API request.
func (r DeleteAlarmRequest) Send(ctx context.Context) (*DeleteAlarmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAlarmResponse{
		DeleteAlarmOutput: r.Request.Data.(*DeleteAlarmOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAlarmResponse is the response type for the
// DeleteAlarm API operation.
type DeleteAlarmResponse struct {
	*DeleteAlarmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAlarm request.
func (r *DeleteAlarmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
