// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair to delete.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyPairInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteKeyPairInput"}

	if s.KeyPairName == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteKeyPair = "DeleteKeyPair"

// DeleteKeyPairRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Deletes a specific SSH key pair.
//
// The delete key pair operation supports tag-based access control via resource
// tags applied to the resource identified by key pair name. For more information,
// see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using DeleteKeyPairRequest.
//    req := client.DeleteKeyPairRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair
func (c *Client) DeleteKeyPairRequest(input *DeleteKeyPairInput) DeleteKeyPairRequest {
	op := &aws.Operation{
		Name:       opDeleteKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyPairInput{}
	}

	req := c.newRequest(op, input, &DeleteKeyPairOutput{})

	return DeleteKeyPairRequest{Request: req, Input: input, Copy: c.DeleteKeyPairRequest}
}

// DeleteKeyPairRequest is the request type for the
// DeleteKeyPair API operation.
type DeleteKeyPairRequest struct {
	*aws.Request
	Input *DeleteKeyPairInput
	Copy  func(*DeleteKeyPairInput) DeleteKeyPairRequest
}

// Send marshals and sends the DeleteKeyPair API request.
func (r DeleteKeyPairRequest) Send(ctx context.Context) (*DeleteKeyPairResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteKeyPairResponse{
		DeleteKeyPairOutput: r.Request.Data.(*DeleteKeyPairOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteKeyPairResponse is the response type for the
// DeleteKeyPair API operation.
type DeleteKeyPairResponse struct {
	*DeleteKeyPairOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteKeyPair request.
func (r *DeleteKeyPairResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
