// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutInstancePublicPortsInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance for which to open ports.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// An array of objects to describe the ports to open for the specified instance.
	//
	// PortInfos is a required field
	PortInfos []PortInfo `locationName:"portInfos" type:"list" required:"true"`
}

// String returns the string representation
func (s PutInstancePublicPortsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInstancePublicPortsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutInstancePublicPortsInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if s.PortInfos == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortInfos"))
	}
	if s.PortInfos != nil {
		for i, v := range s.PortInfos {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortInfos", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutInstancePublicPortsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s PutInstancePublicPortsOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutInstancePublicPorts = "PutInstancePublicPorts"

// PutInstancePublicPortsRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Opens ports for a specific Amazon Lightsail instance, and specifies the IP
// addresses allowed to connect to the instance through the ports, and the protocol.
// This action also closes all currently open ports that are not included in
// the request. Include all of the ports and the protocols you want to open
// in your PutInstancePublicPortsrequest. Or use the OpenInstancePublicPorts
// action to open ports without closing currently open ports.
//
// The PutInstancePublicPorts action supports tag-based access control via resource
// tags applied to the resource identified by instanceName. For more information,
// see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using PutInstancePublicPortsRequest.
//    req := client.PutInstancePublicPortsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts
func (c *Client) PutInstancePublicPortsRequest(input *PutInstancePublicPortsInput) PutInstancePublicPortsRequest {
	op := &aws.Operation{
		Name:       opPutInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInstancePublicPortsInput{}
	}

	req := c.newRequest(op, input, &PutInstancePublicPortsOutput{})

	return PutInstancePublicPortsRequest{Request: req, Input: input, Copy: c.PutInstancePublicPortsRequest}
}

// PutInstancePublicPortsRequest is the request type for the
// PutInstancePublicPorts API operation.
type PutInstancePublicPortsRequest struct {
	*aws.Request
	Input *PutInstancePublicPortsInput
	Copy  func(*PutInstancePublicPortsInput) PutInstancePublicPortsRequest
}

// Send marshals and sends the PutInstancePublicPorts API request.
func (r PutInstancePublicPortsRequest) Send(ctx context.Context) (*PutInstancePublicPortsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutInstancePublicPortsResponse{
		PutInstancePublicPortsOutput: r.Request.Data.(*PutInstancePublicPortsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutInstancePublicPortsResponse is the response type for the
// PutInstancePublicPorts API operation.
type PutInstancePublicPortsResponse struct {
	*PutInstancePublicPortsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutInstancePublicPorts request.
func (r *PutInstancePublicPortsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
