// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type TestAlarmInput struct {
	_ struct{} `type:"structure"`

	// The name of the alarm to test.
	//
	// AlarmName is a required field
	AlarmName *string `locationName:"alarmName" type:"string" required:"true"`

	// The alarm state to test.
	//
	// An alarm has the following possible states that can be tested:
	//
	//    * ALARM - The metric is outside of the defined threshold.
	//
	//    * INSUFFICIENT_DATA - The alarm has just started, the metric is not available,
	//    or not enough data is available for the metric to determine the alarm
	//    state.
	//
	//    * OK - The metric is within the defined threshold.
	//
	// State is a required field
	State AlarmState `locationName:"state" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TestAlarmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestAlarmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TestAlarmInput"}

	if s.AlarmName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlarmName"))
	}
	if len(s.State) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type TestAlarmOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of the action, such as the status
	// of the request, the timestamp of the request, and the resources affected
	// by the request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s TestAlarmOutput) String() string {
	return awsutil.Prettify(s)
}

const opTestAlarm = "TestAlarm"

// TestAlarmRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Tests an alarm by displaying a banner on the Amazon Lightsail console. If
// a notification trigger is configured for the specified alarm, the test also
// sends a notification to the notification protocol (Email and/or SMS) configured
// for the alarm.
//
// An alarm is used to monitor a single metric for one of your resources. When
// a metric condition is met, the alarm can notify you by email, SMS text message,
// and a banner displayed on the Amazon Lightsail console. For more information,
// see Alarms in Amazon Lightsail (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
//
//    // Example sending a request using TestAlarmRequest.
//    req := client.TestAlarmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TestAlarm
func (c *Client) TestAlarmRequest(input *TestAlarmInput) TestAlarmRequest {
	op := &aws.Operation{
		Name:       opTestAlarm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestAlarmInput{}
	}

	req := c.newRequest(op, input, &TestAlarmOutput{})

	return TestAlarmRequest{Request: req, Input: input, Copy: c.TestAlarmRequest}
}

// TestAlarmRequest is the request type for the
// TestAlarm API operation.
type TestAlarmRequest struct {
	*aws.Request
	Input *TestAlarmInput
	Copy  func(*TestAlarmInput) TestAlarmRequest
}

// Send marshals and sends the TestAlarm API request.
func (r TestAlarmRequest) Send(ctx context.Context) (*TestAlarmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TestAlarmResponse{
		TestAlarmOutput: r.Request.Data.(*TestAlarmOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TestAlarmResponse is the response type for the
// TestAlarm API operation.
type TestAlarmResponse struct {
	*TestAlarmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TestAlarm request.
func (r *TestAlarmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
