// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisassociateMemberInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateMemberInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateMemberInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateMemberInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisassociateMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateMemberOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDisassociateMember = "DisassociateMember"

// DisassociateMemberRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Disassociates an Amazon Macie master account from a member account.
//
//    // Example sending a request using DisassociateMemberRequest.
//    req := client.DisassociateMemberRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateMember
func (c *Client) DisassociateMemberRequest(input *DisassociateMemberInput) DisassociateMemberRequest {
	op := &aws.Operation{
		Name:       opDisassociateMember,
		HTTPMethod: "POST",
		HTTPPath:   "/members/disassociate/{id}",
	}

	if input == nil {
		input = &DisassociateMemberInput{}
	}

	req := c.newRequest(op, input, &DisassociateMemberOutput{})

	return DisassociateMemberRequest{Request: req, Input: input, Copy: c.DisassociateMemberRequest}
}

// DisassociateMemberRequest is the request type for the
// DisassociateMember API operation.
type DisassociateMemberRequest struct {
	*aws.Request
	Input *DisassociateMemberInput
	Copy  func(*DisassociateMemberInput) DisassociateMemberRequest
}

// Send marshals and sends the DisassociateMember API request.
func (r DisassociateMemberRequest) Send(ctx context.Context) (*DisassociateMemberResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateMemberResponse{
		DisassociateMemberOutput: r.Request.Data.(*DisassociateMemberOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateMemberResponse is the response type for the
// DisassociateMember API operation.
type DisassociateMemberResponse struct {
	*DisassociateMemberOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateMember request.
func (r *DisassociateMemberResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
