// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies criteria for paginating the results of a request for information
// about custom data identifiers.
type ListCustomDataIdentifiersInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListCustomDataIdentifiersInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListCustomDataIdentifiersInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides the results of a request for information about custom data identifiers.
type ListCustomDataIdentifiersOutput struct {
	_ struct{} `type:"structure"`

	Items []CustomDataIdentifierSummary `locationName:"items" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListCustomDataIdentifiersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListCustomDataIdentifiersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Items != nil {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListCustomDataIdentifiers = "ListCustomDataIdentifiers"

// ListCustomDataIdentifiersRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves a subset of information about all the custom data identifiers for
// an account.
//
//    // Example sending a request using ListCustomDataIdentifiersRequest.
//    req := client.ListCustomDataIdentifiersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers
func (c *Client) ListCustomDataIdentifiersRequest(input *ListCustomDataIdentifiersInput) ListCustomDataIdentifiersRequest {
	op := &aws.Operation{
		Name:       opListCustomDataIdentifiers,
		HTTPMethod: "POST",
		HTTPPath:   "/custom-data-identifiers/list",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomDataIdentifiersInput{}
	}

	req := c.newRequest(op, input, &ListCustomDataIdentifiersOutput{})

	return ListCustomDataIdentifiersRequest{Request: req, Input: input, Copy: c.ListCustomDataIdentifiersRequest}
}

// ListCustomDataIdentifiersRequest is the request type for the
// ListCustomDataIdentifiers API operation.
type ListCustomDataIdentifiersRequest struct {
	*aws.Request
	Input *ListCustomDataIdentifiersInput
	Copy  func(*ListCustomDataIdentifiersInput) ListCustomDataIdentifiersRequest
}

// Send marshals and sends the ListCustomDataIdentifiers API request.
func (r ListCustomDataIdentifiersRequest) Send(ctx context.Context) (*ListCustomDataIdentifiersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCustomDataIdentifiersResponse{
		ListCustomDataIdentifiersOutput: r.Request.Data.(*ListCustomDataIdentifiersOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListCustomDataIdentifiersRequestPaginator returns a paginator for ListCustomDataIdentifiers.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListCustomDataIdentifiersRequest(input)
//   p := macie2.NewListCustomDataIdentifiersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListCustomDataIdentifiersPaginator(req ListCustomDataIdentifiersRequest) ListCustomDataIdentifiersPaginator {
	return ListCustomDataIdentifiersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListCustomDataIdentifiersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListCustomDataIdentifiersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListCustomDataIdentifiersPaginator struct {
	aws.Pager
}

func (p *ListCustomDataIdentifiersPaginator) CurrentPage() *ListCustomDataIdentifiersOutput {
	return p.Pager.CurrentPage().(*ListCustomDataIdentifiersOutput)
}

// ListCustomDataIdentifiersResponse is the response type for the
// ListCustomDataIdentifiers API operation.
type ListCustomDataIdentifiersResponse struct {
	*ListCustomDataIdentifiersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCustomDataIdentifiers request.
func (r *ListCustomDataIdentifiersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
