// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies criteria for filtering, sorting, and paginating the results of
// a request for information about findings.
type ListFindingsInput struct {
	_ struct{} `type:"structure"`

	// Specifies, as a map, one or more property-based conditions that filter the
	// results of a query for findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies criteria for sorting the results of a request for information about
	// findings.
	SortCriteria *SortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s ListFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFindingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FindingCriteria != nil {
		v := s.FindingCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "findingCriteria", v, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SortCriteria != nil {
		v := s.SortCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sortCriteria", v, metadata)
	}
	return nil
}

// Provides the results of a request for information about one or more findings.
type ListFindingsOutput struct {
	_ struct{} `type:"structure"`

	FindingIds []string `locationName:"findingIds" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFindingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FindingIds != nil {
		v := s.FindingIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "findingIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListFindings = "ListFindings"

// ListFindingsRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves a subset of information about one or more findings.
//
//    // Example sending a request using ListFindingsRequest.
//    req := client.ListFindingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings
func (c *Client) ListFindingsRequest(input *ListFindingsInput) ListFindingsRequest {
	op := &aws.Operation{
		Name:       opListFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsInput{}
	}

	req := c.newRequest(op, input, &ListFindingsOutput{})

	return ListFindingsRequest{Request: req, Input: input, Copy: c.ListFindingsRequest}
}

// ListFindingsRequest is the request type for the
// ListFindings API operation.
type ListFindingsRequest struct {
	*aws.Request
	Input *ListFindingsInput
	Copy  func(*ListFindingsInput) ListFindingsRequest
}

// Send marshals and sends the ListFindings API request.
func (r ListFindingsRequest) Send(ctx context.Context) (*ListFindingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListFindingsResponse{
		ListFindingsOutput: r.Request.Data.(*ListFindingsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListFindingsRequestPaginator returns a paginator for ListFindings.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListFindingsRequest(input)
//   p := macie2.NewListFindingsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListFindingsPaginator(req ListFindingsRequest) ListFindingsPaginator {
	return ListFindingsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListFindingsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListFindingsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListFindingsPaginator struct {
	aws.Pager
}

func (p *ListFindingsPaginator) CurrentPage() *ListFindingsOutput {
	return p.Pager.CurrentPage().(*ListFindingsOutput)
}

// ListFindingsResponse is the response type for the
// ListFindings API operation.
type ListFindingsResponse struct {
	*ListFindingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListFindings request.
func (r *ListFindingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
