// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListFindingsFiltersInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFindingsFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsFiltersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListFindingsFiltersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFindingsFiltersInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about all the findings filters for an account.
type ListFindingsFiltersOutput struct {
	_ struct{} `type:"structure"`

	FindingsFilterListItems []FindingsFilterListItem `locationName:"findingsFilterListItems" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFindingsFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFindingsFiltersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FindingsFilterListItems != nil {
		v := s.FindingsFilterListItems

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "findingsFilterListItems", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListFindingsFilters = "ListFindingsFilters"

// ListFindingsFiltersRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves a subset of information about all the findings filters for an account.
//
//    // Example sending a request using ListFindingsFiltersRequest.
//    req := client.ListFindingsFiltersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters
func (c *Client) ListFindingsFiltersRequest(input *ListFindingsFiltersInput) ListFindingsFiltersRequest {
	op := &aws.Operation{
		Name:       opListFindingsFilters,
		HTTPMethod: "GET",
		HTTPPath:   "/findingsfilters",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsFiltersInput{}
	}

	req := c.newRequest(op, input, &ListFindingsFiltersOutput{})

	return ListFindingsFiltersRequest{Request: req, Input: input, Copy: c.ListFindingsFiltersRequest}
}

// ListFindingsFiltersRequest is the request type for the
// ListFindingsFilters API operation.
type ListFindingsFiltersRequest struct {
	*aws.Request
	Input *ListFindingsFiltersInput
	Copy  func(*ListFindingsFiltersInput) ListFindingsFiltersRequest
}

// Send marshals and sends the ListFindingsFilters API request.
func (r ListFindingsFiltersRequest) Send(ctx context.Context) (*ListFindingsFiltersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListFindingsFiltersResponse{
		ListFindingsFiltersOutput: r.Request.Data.(*ListFindingsFiltersOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListFindingsFiltersRequestPaginator returns a paginator for ListFindingsFilters.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListFindingsFiltersRequest(input)
//   p := macie2.NewListFindingsFiltersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListFindingsFiltersPaginator(req ListFindingsFiltersRequest) ListFindingsFiltersPaginator {
	return ListFindingsFiltersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListFindingsFiltersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListFindingsFiltersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListFindingsFiltersPaginator struct {
	aws.Pager
}

func (p *ListFindingsFiltersPaginator) CurrentPage() *ListFindingsFiltersOutput {
	return p.Pager.CurrentPage().(*ListFindingsFiltersOutput)
}

// ListFindingsFiltersResponse is the response type for the
// ListFindingsFilters API operation.
type ListFindingsFiltersResponse struct {
	*ListFindingsFiltersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListFindingsFilters request.
func (r *ListFindingsFiltersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
