// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies the detection criteria of a custom data identifier to test.
type TestCustomDataIdentifierInput struct {
	_ struct{} `type:"structure"`

	IgnoreWords []string `locationName:"ignoreWords" type:"list"`

	Keywords []string `locationName:"keywords" type:"list"`

	MaximumMatchDistance *int64 `locationName:"maximumMatchDistance" type:"integer"`

	// Regex is a required field
	Regex *string `locationName:"regex" type:"string" required:"true"`

	// SampleText is a required field
	SampleText *string `locationName:"sampleText" type:"string" required:"true"`
}

// String returns the string representation
func (s TestCustomDataIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestCustomDataIdentifierInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TestCustomDataIdentifierInput"}

	if s.Regex == nil {
		invalidParams.Add(aws.NewErrParamRequired("Regex"))
	}

	if s.SampleText == nil {
		invalidParams.Add(aws.NewErrParamRequired("SampleText"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TestCustomDataIdentifierInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.IgnoreWords != nil {
		v := s.IgnoreWords

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ignoreWords", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Keywords != nil {
		v := s.Keywords

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "keywords", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaximumMatchDistance != nil {
		v := *s.MaximumMatchDistance

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maximumMatchDistance", protocol.Int64Value(v), metadata)
	}
	if s.Regex != nil {
		v := *s.Regex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "regex", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SampleText != nil {
		v := *s.SampleText

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sampleText", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides test results for a custom data identifier.
type TestCustomDataIdentifierOutput struct {
	_ struct{} `type:"structure"`

	MatchCount *int64 `locationName:"matchCount" type:"integer"`
}

// String returns the string representation
func (s TestCustomDataIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TestCustomDataIdentifierOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MatchCount != nil {
		v := *s.MatchCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "matchCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opTestCustomDataIdentifier = "TestCustomDataIdentifier"

// TestCustomDataIdentifierRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Tests a custom data identifier.
//
//    // Example sending a request using TestCustomDataIdentifierRequest.
//    req := client.TestCustomDataIdentifierRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TestCustomDataIdentifier
func (c *Client) TestCustomDataIdentifierRequest(input *TestCustomDataIdentifierInput) TestCustomDataIdentifierRequest {
	op := &aws.Operation{
		Name:       opTestCustomDataIdentifier,
		HTTPMethod: "POST",
		HTTPPath:   "/custom-data-identifiers/test",
	}

	if input == nil {
		input = &TestCustomDataIdentifierInput{}
	}

	req := c.newRequest(op, input, &TestCustomDataIdentifierOutput{})

	return TestCustomDataIdentifierRequest{Request: req, Input: input, Copy: c.TestCustomDataIdentifierRequest}
}

// TestCustomDataIdentifierRequest is the request type for the
// TestCustomDataIdentifier API operation.
type TestCustomDataIdentifierRequest struct {
	*aws.Request
	Input *TestCustomDataIdentifierInput
	Copy  func(*TestCustomDataIdentifierInput) TestCustomDataIdentifierRequest
}

// Send marshals and sends the TestCustomDataIdentifier API request.
func (r TestCustomDataIdentifierRequest) Send(ctx context.Context) (*TestCustomDataIdentifierResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TestCustomDataIdentifierResponse{
		TestCustomDataIdentifierOutput: r.Request.Data.(*TestCustomDataIdentifierOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TestCustomDataIdentifierResponse is the response type for the
// TestCustomDataIdentifier API operation.
type TestCustomDataIdentifierResponse struct {
	*TestCustomDataIdentifierOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TestCustomDataIdentifier request.
func (r *TestCustomDataIdentifierResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
