// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies the criteria and other settings for a findings filter.
type UpdateFindingsFilterInput struct {
	_ struct{} `type:"structure"`

	// The action to perform on findings that meet the filter criteria. To suppress
	// (automatically archive) findings that meet the criteria, set this value to
	// ARCHIVE. Valid values are:
	Action FindingsFilterAction `locationName:"action" type:"string" enum:"true"`

	Description *string `locationName:"description" type:"string"`

	// Specifies, as a map, one or more property-based conditions that filter the
	// results of a query for findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	Name *string `locationName:"name" type:"string"`

	Position *int64 `locationName:"position" type:"integer"`
}

// String returns the string representation
func (s UpdateFindingsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFindingsFilterInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFindingsFilterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FindingCriteria != nil {
		v := s.FindingCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "findingCriteria", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "position", protocol.Int64Value(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about a findings filter that was updated in response
// to a request.
type UpdateFindingsFilterOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s UpdateFindingsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFindingsFilterOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateFindingsFilter = "UpdateFindingsFilter"

// UpdateFindingsFilterRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Updates the criteria and other settings for a findings filter.
//
//    // Example sending a request using UpdateFindingsFilterRequest.
//    req := client.UpdateFindingsFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateFindingsFilter
func (c *Client) UpdateFindingsFilterRequest(input *UpdateFindingsFilterInput) UpdateFindingsFilterRequest {
	op := &aws.Operation{
		Name:       opUpdateFindingsFilter,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findingsfilters/{id}",
	}

	if input == nil {
		input = &UpdateFindingsFilterInput{}
	}

	req := c.newRequest(op, input, &UpdateFindingsFilterOutput{})

	return UpdateFindingsFilterRequest{Request: req, Input: input, Copy: c.UpdateFindingsFilterRequest}
}

// UpdateFindingsFilterRequest is the request type for the
// UpdateFindingsFilter API operation.
type UpdateFindingsFilterRequest struct {
	*aws.Request
	Input *UpdateFindingsFilterInput
	Copy  func(*UpdateFindingsFilterInput) UpdateFindingsFilterRequest
}

// Send marshals and sends the UpdateFindingsFilter API request.
func (r UpdateFindingsFilterRequest) Send(ctx context.Context) (*UpdateFindingsFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFindingsFilterResponse{
		UpdateFindingsFilterOutput: r.Request.Data.(*UpdateFindingsFilterOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFindingsFilterResponse is the response type for the
// UpdateFindingsFilter API operation.
type UpdateFindingsFilterResponse struct {
	*UpdateFindingsFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFindingsFilter request.
func (r *UpdateFindingsFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
