// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplacecatalog

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// Array of change object.
	//
	// ChangeSet is a required field
	ChangeSet []Change `min:"1" type:"list" required:"true"`

	// Optional case sensitive string of up to 100 ASCII characters. The change
	// set name can be used to filter the list of change sets.
	ChangeSetName *string `min:"1" type:"string"`

	// A unique token to identify the request to ensure idempotency.
	ClientRequestToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChangeSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartChangeSetInput"}

	if s.Catalog == nil {
		invalidParams.Add(aws.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Catalog", 1))
	}

	if s.ChangeSet == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeSet"))
	}
	if s.ChangeSet != nil && len(s.ChangeSet) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSet", 1))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ChangeSet != nil {
		for i, v := range s.ChangeSet {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChangeSet", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartChangeSetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Catalog != nil {
		v := *s.Catalog

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Catalog", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeSet != nil {
		v := s.ChangeSet

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ChangeSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ChangeSetName != nil {
		v := *s.ChangeSetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientRequestToken != nil {
		v := *s.ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StartChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN associated to the unique identifier generated for the request.
	ChangeSetArn *string `min:"1" type:"string"`

	// Unique identifier generated for the request.
	ChangeSetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartChangeSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChangeSetArn != nil {
		v := *s.ChangeSetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeSetId != nil {
		v := *s.ChangeSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opStartChangeSet = "StartChangeSet"

// StartChangeSetRequest returns a request value for making API operation for
// AWS Marketplace Catalog Service.
//
// This operation allows you to request changes for your entities. Within a
// single ChangeSet, you cannot start the same change type against the same
// entity multiple times. Additionally, when a ChangeSet is running, all the
// entities targeted by the different changes are locked until the ChangeSet
// has completed (either succeeded, cancelled, or failed). If you try to start
// a ChangeSet containing a change against an entity that is already locked,
// you will receive a ResourceInUseException.
//
// For example, you cannot start the ChangeSet described in the example (https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_StartChangeSet.html#API_StartChangeSet_Examples)
// below because it contains two changes to execute the same change type (AddRevisions)
// against the same entity (entity-id@1).
//
//    // Example sending a request using StartChangeSetRequest.
//    req := client.StartChangeSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/StartChangeSet
func (c *Client) StartChangeSetRequest(input *StartChangeSetInput) StartChangeSetRequest {
	op := &aws.Operation{
		Name:       opStartChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/StartChangeSet",
	}

	if input == nil {
		input = &StartChangeSetInput{}
	}

	req := c.newRequest(op, input, &StartChangeSetOutput{})

	return StartChangeSetRequest{Request: req, Input: input, Copy: c.StartChangeSetRequest}
}

// StartChangeSetRequest is the request type for the
// StartChangeSet API operation.
type StartChangeSetRequest struct {
	*aws.Request
	Input *StartChangeSetInput
	Copy  func(*StartChangeSetInput) StartChangeSetRequest
}

// Send marshals and sends the StartChangeSet API request.
func (r StartChangeSetRequest) Send(ctx context.Context) (*StartChangeSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartChangeSetResponse{
		StartChangeSetOutput: r.Request.Data.(*StartChangeSetOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartChangeSetResponse is the response type for the
// StartChangeSet API operation.
type StartChangeSetResponse struct {
	*StartChangeSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartChangeSet request.
func (r *StartChangeSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
