// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateMultiplexProgramInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// Multiplex Program settings configuration.
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure"`

	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"programName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMultiplexProgramInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMultiplexProgramInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateMultiplexProgramInput"}

	if s.MultiplexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MultiplexId"))
	}

	if s.ProgramName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProgramName"))
	}
	if s.MultiplexProgramSettings != nil {
		if err := s.MultiplexProgramSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexProgramSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMultiplexProgramInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MultiplexProgramSettings != nil {
		v := s.MultiplexProgramSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "multiplexProgramSettings", v, metadata)
	}
	if s.MultiplexId != nil {
		v := *s.MultiplexId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "multiplexId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProgramName != nil {
		v := *s.ProgramName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "programName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateMultiplexProgramOutput struct {
	_ struct{} `type:"structure"`

	// The multiplex program object.
	MultiplexProgram *MultiplexProgram `locationName:"multiplexProgram" type:"structure"`
}

// String returns the string representation
func (s UpdateMultiplexProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMultiplexProgramOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MultiplexProgram != nil {
		v := s.MultiplexProgram

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "multiplexProgram", v, metadata)
	}
	return nil
}

const opUpdateMultiplexProgram = "UpdateMultiplexProgram"

// UpdateMultiplexProgramRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Update a program in a multiplex.
//
//    // Example sending a request using UpdateMultiplexProgramRequest.
//    req := client.UpdateMultiplexProgramRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram
func (c *Client) UpdateMultiplexProgramRequest(input *UpdateMultiplexProgramInput) UpdateMultiplexProgramRequest {
	op := &aws.Operation{
		Name:       opUpdateMultiplexProgram,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs/{programName}",
	}

	if input == nil {
		input = &UpdateMultiplexProgramInput{}
	}

	req := c.newRequest(op, input, &UpdateMultiplexProgramOutput{})

	return UpdateMultiplexProgramRequest{Request: req, Input: input, Copy: c.UpdateMultiplexProgramRequest}
}

// UpdateMultiplexProgramRequest is the request type for the
// UpdateMultiplexProgram API operation.
type UpdateMultiplexProgramRequest struct {
	*aws.Request
	Input *UpdateMultiplexProgramInput
	Copy  func(*UpdateMultiplexProgramInput) UpdateMultiplexProgramRequest
}

// Send marshals and sends the UpdateMultiplexProgram API request.
func (r UpdateMultiplexProgramRequest) Send(ctx context.Context) (*UpdateMultiplexProgramResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateMultiplexProgramResponse{
		UpdateMultiplexProgramOutput: r.Request.Data.(*UpdateMultiplexProgramOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateMultiplexProgramResponse is the response type for the
// UpdateMultiplexProgram API operation.
type UpdateMultiplexProgramResponse struct {
	*UpdateMultiplexProgramOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateMultiplexProgram request.
func (r *UpdateMultiplexProgramResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
