// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackage

import (
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// CDN Authorization credentials
type Authorization struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
	// Content Distribution Network (CDN) uses for authorization to access your
	// endpoint.
	//
	// CdnIdentifierSecret is a required field
	CdnIdentifierSecret *string `locationName:"cdnIdentifierSecret" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage
	// to communicate with AWS Secrets Manager.
	//
	// SecretsRoleArn is a required field
	SecretsRoleArn *string `locationName:"secretsRoleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s Authorization) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Authorization) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Authorization"}

	if s.CdnIdentifierSecret == nil {
		invalidParams.Add(aws.NewErrParamRequired("CdnIdentifierSecret"))
	}

	if s.SecretsRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretsRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Authorization) MarshalFields(e protocol.FieldEncoder) error {
	if s.CdnIdentifierSecret != nil {
		v := *s.CdnIdentifierSecret

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cdnIdentifierSecret", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecretsRoleArn != nil {
		v := *s.SecretsRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "secretsRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A Channel resource configuration.
type Channel struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the Channel.
	Arn *string `locationName:"arn" type:"string"`

	// A short text description of the Channel.
	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) ingest resource configuration.
	HlsIngest *HlsIngest `locationName:"hlsIngest" type:"structure"`

	// The ID of the Channel.
	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Channel) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HlsIngest != nil {
		v := s.HlsIngest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsIngest", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// A Common Media Application Format (CMAF) encryption configuration.
type CmafEncryption struct {
	_ struct{} `type:"structure"`

	// Time (in seconds) between each encryption key rotation.
	KeyRotationIntervalSeconds *int64 `locationName:"keyRotationIntervalSeconds" type:"integer"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation
func (s CmafEncryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CmafEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CmafEncryption"}

	if s.SpekeKeyProvider == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CmafEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.KeyRotationIntervalSeconds != nil {
		v := *s.KeyRotationIntervalSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyRotationIntervalSeconds", protocol.Int64Value(v), metadata)
	}
	if s.SpekeKeyProvider != nil {
		v := s.SpekeKeyProvider

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spekeKeyProvider", v, metadata)
	}
	return nil
}

// A Common Media Application Format (CMAF) packaging configuration.
type CmafPackage struct {
	_ struct{} `type:"structure"`

	// A Common Media Application Format (CMAF) encryption configuration.
	Encryption *CmafEncryption `locationName:"encryption" type:"structure"`

	// A list of HLS manifest configurations
	HlsManifests []HlsManifest `locationName:"hlsManifests" type:"list"`

	// Duration (in seconds) of each segment. Actual segments will berounded to
	// the nearest multiple of the source segment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// An optional custom string that is prepended to the name of each segment.
	// If not specified, it defaults to the ChannelId.
	SegmentPrefix *string `locationName:"segmentPrefix" type:"string"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`
}

// String returns the string representation
func (s CmafPackage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CmafPackage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encryption", v, metadata)
	}
	if s.HlsManifests != nil {
		v := s.HlsManifests

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "hlsManifests", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SegmentDurationSeconds != nil {
		v := *s.SegmentDurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentDurationSeconds", protocol.Int64Value(v), metadata)
	}
	if s.SegmentPrefix != nil {
		v := *s.SegmentPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamSelection != nil {
		v := s.StreamSelection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "streamSelection", v, metadata)
	}
	return nil
}

// A Common Media Application Format (CMAF) packaging configuration.
type CmafPackageCreateOrUpdateParameters struct {
	_ struct{} `type:"structure"`

	// A Common Media Application Format (CMAF) encryption configuration.
	Encryption *CmafEncryption `locationName:"encryption" type:"structure"`

	// A list of HLS manifest configurations
	HlsManifests []HlsManifestCreateOrUpdateParameters `locationName:"hlsManifests" type:"list"`

	// Duration (in seconds) of each segment. Actual segments will berounded to
	// the nearest multiple of the source segment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// An optional custom string that is prepended to the name of each segment.
	// If not specified, it defaults to the ChannelId.
	SegmentPrefix *string `locationName:"segmentPrefix" type:"string"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`
}

// String returns the string representation
func (s CmafPackageCreateOrUpdateParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CmafPackageCreateOrUpdateParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CmafPackageCreateOrUpdateParameters"}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}
	if s.HlsManifests != nil {
		for i, v := range s.HlsManifests {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HlsManifests", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CmafPackageCreateOrUpdateParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encryption", v, metadata)
	}
	if s.HlsManifests != nil {
		v := s.HlsManifests

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "hlsManifests", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SegmentDurationSeconds != nil {
		v := *s.SegmentDurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentDurationSeconds", protocol.Int64Value(v), metadata)
	}
	if s.SegmentPrefix != nil {
		v := *s.SegmentPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamSelection != nil {
		v := s.StreamSelection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "streamSelection", v, metadata)
	}
	return nil
}

// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
type DashEncryption struct {
	_ struct{} `type:"structure"`

	// Time (in seconds) between each encryption key rotation.
	KeyRotationIntervalSeconds *int64 `locationName:"keyRotationIntervalSeconds" type:"integer"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation
func (s DashEncryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DashEncryption"}

	if s.SpekeKeyProvider == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.KeyRotationIntervalSeconds != nil {
		v := *s.KeyRotationIntervalSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyRotationIntervalSeconds", protocol.Int64Value(v), metadata)
	}
	if s.SpekeKeyProvider != nil {
		v := s.SpekeKeyProvider

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spekeKeyProvider", v, metadata)
	}
	return nil
}

// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
type DashPackage struct {
	_ struct{} `type:"structure"`

	// A list of SCTE-35 message types that are treated as ad markers in the output.
	// If empty, noad markers are output. Specify multiple items to create ad markers
	// for all of the includedmessage types.
	AdTriggers []AdTriggersElement `locationName:"adTriggers" type:"list"`

	// This setting allows the delivery restriction flags on SCTE-35 segmentation
	// descriptors todetermine whether a message signals an ad. Choosing "NONE"
	// means no SCTE-35 messages becomeads. Choosing "RESTRICTED" means SCTE-35
	// messages of the types specified in AdTriggers thatcontain delivery restrictions
	// will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35messages of
	// the types specified in AdTriggers that do not contain delivery restrictions
	// willbe treated as ads. Choosing "BOTH" means all SCTE-35 messages of the
	// types specified inAdTriggers will be treated as ads. Note that Splice Insert
	// messages do not have these flagsand are always treated as ads if specified
	// in AdTriggers.
	AdsOnDeliveryRestrictions AdsOnDeliveryRestrictions `locationName:"adsOnDeliveryRestrictions" type:"string" enum:"true"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
	Encryption *DashEncryption `locationName:"encryption" type:"structure"`

	// Determines the position of some tags in the Media Presentation Description
	// (MPD). When set to FULL, elements like SegmentTemplate and ContentProtection
	// are included in each Representation. When set to COMPACT, duplicate elements
	// are combined and presented at the AdaptationSet level.
	ManifestLayout ManifestLayout `locationName:"manifestLayout" type:"string" enum:"true"`

	// Time window (in seconds) contained in each manifest.
	ManifestWindowSeconds *int64 `locationName:"manifestWindowSeconds" type:"integer"`

	// Minimum duration (in seconds) that a player will buffer media before starting
	// the presentation.
	MinBufferTimeSeconds *int64 `locationName:"minBufferTimeSeconds" type:"integer"`

	// Minimum duration (in seconds) between potential changes to the Dynamic Adaptive
	// Streaming over HTTP (DASH) Media Presentation Description (MPD).
	MinUpdatePeriodSeconds *int64 `locationName:"minUpdatePeriodSeconds" type:"integer"`

	// A list of triggers that controls when the outgoing Dynamic Adaptive Streaming
	// over HTTP (DASH)Media Presentation Description (MPD) will be partitioned
	// into multiple periods. If empty, the content will notbe partitioned into
	// more than one period. If the list contains "ADS", new periods will be created
	// wherethe Channel source contains SCTE-35 ad markers.
	PeriodTriggers []PeriodTriggersElement `locationName:"periodTriggers" type:"list"`

	// The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to
	// "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
	Profile Profile `locationName:"profile" type:"string" enum:"true"`

	// Duration (in seconds) of each segment. Actual segments will berounded to
	// the nearest multiple of the source segment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// Determines the type of SegmentTemplate included in the Media Presentation
	// Description (MPD). When set to NUMBER_WITH_TIMELINE, a full timeline is presented
	// in each SegmentTemplate, with $Number$ media URLs. When set to TIME_WITH_TIMELINE,
	// a full timeline is presented in each SegmentTemplate, with $Time$ media URLs.
	// When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate,
	// with $Number$ media URLs.
	SegmentTemplateFormat SegmentTemplateFormat `locationName:"segmentTemplateFormat" type:"string" enum:"true"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`

	// Duration (in seconds) to delay live content before presentation.
	SuggestedPresentationDelaySeconds *int64 `locationName:"suggestedPresentationDelaySeconds" type:"integer"`
}

// String returns the string representation
func (s DashPackage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashPackage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DashPackage"}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DashPackage) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdTriggers != nil {
		v := s.AdTriggers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "adTriggers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.AdsOnDeliveryRestrictions) > 0 {
		v := s.AdsOnDeliveryRestrictions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adsOnDeliveryRestrictions", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encryption", v, metadata)
	}
	if len(s.ManifestLayout) > 0 {
		v := s.ManifestLayout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "manifestLayout", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ManifestWindowSeconds != nil {
		v := *s.ManifestWindowSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "manifestWindowSeconds", protocol.Int64Value(v), metadata)
	}
	if s.MinBufferTimeSeconds != nil {
		v := *s.MinBufferTimeSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minBufferTimeSeconds", protocol.Int64Value(v), metadata)
	}
	if s.MinUpdatePeriodSeconds != nil {
		v := *s.MinUpdatePeriodSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minUpdatePeriodSeconds", protocol.Int64Value(v), metadata)
	}
	if s.PeriodTriggers != nil {
		v := s.PeriodTriggers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "periodTriggers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Profile) > 0 {
		v := s.Profile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profile", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SegmentDurationSeconds != nil {
		v := *s.SegmentDurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentDurationSeconds", protocol.Int64Value(v), metadata)
	}
	if len(s.SegmentTemplateFormat) > 0 {
		v := s.SegmentTemplateFormat

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentTemplateFormat", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StreamSelection != nil {
		v := s.StreamSelection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "streamSelection", v, metadata)
	}
	if s.SuggestedPresentationDelaySeconds != nil {
		v := *s.SuggestedPresentationDelaySeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "suggestedPresentationDelaySeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A HarvestJob resource configuration
type HarvestJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the HarvestJob.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the Channel that the HarvestJob will harvest from.
	ChannelId *string `locationName:"channelId" type:"string"`

	// The time the HarvestJob was submitted
	CreatedAt *string `locationName:"createdAt" type:"string"`

	// The end of the time-window which will be harvested.
	EndTime *string `locationName:"endTime" type:"string"`

	// The ID of the HarvestJob. The ID must be unique within the regionand it cannot
	// be changed after the HarvestJob is submitted.
	Id *string `locationName:"id" type:"string"`

	// The ID of the OriginEndpoint that the HarvestJob will harvest from.This cannot
	// be changed after the HarvestJob is submitted.
	OriginEndpointId *string `locationName:"originEndpointId" type:"string"`

	// Configuration parameters for where in an S3 bucket to place the harvested
	// content
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`

	// The start of the time-window which will be harvested.
	StartTime *string `locationName:"startTime" type:"string"`

	// The current status of the HarvestJob. Consider setting up a CloudWatch Event
	// to listen forHarvestJobs as they succeed or fail. In the event of failure,
	// the CloudWatch Event willinclude an explanation of why the HarvestJob failed.
	Status Status `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s HarvestJob) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HarvestJob) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChannelId != nil {
		v := *s.ChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginEndpointId != nil {
		v := *s.OriginEndpointId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "originEndpointId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Destination != nil {
		v := s.S3Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Destination", v, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An HTTP Live Streaming (HLS) encryption configuration.
type HlsEncryption struct {
	_ struct{} `type:"structure"`

	// A constant initialization vector for encryption (optional).When not specified
	// the initialization vector will be periodically rotated.
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// The encryption method to use.
	EncryptionMethod EncryptionMethod `locationName:"encryptionMethod" type:"string" enum:"true"`

	// Interval (in seconds) between each encryption key rotation.
	KeyRotationIntervalSeconds *int64 `locationName:"keyRotationIntervalSeconds" type:"integer"`

	// When enabled, the EXT-X-KEY tag will be repeated in output manifests.
	RepeatExtXKey *bool `locationName:"repeatExtXKey" type:"boolean"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation
func (s HlsEncryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HlsEncryption"}

	if s.SpekeKeyProvider == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConstantInitializationVector != nil {
		v := *s.ConstantInitializationVector

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "constantInitializationVector", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EncryptionMethod) > 0 {
		v := s.EncryptionMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "encryptionMethod", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.KeyRotationIntervalSeconds != nil {
		v := *s.KeyRotationIntervalSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyRotationIntervalSeconds", protocol.Int64Value(v), metadata)
	}
	if s.RepeatExtXKey != nil {
		v := *s.RepeatExtXKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "repeatExtXKey", protocol.BoolValue(v), metadata)
	}
	if s.SpekeKeyProvider != nil {
		v := s.SpekeKeyProvider

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spekeKeyProvider", v, metadata)
	}
	return nil
}

// An HTTP Live Streaming (HLS) ingest resource configuration.
type HlsIngest struct {
	_ struct{} `type:"structure"`

	// A list of endpoints to which the source stream should be sent.
	IngestEndpoints []IngestEndpoint `locationName:"ingestEndpoints" type:"list"`
}

// String returns the string representation
func (s HlsIngest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsIngest) MarshalFields(e protocol.FieldEncoder) error {
	if s.IngestEndpoints != nil {
		v := s.IngestEndpoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ingestEndpoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A HTTP Live Streaming (HLS) manifest configuration.
type HlsManifest struct {
	_ struct{} `type:"structure"`

	// This setting controls how ad markers are included in the packaged OriginEndpoint."NONE"
	// will omit all SCTE-35 ad markers from the output."PASSTHROUGH" causes the
	// manifest to contain a copy of the SCTE-35 admarkers (comments) taken directly
	// from the input HTTP Live Streaming (HLS) manifest."SCTE35_ENHANCED" generates
	// ad markers and blackout tags based on SCTE-35messages in the input source.
	AdMarkers AdMarkers `locationName:"adMarkers" type:"string" enum:"true"`

	// The ID of the manifest. The ID must be unique within the OriginEndpoint and
	// it cannot be changed after it is created.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When enabled, an I-Frame only stream will be included in the output.
	IncludeIframeOnlyStream *bool `locationName:"includeIframeOnlyStream" type:"boolean"`

	// An optional short string appended to the end of the OriginEndpoint URL. If
	// not specified, defaults to the manifestName for the OriginEndpoint.
	ManifestName *string `locationName:"manifestName" type:"string"`

	// The HTTP Live Streaming (HLS) playlist type.When either "EVENT" or "VOD"
	// is specified, a corresponding EXT-X-PLAYLIST-TYPEentry will be included in
	// the media playlist.
	PlaylistType PlaylistType `locationName:"playlistType" type:"string" enum:"true"`

	// Time window (in seconds) contained in each parent manifest.
	PlaylistWindowSeconds *int64 `locationName:"playlistWindowSeconds" type:"integer"`

	// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME taginserted
	// into manifests. Additionally, when an interval is specifiedID3Timed Metadata
	// messages will be generated every 5 seconds using theingest time of the content.If
	// the interval is not specified, or set to 0, thenno EXT-X-PROGRAM-DATE-TIME
	// tags will be inserted into manifests and noID3Timed Metadata messages will
	// be generated. Note that irrespectiveof this parameter, if any ID3 Timed Metadata
	// is found in HTTP Live Streaming (HLS) input,it will be passed through to
	// HLS output.
	ProgramDateTimeIntervalSeconds *int64 `locationName:"programDateTimeIntervalSeconds" type:"integer"`

	// The URL of the packaged OriginEndpoint for consumption.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s HlsManifest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsManifest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdMarkers) > 0 {
		v := s.AdMarkers

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adMarkers", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IncludeIframeOnlyStream != nil {
		v := *s.IncludeIframeOnlyStream

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "includeIframeOnlyStream", protocol.BoolValue(v), metadata)
	}
	if s.ManifestName != nil {
		v := *s.ManifestName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "manifestName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PlaylistType) > 0 {
		v := s.PlaylistType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "playlistType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PlaylistWindowSeconds != nil {
		v := *s.PlaylistWindowSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "playlistWindowSeconds", protocol.Int64Value(v), metadata)
	}
	if s.ProgramDateTimeIntervalSeconds != nil {
		v := *s.ProgramDateTimeIntervalSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programDateTimeIntervalSeconds", protocol.Int64Value(v), metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A HTTP Live Streaming (HLS) manifest configuration.
type HlsManifestCreateOrUpdateParameters struct {
	_ struct{} `type:"structure"`

	// This setting controls how ad markers are included in the packaged OriginEndpoint."NONE"
	// will omit all SCTE-35 ad markers from the output."PASSTHROUGH" causes the
	// manifest to contain a copy of the SCTE-35 admarkers (comments) taken directly
	// from the input HTTP Live Streaming (HLS) manifest."SCTE35_ENHANCED" generates
	// ad markers and blackout tags based on SCTE-35messages in the input source.
	AdMarkers AdMarkers `locationName:"adMarkers" type:"string" enum:"true"`

	// A list of SCTE-35 message types that are treated as ad markers in the output.
	// If empty, noad markers are output. Specify multiple items to create ad markers
	// for all of the includedmessage types.
	AdTriggers []AdTriggersElement `locationName:"adTriggers" type:"list"`

	// This setting allows the delivery restriction flags on SCTE-35 segmentation
	// descriptors todetermine whether a message signals an ad. Choosing "NONE"
	// means no SCTE-35 messages becomeads. Choosing "RESTRICTED" means SCTE-35
	// messages of the types specified in AdTriggers thatcontain delivery restrictions
	// will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35messages of
	// the types specified in AdTriggers that do not contain delivery restrictions
	// willbe treated as ads. Choosing "BOTH" means all SCTE-35 messages of the
	// types specified inAdTriggers will be treated as ads. Note that Splice Insert
	// messages do not have these flagsand are always treated as ads if specified
	// in AdTriggers.
	AdsOnDeliveryRestrictions AdsOnDeliveryRestrictions `locationName:"adsOnDeliveryRestrictions" type:"string" enum:"true"`

	// The ID of the manifest. The ID must be unique within the OriginEndpoint and
	// it cannot be changed after it is created.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When enabled, an I-Frame only stream will be included in the output.
	IncludeIframeOnlyStream *bool `locationName:"includeIframeOnlyStream" type:"boolean"`

	// An optional short string appended to the end of the OriginEndpoint URL. If
	// not specified, defaults to the manifestName for the OriginEndpoint.
	ManifestName *string `locationName:"manifestName" type:"string"`

	// The HTTP Live Streaming (HLS) playlist type.When either "EVENT" or "VOD"
	// is specified, a corresponding EXT-X-PLAYLIST-TYPEentry will be included in
	// the media playlist.
	PlaylistType PlaylistType `locationName:"playlistType" type:"string" enum:"true"`

	// Time window (in seconds) contained in each parent manifest.
	PlaylistWindowSeconds *int64 `locationName:"playlistWindowSeconds" type:"integer"`

	// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME taginserted
	// into manifests. Additionally, when an interval is specifiedID3Timed Metadata
	// messages will be generated every 5 seconds using theingest time of the content.If
	// the interval is not specified, or set to 0, thenno EXT-X-PROGRAM-DATE-TIME
	// tags will be inserted into manifests and noID3Timed Metadata messages will
	// be generated. Note that irrespectiveof this parameter, if any ID3 Timed Metadata
	// is found in HTTP Live Streaming (HLS) input,it will be passed through to
	// HLS output.
	ProgramDateTimeIntervalSeconds *int64 `locationName:"programDateTimeIntervalSeconds" type:"integer"`
}

// String returns the string representation
func (s HlsManifestCreateOrUpdateParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsManifestCreateOrUpdateParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HlsManifestCreateOrUpdateParameters"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsManifestCreateOrUpdateParameters) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdMarkers) > 0 {
		v := s.AdMarkers

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adMarkers", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AdTriggers != nil {
		v := s.AdTriggers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "adTriggers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.AdsOnDeliveryRestrictions) > 0 {
		v := s.AdsOnDeliveryRestrictions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adsOnDeliveryRestrictions", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IncludeIframeOnlyStream != nil {
		v := *s.IncludeIframeOnlyStream

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "includeIframeOnlyStream", protocol.BoolValue(v), metadata)
	}
	if s.ManifestName != nil {
		v := *s.ManifestName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "manifestName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PlaylistType) > 0 {
		v := s.PlaylistType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "playlistType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PlaylistWindowSeconds != nil {
		v := *s.PlaylistWindowSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "playlistWindowSeconds", protocol.Int64Value(v), metadata)
	}
	if s.ProgramDateTimeIntervalSeconds != nil {
		v := *s.ProgramDateTimeIntervalSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programDateTimeIntervalSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An HTTP Live Streaming (HLS) packaging configuration.
type HlsPackage struct {
	_ struct{} `type:"structure"`

	// This setting controls how ad markers are included in the packaged OriginEndpoint."NONE"
	// will omit all SCTE-35 ad markers from the output."PASSTHROUGH" causes the
	// manifest to contain a copy of the SCTE-35 admarkers (comments) taken directly
	// from the input HTTP Live Streaming (HLS) manifest."SCTE35_ENHANCED" generates
	// ad markers and blackout tags based on SCTE-35messages in the input source.
	AdMarkers AdMarkers `locationName:"adMarkers" type:"string" enum:"true"`

	// A list of SCTE-35 message types that are treated as ad markers in the output.
	// If empty, noad markers are output. Specify multiple items to create ad markers
	// for all of the includedmessage types.
	AdTriggers []AdTriggersElement `locationName:"adTriggers" type:"list"`

	// This setting allows the delivery restriction flags on SCTE-35 segmentation
	// descriptors todetermine whether a message signals an ad. Choosing "NONE"
	// means no SCTE-35 messages becomeads. Choosing "RESTRICTED" means SCTE-35
	// messages of the types specified in AdTriggers thatcontain delivery restrictions
	// will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35messages of
	// the types specified in AdTriggers that do not contain delivery restrictions
	// willbe treated as ads. Choosing "BOTH" means all SCTE-35 messages of the
	// types specified inAdTriggers will be treated as ads. Note that Splice Insert
	// messages do not have these flagsand are always treated as ads if specified
	// in AdTriggers.
	AdsOnDeliveryRestrictions AdsOnDeliveryRestrictions `locationName:"adsOnDeliveryRestrictions" type:"string" enum:"true"`

	// An HTTP Live Streaming (HLS) encryption configuration.
	Encryption *HlsEncryption `locationName:"encryption" type:"structure"`

	// When enabled, an I-Frame only stream will be included in the output.
	IncludeIframeOnlyStream *bool `locationName:"includeIframeOnlyStream" type:"boolean"`

	// The HTTP Live Streaming (HLS) playlist type.When either "EVENT" or "VOD"
	// is specified, a corresponding EXT-X-PLAYLIST-TYPEentry will be included in
	// the media playlist.
	PlaylistType PlaylistType `locationName:"playlistType" type:"string" enum:"true"`

	// Time window (in seconds) contained in each parent manifest.
	PlaylistWindowSeconds *int64 `locationName:"playlistWindowSeconds" type:"integer"`

	// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME taginserted
	// into manifests. Additionally, when an interval is specifiedID3Timed Metadata
	// messages will be generated every 5 seconds using theingest time of the content.If
	// the interval is not specified, or set to 0, thenno EXT-X-PROGRAM-DATE-TIME
	// tags will be inserted into manifests and noID3Timed Metadata messages will
	// be generated. Note that irrespectiveof this parameter, if any ID3 Timed Metadata
	// is found in HTTP Live Streaming (HLS) input,it will be passed through to
	// HLS output.
	ProgramDateTimeIntervalSeconds *int64 `locationName:"programDateTimeIntervalSeconds" type:"integer"`

	// Duration (in seconds) of each fragment. Actual fragments will berounded to
	// the nearest multiple of the source fragment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`

	// When enabled, audio streams will be placed in rendition groups in the output.
	UseAudioRenditionGroup *bool `locationName:"useAudioRenditionGroup" type:"boolean"`
}

// String returns the string representation
func (s HlsPackage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsPackage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HlsPackage"}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsPackage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdMarkers) > 0 {
		v := s.AdMarkers

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adMarkers", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AdTriggers != nil {
		v := s.AdTriggers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "adTriggers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.AdsOnDeliveryRestrictions) > 0 {
		v := s.AdsOnDeliveryRestrictions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adsOnDeliveryRestrictions", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encryption", v, metadata)
	}
	if s.IncludeIframeOnlyStream != nil {
		v := *s.IncludeIframeOnlyStream

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "includeIframeOnlyStream", protocol.BoolValue(v), metadata)
	}
	if len(s.PlaylistType) > 0 {
		v := s.PlaylistType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "playlistType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PlaylistWindowSeconds != nil {
		v := *s.PlaylistWindowSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "playlistWindowSeconds", protocol.Int64Value(v), metadata)
	}
	if s.ProgramDateTimeIntervalSeconds != nil {
		v := *s.ProgramDateTimeIntervalSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programDateTimeIntervalSeconds", protocol.Int64Value(v), metadata)
	}
	if s.SegmentDurationSeconds != nil {
		v := *s.SegmentDurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentDurationSeconds", protocol.Int64Value(v), metadata)
	}
	if s.StreamSelection != nil {
		v := s.StreamSelection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "streamSelection", v, metadata)
	}
	if s.UseAudioRenditionGroup != nil {
		v := *s.UseAudioRenditionGroup

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "useAudioRenditionGroup", protocol.BoolValue(v), metadata)
	}
	return nil
}

// An endpoint for ingesting source content for a Channel.
type IngestEndpoint struct {
	_ struct{} `type:"structure"`

	// The system generated unique identifier for the IngestEndpoint
	Id *string `locationName:"id" type:"string"`

	// The system generated password for ingest authentication.
	Password *string `locationName:"password" type:"string"`

	// The ingest URL to which the source stream should be sent.
	Url *string `locationName:"url" type:"string"`

	// The system generated username for ingest authentication.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s IngestEndpoint) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IngestEndpoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Password != nil {
		v := *s.Password

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "password", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A Microsoft Smooth Streaming (MSS) encryption configuration.
type MssEncryption struct {
	_ struct{} `type:"structure"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation
func (s MssEncryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MssEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MssEncryption"}

	if s.SpekeKeyProvider == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MssEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.SpekeKeyProvider != nil {
		v := s.SpekeKeyProvider

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spekeKeyProvider", v, metadata)
	}
	return nil
}

// A Microsoft Smooth Streaming (MSS) packaging configuration.
type MssPackage struct {
	_ struct{} `type:"structure"`

	// A Microsoft Smooth Streaming (MSS) encryption configuration.
	Encryption *MssEncryption `locationName:"encryption" type:"structure"`

	// The time window (in seconds) contained in each manifest.
	ManifestWindowSeconds *int64 `locationName:"manifestWindowSeconds" type:"integer"`

	// The duration (in seconds) of each segment.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`
}

// String returns the string representation
func (s MssPackage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MssPackage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MssPackage"}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MssPackage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encryption", v, metadata)
	}
	if s.ManifestWindowSeconds != nil {
		v := *s.ManifestWindowSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "manifestWindowSeconds", protocol.Int64Value(v), metadata)
	}
	if s.SegmentDurationSeconds != nil {
		v := *s.SegmentDurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentDurationSeconds", protocol.Int64Value(v), metadata)
	}
	if s.StreamSelection != nil {
		v := s.StreamSelection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "streamSelection", v, metadata)
	}
	return nil
}

// An OriginEndpoint resource configuration.
type OriginEndpoint struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	// The ID of the Channel the OriginEndpoint is associated with.
	ChannelId *string `locationName:"channelId" type:"string"`

	// A Common Media Application Format (CMAF) packaging configuration.
	CmafPackage *CmafPackage `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	// A short text description of the OriginEndpoint.
	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	// The ID of the OriginEndpoint.
	Id *string `locationName:"id" type:"string"`

	// A short string appended to the end of the OriginEndpoint URL.
	ManifestName *string `locationName:"manifestName" type:"string"`

	// A Microsoft Smooth Streaming (MSS) packaging configuration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	// Control whether origination of video is allowed for this OriginEndpoint.
	// If set to ALLOW, the OriginEndpointmay by requested, pursuant to any other
	// form of access control. If set to DENY, the OriginEndpoint may not berequested.
	// This can be helpful for Live to VOD harvesting, or for temporarily disabling
	// origination
	Origination Origination `locationName:"origination" type:"string" enum:"true"`

	// Maximum duration (seconds) of content to retain for startover playback.If
	// not specified, startover playback will be disabled for the OriginEndpoint.
	StartoverWindowSeconds *int64 `locationName:"startoverWindowSeconds" type:"integer"`

	// A collection of tags associated with a resource
	Tags map[string]string `locationName:"tags" type:"map"`

	// Amount of delay (seconds) to enforce on the playback of live content.If not
	// specified, there will be no time delay in effect for the OriginEndpoint.
	TimeDelaySeconds *int64 `locationName:"timeDelaySeconds" type:"integer"`

	// The URL of the packaged OriginEndpoint for consumption.
	Url *string `locationName:"url" type:"string"`

	// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
	Whitelist []string `locationName:"whitelist" type:"list"`
}

// String returns the string representation
func (s OriginEndpoint) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginEndpoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Authorization != nil {
		v := s.Authorization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "authorization", v, metadata)
	}
	if s.ChannelId != nil {
		v := *s.ChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CmafPackage != nil {
		v := s.CmafPackage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "cmafPackage", v, metadata)
	}
	if s.DashPackage != nil {
		v := s.DashPackage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dashPackage", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HlsPackage != nil {
		v := s.HlsPackage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsPackage", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ManifestName != nil {
		v := *s.ManifestName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "manifestName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MssPackage != nil {
		v := s.MssPackage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "mssPackage", v, metadata)
	}
	if len(s.Origination) > 0 {
		v := s.Origination

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "origination", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartoverWindowSeconds != nil {
		v := *s.StartoverWindowSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startoverWindowSeconds", protocol.Int64Value(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TimeDelaySeconds != nil {
		v := *s.TimeDelaySeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeDelaySeconds", protocol.Int64Value(v), metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Whitelist != nil {
		v := s.Whitelist

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "whitelist", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Configuration parameters for where in an S3 bucket to place the harvested
// content
type S3Destination struct {
	_ struct{} `type:"structure"`

	// The name of an S3 bucket within which harvested content will be exported
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The key in the specified S3 bucket where the harvested top-level manifest
	// will be placed.
	//
	// ManifestKey is a required field
	ManifestKey *string `locationName:"manifestKey" type:"string" required:"true"`

	// The IAM role used to write to the specified S3 bucket
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Destination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Destination"}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}

	if s.ManifestKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("ManifestKey"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Destination) MarshalFields(e protocol.FieldEncoder) error {
	if s.BucketName != nil {
		v := *s.BucketName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucketName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ManifestKey != nil {
		v := *s.ManifestKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "manifestKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A configuration for accessing an external Secure Packager and Encoder Key
// Exchange (SPEKE) service that will provide encryption keys.
type SpekeKeyProvider struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) of a Certificate Manager certificatethat MediaPackage
	// will use for enforcing secure end-to-end datatransfer with the key provider
	// service.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The resource ID to include in key requests.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// An Amazon Resource Name (ARN) of an IAM role that AWS ElementalMediaPackage
	// will assume when accessing the key provider service.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The system IDs to include in key requests.
	//
	// SystemIds is a required field
	SystemIds []string `locationName:"systemIds" type:"list" required:"true"`

	// The URL of the external key provider service.
	//
	// Url is a required field
	Url *string `locationName:"url" type:"string" required:"true"`
}

// String returns the string representation
func (s SpekeKeyProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpekeKeyProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SpekeKeyProvider"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if s.SystemIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SystemIds"))
	}

	if s.Url == nil {
		invalidParams.Add(aws.NewErrParamRequired("Url"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SpekeKeyProvider) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SystemIds != nil {
		v := s.SystemIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "systemIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A StreamSelection configuration.
type StreamSelection struct {
	_ struct{} `type:"structure"`

	// The maximum video bitrate (bps) to include in output.
	MaxVideoBitsPerSecond *int64 `locationName:"maxVideoBitsPerSecond" type:"integer"`

	// The minimum video bitrate (bps) to include in output.
	MinVideoBitsPerSecond *int64 `locationName:"minVideoBitsPerSecond" type:"integer"`

	// A directive that determines the order of streams in the output.
	StreamOrder StreamOrder `locationName:"streamOrder" type:"string" enum:"true"`
}

// String returns the string representation
func (s StreamSelection) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamSelection) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxVideoBitsPerSecond != nil {
		v := *s.MaxVideoBitsPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxVideoBitsPerSecond", protocol.Int64Value(v), metadata)
	}
	if s.MinVideoBitsPerSecond != nil {
		v := *s.MinVideoBitsPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minVideoBitsPerSecond", protocol.Int64Value(v), metadata)
	}
	if len(s.StreamOrder) > 0 {
		v := s.StreamOrder

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamOrder", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
