// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListHITsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListHITsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHITsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListHITsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListHITsOutput struct {
	_ struct{} `type:"structure"`

	// The list of HIT elements returned by the query.
	HITs []HIT `type:"list"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of HITs on this page in the filtered results list, equivalent
	// to the number of HITs being returned by this call.
	NumResults *int64 `type:"integer"`
}

// String returns the string representation
func (s ListHITsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListHITs = "ListHITs"

// ListHITsRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The ListHITs operation returns all of a Requester's HITs. The operation returns
// HITs of any status, except for HITs that have been deleted of with the DeleteHIT
// operation or that have been auto-deleted.
//
//    // Example sending a request using ListHITsRequest.
//    req := client.ListHITsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITs
func (c *Client) ListHITsRequest(input *ListHITsInput) ListHITsRequest {
	op := &aws.Operation{
		Name:       opListHITs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHITsInput{}
	}

	req := c.newRequest(op, input, &ListHITsOutput{})

	return ListHITsRequest{Request: req, Input: input, Copy: c.ListHITsRequest}
}

// ListHITsRequest is the request type for the
// ListHITs API operation.
type ListHITsRequest struct {
	*aws.Request
	Input *ListHITsInput
	Copy  func(*ListHITsInput) ListHITsRequest
}

// Send marshals and sends the ListHITs API request.
func (r ListHITsRequest) Send(ctx context.Context) (*ListHITsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListHITsResponse{
		ListHITsOutput: r.Request.Data.(*ListHITsOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListHITsRequestPaginator returns a paginator for ListHITs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListHITsRequest(input)
//   p := mturk.NewListHITsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListHITsPaginator(req ListHITsRequest) ListHITsPaginator {
	return ListHITsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListHITsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListHITsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListHITsPaginator struct {
	aws.Pager
}

func (p *ListHITsPaginator) CurrentPage() *ListHITsOutput {
	return p.Pager.CurrentPage().(*ListHITsOutput)
}

// ListHITsResponse is the response type for the
// ListHITs API operation.
type ListHITsResponse struct {
	*ListHITsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListHITs request.
func (r *ListHITsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
