// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateSiteInput struct {
	_ struct{} `type:"structure"`

	// A description of your site.
	//
	// Length Constraints: Maximum length of 256 characters.
	Description *string `type:"string"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The site location:
	//
	//    * Address: The physical address of the site.
	//
	//    * Latitude: The latitude of the site.
	//
	//    * Longitude: The longitude of the site.
	Location *Location `type:"structure"`

	// The ID of your site.
	//
	// SiteId is a required field
	SiteId *string `location:"uri" locationName:"siteId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSiteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSiteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateSiteInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if s.SiteId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SiteId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSiteInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "siteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateSiteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the site.
	Site *Site `type:"structure"`
}

// String returns the string representation
func (s UpdateSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSiteOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Site != nil {
		v := s.Site

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Site", v, metadata)
	}
	return nil
}

const opUpdateSite = "UpdateSite"

// UpdateSiteRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Updates the information for an existing site. To remove information for any
// of the parameters, specify an empty string.
//
//    // Example sending a request using UpdateSiteRequest.
//    req := client.UpdateSiteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateSite
func (c *Client) UpdateSiteRequest(input *UpdateSiteInput) UpdateSiteRequest {
	op := &aws.Operation{
		Name:       opUpdateSite,
		HTTPMethod: "PATCH",
		HTTPPath:   "/global-networks/{globalNetworkId}/sites/{siteId}",
	}

	if input == nil {
		input = &UpdateSiteInput{}
	}

	req := c.newRequest(op, input, &UpdateSiteOutput{})

	return UpdateSiteRequest{Request: req, Input: input, Copy: c.UpdateSiteRequest}
}

// UpdateSiteRequest is the request type for the
// UpdateSite API operation.
type UpdateSiteRequest struct {
	*aws.Request
	Input *UpdateSiteInput
	Copy  func(*UpdateSiteInput) UpdateSiteRequest
}

// Send marshals and sends the UpdateSite API request.
func (r UpdateSiteRequest) Send(ctx context.Context) (*UpdateSiteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateSiteResponse{
		UpdateSiteOutput: r.Request.Data.(*UpdateSiteOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateSiteResponse is the response type for the
// UpdateSite API operation.
type UpdateSiteResponse struct {
	*UpdateSiteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateSite request.
func (r *UpdateSiteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
