// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeregisterVolumeInput struct {
	_ struct{} `type:"structure"`

	// The AWS OpsWorks Stacks volume ID, which is the GUID that AWS OpsWorks Stacks
	// assigned to the instance when you registered the volume with the stack, not
	// the Amazon EC2 volume ID.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterVolumeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterVolumeInput"}

	if s.VolumeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterVolume = "DeregisterVolume"

// DeregisterVolumeRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Deregisters an Amazon EBS volume. The volume can then be registered by another
// stack. For more information, see Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DeregisterVolumeRequest.
//    req := client.DeregisterVolumeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterVolume
func (c *Client) DeregisterVolumeRequest(input *DeregisterVolumeInput) DeregisterVolumeRequest {
	op := &aws.Operation{
		Name:       opDeregisterVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterVolumeInput{}
	}

	req := c.newRequest(op, input, &DeregisterVolumeOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeregisterVolumeRequest{Request: req, Input: input, Copy: c.DeregisterVolumeRequest}
}

// DeregisterVolumeRequest is the request type for the
// DeregisterVolume API operation.
type DeregisterVolumeRequest struct {
	*aws.Request
	Input *DeregisterVolumeInput
	Copy  func(*DeregisterVolumeInput) DeregisterVolumeRequest
}

// Send marshals and sends the DeregisterVolume API request.
func (r DeregisterVolumeRequest) Send(ctx context.Context) (*DeregisterVolumeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterVolumeResponse{
		DeregisterVolumeOutput: r.Request.Data.(*DeregisterVolumeOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterVolumeResponse is the response type for the
// DeregisterVolume API operation.
type DeregisterVolumeResponse struct {
	*DeregisterVolumeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterVolume request.
func (r *DeregisterVolumeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
