// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteCampaignInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign to delete.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCampaignInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCampaignInput"}

	if s.CampaignArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CampaignArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteCampaignOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteCampaign = "DeleteCampaign"

// DeleteCampaignRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Removes a campaign by deleting the solution deployment. The solution that
// the campaign is based on is not deleted and can be redeployed when needed.
// A deleted campaign can no longer be specified in a GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// request. For more information on campaigns, see CreateCampaign.
//
//    // Example sending a request using DeleteCampaignRequest.
//    req := client.DeleteCampaignRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteCampaign
func (c *Client) DeleteCampaignRequest(input *DeleteCampaignInput) DeleteCampaignRequest {
	op := &aws.Operation{
		Name:       opDeleteCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCampaignInput{}
	}

	req := c.newRequest(op, input, &DeleteCampaignOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteCampaignRequest{Request: req, Input: input, Copy: c.DeleteCampaignRequest}
}

// DeleteCampaignRequest is the request type for the
// DeleteCampaign API operation.
type DeleteCampaignRequest struct {
	*aws.Request
	Input *DeleteCampaignInput
	Copy  func(*DeleteCampaignInput) DeleteCampaignRequest
}

// Send marshals and sends the DeleteCampaign API request.
func (r DeleteCampaignRequest) Send(ctx context.Context) (*DeleteCampaignResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCampaignResponse{
		DeleteCampaignOutput: r.Request.Data.(*DeleteCampaignOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCampaignResponse is the response type for the
// DeleteCampaign API operation.
type DeleteCampaignResponse struct {
	*DeleteCampaignOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCampaign request.
func (r *DeleteCampaignResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
