// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDatasetsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group that contains the datasets
	// to list.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of datasets to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListDatasetImportJobs for getting
	// the next set of dataset import jobs (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Dataset objects. Each object provides metadata information.
	Datasets []DatasetSummary `locationName:"datasets" type:"list"`

	// A token for getting the next set of datasets (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Returns the list of datasets contained in the given dataset group. The response
// provides the properties for each dataset, including the Amazon Resource Name
// (ARN). For more information on datasets, see CreateDataset.
//
//    // Example sending a request using ListDatasetsRequest.
//    req := client.ListDatasetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets
func (c *Client) ListDatasetsRequest(input *ListDatasetsInput) ListDatasetsRequest {
	op := &aws.Operation{
		Name:       opListDatasets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	req := c.newRequest(op, input, &ListDatasetsOutput{})

	return ListDatasetsRequest{Request: req, Input: input, Copy: c.ListDatasetsRequest}
}

// ListDatasetsRequest is the request type for the
// ListDatasets API operation.
type ListDatasetsRequest struct {
	*aws.Request
	Input *ListDatasetsInput
	Copy  func(*ListDatasetsInput) ListDatasetsRequest
}

// Send marshals and sends the ListDatasets API request.
func (r ListDatasetsRequest) Send(ctx context.Context) (*ListDatasetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDatasetsResponse{
		ListDatasetsOutput: r.Request.Data.(*ListDatasetsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDatasetsRequestPaginator returns a paginator for ListDatasets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDatasetsRequest(input)
//   p := personalize.NewListDatasetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDatasetsPaginator(req ListDatasetsRequest) ListDatasetsPaginator {
	return ListDatasetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDatasetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDatasetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDatasetsPaginator struct {
	aws.Pager
}

func (p *ListDatasetsPaginator) CurrentPage() *ListDatasetsOutput {
	return p.Pager.CurrentPage().(*ListDatasetsOutput)
}

// ListDatasetsResponse is the response type for the
// ListDatasets API operation.
type ListDatasetsResponse struct {
	*ListDatasetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDatasets request.
func (r *ListDatasetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
