// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListRecipesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of recipes to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListRecipes for getting the next
	// set of recipes (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// The default is SERVICE.
	RecipeProvider RecipeProvider `locationName:"recipeProvider" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListRecipesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecipesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRecipesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListRecipesOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of recipes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of available recipes.
	Recipes []RecipeSummary `locationName:"recipes" type:"list"`
}

// String returns the string representation
func (s ListRecipesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListRecipes = "ListRecipes"

// ListRecipesRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Returns a list of available recipes. The response provides the properties
// for each recipe, including the recipe's Amazon Resource Name (ARN).
//
//    // Example sending a request using ListRecipesRequest.
//    req := client.ListRecipesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes
func (c *Client) ListRecipesRequest(input *ListRecipesInput) ListRecipesRequest {
	op := &aws.Operation{
		Name:       opListRecipes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecipesInput{}
	}

	req := c.newRequest(op, input, &ListRecipesOutput{})

	return ListRecipesRequest{Request: req, Input: input, Copy: c.ListRecipesRequest}
}

// ListRecipesRequest is the request type for the
// ListRecipes API operation.
type ListRecipesRequest struct {
	*aws.Request
	Input *ListRecipesInput
	Copy  func(*ListRecipesInput) ListRecipesRequest
}

// Send marshals and sends the ListRecipes API request.
func (r ListRecipesRequest) Send(ctx context.Context) (*ListRecipesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRecipesResponse{
		ListRecipesOutput: r.Request.Data.(*ListRecipesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRecipesRequestPaginator returns a paginator for ListRecipes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRecipesRequest(input)
//   p := personalize.NewListRecipesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRecipesPaginator(req ListRecipesRequest) ListRecipesPaginator {
	return ListRecipesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRecipesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRecipesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRecipesPaginator struct {
	aws.Pager
}

func (p *ListRecipesPaginator) CurrentPage() *ListRecipesOutput {
	return p.Pager.CurrentPage().(*ListRecipesOutput)
}

// ListRecipesResponse is the response type for the
// ListRecipes API operation.
type ListRecipesResponse struct {
	*ListRecipesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRecipes request.
func (r *ListRecipesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
