// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListSolutionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string"`

	// The maximum number of solutions to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token returned from the previous call to ListSolutions for getting the
	// next set of solutions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSolutionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSolutionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSolutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListSolutionsOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of solutions (if they exist).
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of the current solutions.
	Solutions []SolutionSummary `locationName:"solutions" type:"list"`
}

// String returns the string representation
func (s ListSolutionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSolutions = "ListSolutions"

// ListSolutionsRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Returns a list of solutions that use the given dataset group. When a dataset
// group is not specified, all the solutions associated with the account are
// listed. The response provides the properties for each solution, including
// the Amazon Resource Name (ARN). For more information on solutions, see CreateSolution.
//
//    // Example sending a request using ListSolutionsRequest.
//    req := client.ListSolutionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions
func (c *Client) ListSolutionsRequest(input *ListSolutionsInput) ListSolutionsRequest {
	op := &aws.Operation{
		Name:       opListSolutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSolutionsInput{}
	}

	req := c.newRequest(op, input, &ListSolutionsOutput{})

	return ListSolutionsRequest{Request: req, Input: input, Copy: c.ListSolutionsRequest}
}

// ListSolutionsRequest is the request type for the
// ListSolutions API operation.
type ListSolutionsRequest struct {
	*aws.Request
	Input *ListSolutionsInput
	Copy  func(*ListSolutionsInput) ListSolutionsRequest
}

// Send marshals and sends the ListSolutions API request.
func (r ListSolutionsRequest) Send(ctx context.Context) (*ListSolutionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSolutionsResponse{
		ListSolutionsOutput: r.Request.Data.(*ListSolutionsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSolutionsRequestPaginator returns a paginator for ListSolutions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSolutionsRequest(input)
//   p := personalize.NewListSolutionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSolutionsPaginator(req ListSolutionsRequest) ListSolutionsPaginator {
	return ListSolutionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSolutionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSolutionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSolutionsPaginator struct {
	aws.Pager
}

func (p *ListSolutionsPaginator) CurrentPage() *ListSolutionsOutput {
	return p.Pager.CurrentPage().(*ListSolutionsOutput)
}

// ListSolutionsResponse is the response type for the
// ListSolutions API operation.
type ListSolutionsResponse struct {
	*ListSolutionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSolutions request.
func (r *ListSolutionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
