// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalizeruntime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`

	// The contextual metadata to use when getting recommendations. Contextual metadata
	// includes any interaction information that might be relevant when getting
	// a user's recommendations, such as the user's current location or device type.
	Context map[string]string `locationName:"context" type:"map"`

	// The ARN of the filter to apply to the returned recommendations. For more
	// information, see Using Filters with Amazon Personalize.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The item ID to provide recommendations for.
	//
	// Required for RELATED_ITEMS recipe type.
	ItemId *string `locationName:"itemId" type:"string"`

	// The number of results to return. The default is 25. The maximum is 500.
	NumResults *int64 `locationName:"numResults" type:"integer"`

	// The user ID to provide recommendations for.
	//
	// Required for USER_PERSONALIZATION recipe type.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s GetRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecommendationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRecommendationsInput"}

	if s.CampaignArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CampaignArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRecommendationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CampaignArn != nil {
		v := *s.CampaignArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "campaignArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Context != nil {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.FilterArn != nil {
		v := *s.FilterArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "filterArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ItemId != nil {
		v := *s.ItemId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "itemId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NumResults != nil {
		v := *s.NumResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numResults", protocol.Int64Value(v), metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of recommendations sorted in ascending order by prediction score.
	// There can be a maximum of 500 items in the list.
	ItemList []PredictedItem `locationName:"itemList" type:"list"`
}

// String returns the string representation
func (s GetRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRecommendationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ItemList != nil {
		v := s.ItemList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "itemList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetRecommendations = "GetRecommendations"

// GetRecommendationsRequest returns a request value for making API operation for
// Amazon Personalize Runtime.
//
// Returns a list of recommended items. The required input depends on the recipe
// type used to create the solution backing the campaign, as follows:
//
//    * RELATED_ITEMS - itemId required, userId not used
//
//    * USER_PERSONALIZATION - itemId optional, userId required
//
// Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING
// use the API.
//
//    // Example sending a request using GetRecommendationsRequest.
//    req := client.GetRecommendationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetRecommendations
func (c *Client) GetRecommendationsRequest(input *GetRecommendationsInput) GetRecommendationsRequest {
	op := &aws.Operation{
		Name:       opGetRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/recommendations",
	}

	if input == nil {
		input = &GetRecommendationsInput{}
	}

	req := c.newRequest(op, input, &GetRecommendationsOutput{})

	return GetRecommendationsRequest{Request: req, Input: input, Copy: c.GetRecommendationsRequest}
}

// GetRecommendationsRequest is the request type for the
// GetRecommendations API operation.
type GetRecommendationsRequest struct {
	*aws.Request
	Input *GetRecommendationsInput
	Copy  func(*GetRecommendationsInput) GetRecommendationsRequest
}

// Send marshals and sends the GetRecommendations API request.
func (r GetRecommendationsRequest) Send(ctx context.Context) (*GetRecommendationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRecommendationsResponse{
		GetRecommendationsOutput: r.Request.Data.(*GetRecommendationsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRecommendationsResponse is the response type for the
// GetRecommendations API operation.
type GetRecommendationsResponse struct {
	*GetRecommendationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRecommendations request.
func (r *GetRecommendationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
