// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetBaiduChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBaiduChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBaiduChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBaiduChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBaiduChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetBaiduChannelOutput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelResponse"`

	// Provides information about the status and settings of the Baidu (Baidu Cloud
	// Push) channel for an application.
	//
	// BaiduChannelResponse is a required field
	BaiduChannelResponse *BaiduChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetBaiduChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBaiduChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BaiduChannelResponse != nil {
		v := s.BaiduChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "BaiduChannelResponse", v, metadata)
	}
	return nil
}

const opGetBaiduChannel = "GetBaiduChannel"

// GetBaiduChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about the status and settings of the Baidu channel
// for an application.
//
//    // Example sending a request using GetBaiduChannelRequest.
//    req := client.GetBaiduChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel
func (c *Client) GetBaiduChannelRequest(input *GetBaiduChannelInput) GetBaiduChannelRequest {
	op := &aws.Operation{
		Name:       opGetBaiduChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &GetBaiduChannelInput{}
	}

	req := c.newRequest(op, input, &GetBaiduChannelOutput{})

	return GetBaiduChannelRequest{Request: req, Input: input, Copy: c.GetBaiduChannelRequest}
}

// GetBaiduChannelRequest is the request type for the
// GetBaiduChannel API operation.
type GetBaiduChannelRequest struct {
	*aws.Request
	Input *GetBaiduChannelInput
	Copy  func(*GetBaiduChannelInput) GetBaiduChannelRequest
}

// Send marshals and sends the GetBaiduChannel API request.
func (r GetBaiduChannelRequest) Send(ctx context.Context) (*GetBaiduChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBaiduChannelResponse{
		GetBaiduChannelOutput: r.Request.Data.(*GetBaiduChannelOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBaiduChannelResponse is the response type for the
// GetBaiduChannel API operation.
type GetBaiduChannelResponse struct {
	*GetBaiduChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBaiduChannel request.
func (r *GetBaiduChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
