// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateJourneyStateInput struct {
	_ struct{} `type:"structure" payload:"JourneyStateRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`

	// Changes the status of a journey.
	//
	// JourneyStateRequest is a required field
	JourneyStateRequest *JourneyStateRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateJourneyStateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJourneyStateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateJourneyStateInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.JourneyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JourneyId"))
	}

	if s.JourneyStateRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("JourneyStateRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateJourneyStateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyId != nil {
		v := *s.JourneyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "journey-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyStateRequest != nil {
		v := s.JourneyStateRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "JourneyStateRequest", v, metadata)
	}
	return nil
}

type UpdateJourneyStateOutput struct {
	_ struct{} `type:"structure" payload:"JourneyResponse"`

	// Provides information about the status, configuration, and other settings
	// for a journey.
	//
	// JourneyResponse is a required field
	JourneyResponse *JourneyResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateJourneyStateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateJourneyStateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.JourneyResponse != nil {
		v := s.JourneyResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "JourneyResponse", v, metadata)
	}
	return nil
}

const opUpdateJourneyState = "UpdateJourneyState"

// UpdateJourneyStateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Cancels (stops) an active journey.
//
//    // Example sending a request using UpdateJourneyStateRequest.
//    req := client.UpdateJourneyStateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourneyState
func (c *Client) UpdateJourneyStateRequest(input *UpdateJourneyStateInput) UpdateJourneyStateRequest {
	op := &aws.Operation{
		Name:       opUpdateJourneyState,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}/state",
	}

	if input == nil {
		input = &UpdateJourneyStateInput{}
	}

	req := c.newRequest(op, input, &UpdateJourneyStateOutput{})

	return UpdateJourneyStateRequest{Request: req, Input: input, Copy: c.UpdateJourneyStateRequest}
}

// UpdateJourneyStateRequest is the request type for the
// UpdateJourneyState API operation.
type UpdateJourneyStateRequest struct {
	*aws.Request
	Input *UpdateJourneyStateInput
	Copy  func(*UpdateJourneyStateInput) UpdateJourneyStateRequest
}

// Send marshals and sends the UpdateJourneyState API request.
func (r UpdateJourneyStateRequest) Send(ctx context.Context) (*UpdateJourneyStateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateJourneyStateResponse{
		UpdateJourneyStateOutput: r.Request.Data.(*UpdateJourneyStateOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateJourneyStateResponse is the response type for the
// UpdateJourneyState API operation.
type UpdateJourneyStateResponse struct {
	*UpdateJourneyStateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateJourneyState request.
func (r *UpdateJourneyStateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
