// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qldb

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StreamJournalToKinesisInput struct {
	_ struct{} `type:"structure"`

	// The exclusive date and time that specifies when the stream ends. If you don't
	// define this parameter, the stream runs indefinitely until you cancel it.
	//
	// The ExclusiveEndTime must be in ISO 8601 date and time format and in Universal
	// Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z
	ExclusiveEndTime *time.Time `type:"timestamp"`

	// The inclusive start date and time from which to start streaming journal data.
	// This parameter must be in ISO 8601 date and time format and in Universal
	// Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z
	//
	// The InclusiveStartTime cannot be in the future and must be before ExclusiveEndTime.
	//
	// If you provide an InclusiveStartTime that is before the ledger's CreationDateTime,
	// QLDB effectively defaults it to the ledger's CreationDateTime.
	//
	// InclusiveStartTime is a required field
	InclusiveStartTime *time.Time `type:"timestamp" required:"true"`

	// The configuration settings of the Kinesis Data Streams destination for your
	// stream request.
	//
	// KinesisConfiguration is a required field
	KinesisConfiguration *KinesisConfiguration `type:"structure" required:"true"`

	// The name of the ledger.
	//
	// LedgerName is a required field
	LedgerName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions
	// for a journal stream to write data records to a Kinesis Data Streams resource.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The name that you want to assign to the QLDB journal stream. User-defined
	// names can help identify and indicate the purpose of a stream.
	//
	// Your stream name must be unique among other active streams for a given ledger.
	// Stream names have the same naming constraints as ledger names, as defined
	// in Quotas in Amazon QLDB (https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming)
	// in the Amazon QLDB Developer Guide.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The key-value pairs to add as tags to the stream that you want to create.
	// Tag keys are case sensitive. Tag values are case sensitive and can be null.
	Tags map[string]string `type:"map"`
}

// String returns the string representation
func (s StreamJournalToKinesisInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamJournalToKinesisInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StreamJournalToKinesisInput"}

	if s.InclusiveStartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("InclusiveStartTime"))
	}

	if s.KinesisConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("KinesisConfiguration"))
	}

	if s.LedgerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LedgerName"))
	}
	if s.LedgerName != nil && len(*s.LedgerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LedgerName", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if s.StreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}
	if s.KinesisConfiguration != nil {
		if err := s.KinesisConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KinesisConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamJournalToKinesisInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ExclusiveEndTime != nil {
		v := *s.ExclusiveEndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExclusiveEndTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.InclusiveStartTime != nil {
		v := *s.InclusiveStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InclusiveStartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.KinesisConfiguration != nil {
		v := s.KinesisConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "KinesisConfiguration", v, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamName != nil {
		v := *s.StreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.LedgerName != nil {
		v := *s.LedgerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StreamJournalToKinesisOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID that QLDB assigns to each QLDB journal stream.
	StreamId *string `min:"22" type:"string"`
}

// String returns the string representation
func (s StreamJournalToKinesisOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamJournalToKinesisOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opStreamJournalToKinesis = "StreamJournalToKinesis"

// StreamJournalToKinesisRequest returns a request value for making API operation for
// Amazon QLDB.
//
// Creates a journal stream for a given Amazon QLDB ledger. The stream captures
// every document revision that is committed to the ledger's journal and delivers
// the data to a specified Amazon Kinesis Data Streams resource.
//
//    // Example sending a request using StreamJournalToKinesisRequest.
//    req := client.StreamJournalToKinesisRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/qldb-2019-01-02/StreamJournalToKinesis
func (c *Client) StreamJournalToKinesisRequest(input *StreamJournalToKinesisInput) StreamJournalToKinesisRequest {
	op := &aws.Operation{
		Name:       opStreamJournalToKinesis,
		HTTPMethod: "POST",
		HTTPPath:   "/ledgers/{name}/journal-kinesis-streams",
	}

	if input == nil {
		input = &StreamJournalToKinesisInput{}
	}

	req := c.newRequest(op, input, &StreamJournalToKinesisOutput{})

	return StreamJournalToKinesisRequest{Request: req, Input: input, Copy: c.StreamJournalToKinesisRequest}
}

// StreamJournalToKinesisRequest is the request type for the
// StreamJournalToKinesis API operation.
type StreamJournalToKinesisRequest struct {
	*aws.Request
	Input *StreamJournalToKinesisInput
	Copy  func(*StreamJournalToKinesisInput) StreamJournalToKinesisRequest
}

// Send marshals and sends the StreamJournalToKinesis API request.
func (r StreamJournalToKinesisRequest) Send(ctx context.Context) (*StreamJournalToKinesisResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StreamJournalToKinesisResponse{
		StreamJournalToKinesisOutput: r.Request.Data.(*StreamJournalToKinesisOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StreamJournalToKinesisResponse is the response type for the
// StreamJournalToKinesis API operation.
type StreamJournalToKinesisResponse struct {
	*StreamJournalToKinesisOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StreamJournalToKinesis request.
func (r *StreamJournalToKinesisResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
