// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package qldbiface provides an interface to enable mocking the Amazon QLDB service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package qldbiface

import (
	"github.com/aws/aws-sdk-go-v2/service/qldb"
)

// ClientAPI provides an interface to enable mocking the
// qldb.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // QLDB.
//    func myFunc(svc qldbiface.ClientAPI) bool {
//        // Make svc.CancelJournalKinesisStream request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := qldb.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        qldbiface.ClientPI
//    }
//    func (m *mockClientClient) CancelJournalKinesisStream(input *qldb.CancelJournalKinesisStreamInput) (*qldb.CancelJournalKinesisStreamOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CancelJournalKinesisStreamRequest(*qldb.CancelJournalKinesisStreamInput) qldb.CancelJournalKinesisStreamRequest

	CreateLedgerRequest(*qldb.CreateLedgerInput) qldb.CreateLedgerRequest

	DeleteLedgerRequest(*qldb.DeleteLedgerInput) qldb.DeleteLedgerRequest

	DescribeJournalKinesisStreamRequest(*qldb.DescribeJournalKinesisStreamInput) qldb.DescribeJournalKinesisStreamRequest

	DescribeJournalS3ExportRequest(*qldb.DescribeJournalS3ExportInput) qldb.DescribeJournalS3ExportRequest

	DescribeLedgerRequest(*qldb.DescribeLedgerInput) qldb.DescribeLedgerRequest

	ExportJournalToS3Request(*qldb.ExportJournalToS3Input) qldb.ExportJournalToS3Request

	GetBlockRequest(*qldb.GetBlockInput) qldb.GetBlockRequest

	GetDigestRequest(*qldb.GetDigestInput) qldb.GetDigestRequest

	GetRevisionRequest(*qldb.GetRevisionInput) qldb.GetRevisionRequest

	ListJournalKinesisStreamsForLedgerRequest(*qldb.ListJournalKinesisStreamsForLedgerInput) qldb.ListJournalKinesisStreamsForLedgerRequest

	ListJournalS3ExportsRequest(*qldb.ListJournalS3ExportsInput) qldb.ListJournalS3ExportsRequest

	ListJournalS3ExportsForLedgerRequest(*qldb.ListJournalS3ExportsForLedgerInput) qldb.ListJournalS3ExportsForLedgerRequest

	ListLedgersRequest(*qldb.ListLedgersInput) qldb.ListLedgersRequest

	ListTagsForResourceRequest(*qldb.ListTagsForResourceInput) qldb.ListTagsForResourceRequest

	StreamJournalToKinesisRequest(*qldb.StreamJournalToKinesisInput) qldb.StreamJournalToKinesisRequest

	TagResourceRequest(*qldb.TagResourceInput) qldb.TagResourceRequest

	UntagResourceRequest(*qldb.UntagResourceInput) qldb.UntagResourceRequest

	UpdateLedgerRequest(*qldb.UpdateLedgerInput) qldb.UpdateLedgerRequest
}

var _ ClientAPI = (*qldb.Client)(nil)
