// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment.
	//
	// AssignmentName is a required field
	AssignmentName *string `location:"uri" locationName:"AssignmentName" min:"1" type:"string" required:"true"`

	// The AWS account ID where you want to delete the IAM policy assignment.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace that contains the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIAMPolicyAssignmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteIAMPolicyAssignmentInput"}

	if s.AssignmentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssignmentName", 1))
	}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.Namespace == nil {
		invalidParams.Add(aws.NewErrParamRequired("Namespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteIAMPolicyAssignmentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AssignmentName != nil {
		v := *s.AssignmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AssignmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteIAMPolicyAssignmentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssignmentName != nil {
		v := *s.AssignmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDeleteIAMPolicyAssignment = "DeleteIAMPolicyAssignment"

// DeleteIAMPolicyAssignmentRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Deletes an existing IAM policy assignment.
//
//    // Example sending a request using DeleteIAMPolicyAssignmentRequest.
//    req := client.DeleteIAMPolicyAssignmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment
func (c *Client) DeleteIAMPolicyAssignmentRequest(input *DeleteIAMPolicyAssignmentInput) DeleteIAMPolicyAssignmentRequest {
	op := &aws.Operation{
		Name:       opDeleteIAMPolicyAssignment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespace/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &DeleteIAMPolicyAssignmentInput{}
	}

	req := c.newRequest(op, input, &DeleteIAMPolicyAssignmentOutput{})

	return DeleteIAMPolicyAssignmentRequest{Request: req, Input: input, Copy: c.DeleteIAMPolicyAssignmentRequest}
}

// DeleteIAMPolicyAssignmentRequest is the request type for the
// DeleteIAMPolicyAssignment API operation.
type DeleteIAMPolicyAssignmentRequest struct {
	*aws.Request
	Input *DeleteIAMPolicyAssignmentInput
	Copy  func(*DeleteIAMPolicyAssignmentInput) DeleteIAMPolicyAssignmentRequest
}

// Send marshals and sends the DeleteIAMPolicyAssignment API request.
func (r DeleteIAMPolicyAssignmentRequest) Send(ctx context.Context) (*DeleteIAMPolicyAssignmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteIAMPolicyAssignmentResponse{
		DeleteIAMPolicyAssignmentOutput: r.Request.Data.(*DeleteIAMPolicyAssignmentOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteIAMPolicyAssignmentResponse is the response type for the
// DeleteIAMPolicyAssignment API operation.
type DeleteIAMPolicyAssignmentResponse struct {
	*DeleteIAMPolicyAssignmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteIAMPolicyAssignment request.
func (r *DeleteIAMPolicyAssignmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
