// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CopyOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or ARN for the source option group. For information about
	// creating an ARN, see Constructing an ARN for Amazon RDS (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//    * Must specify a valid option group.
	//
	//    * If the source option group is in the same AWS Region as the copy, specify
	//    a valid option group identifier, for example my-option-group, or a valid
	//    ARN.
	//
	//    * If the source option group is in a different AWS Region than the copy,
	//    specify a valid option group ARN, for example arn:aws:rds:us-west-2:123456789012:og:special-options.
	//
	// SourceOptionGroupIdentifier is a required field
	SourceOptionGroupIdentifier *string `type:"string" required:"true"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []Tag `locationNameList:"Tag" type:"list"`

	// The description for the copied option group.
	//
	// TargetOptionGroupDescription is a required field
	TargetOptionGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied option group.
	//
	// Constraints:
	//
	//    * Can't be null, empty, or blank
	//
	//    * Must contain from 1 to 255 letters, numbers, or hyphens
	//
	//    * First character must be a letter
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-option-group
	//
	// TargetOptionGroupIdentifier is a required field
	TargetOptionGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyOptionGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CopyOptionGroupInput"}

	if s.SourceOptionGroupIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceOptionGroupIdentifier"))
	}

	if s.TargetOptionGroupDescription == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetOptionGroupDescription"))
	}

	if s.TargetOptionGroupIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetOptionGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CopyOptionGroupOutput struct {
	_ struct{} `type:"structure"`

	OptionGroup *OptionGroup `type:"structure"`
}

// String returns the string representation
func (s CopyOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCopyOptionGroup = "CopyOptionGroup"

// CopyOptionGroupRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Copies the specified option group.
//
//    // Example sending a request using CopyOptionGroupRequest.
//    req := client.CopyOptionGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup
func (c *Client) CopyOptionGroupRequest(input *CopyOptionGroupInput) CopyOptionGroupRequest {
	op := &aws.Operation{
		Name:       opCopyOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyOptionGroupInput{}
	}

	req := c.newRequest(op, input, &CopyOptionGroupOutput{})

	return CopyOptionGroupRequest{Request: req, Input: input, Copy: c.CopyOptionGroupRequest}
}

// CopyOptionGroupRequest is the request type for the
// CopyOptionGroup API operation.
type CopyOptionGroupRequest struct {
	*aws.Request
	Input *CopyOptionGroupInput
	Copy  func(*CopyOptionGroupInput) CopyOptionGroupRequest
}

// Send marshals and sends the CopyOptionGroup API request.
func (r CopyOptionGroupRequest) Send(ctx context.Context) (*CopyOptionGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CopyOptionGroupResponse{
		CopyOptionGroupOutput: r.Request.Data.(*CopyOptionGroupOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CopyOptionGroupResponse is the response type for the
// CopyOptionGroup API operation.
type CopyOptionGroupResponse struct {
	*CopyOptionGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CopyOptionGroup request.
func (r *CopyOptionGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
