// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeOptionGroupsInput struct {
	_ struct{} `type:"structure"`

	// Filters the list of option groups to only include groups associated with
	// a specific database engine.
	EngineName *string `type:"string"`

	// This parameter isn't currently supported.
	Filters []Filter `locationNameList:"Filter" type:"list"`

	// Filters the list of option groups to only include groups associated with
	// a specific database engine version. If specified, then EngineName must also
	// be specified.
	MajorEngineVersion *string `type:"string"`

	// An optional pagination token provided by a previous DescribeOptionGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that you can retrieve the remaining results.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the option group to describe. Can't be supplied together with
	// EngineName or MajorEngineVersion.
	OptionGroupName *string `type:"string"`
}

// String returns the string representation
func (s DescribeOptionGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOptionGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeOptionGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// List of option groups.
type DescribeOptionGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// List of option groups.
	OptionGroupsList []OptionGroup `locationNameList:"OptionGroup" type:"list"`
}

// String returns the string representation
func (s DescribeOptionGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeOptionGroups = "DescribeOptionGroups"

// DescribeOptionGroupsRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Describes the available option groups.
//
//    // Example sending a request using DescribeOptionGroupsRequest.
//    req := client.DescribeOptionGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups
func (c *Client) DescribeOptionGroupsRequest(input *DescribeOptionGroupsInput) DescribeOptionGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeOptionGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOptionGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeOptionGroupsOutput{})

	return DescribeOptionGroupsRequest{Request: req, Input: input, Copy: c.DescribeOptionGroupsRequest}
}

// DescribeOptionGroupsRequest is the request type for the
// DescribeOptionGroups API operation.
type DescribeOptionGroupsRequest struct {
	*aws.Request
	Input *DescribeOptionGroupsInput
	Copy  func(*DescribeOptionGroupsInput) DescribeOptionGroupsRequest
}

// Send marshals and sends the DescribeOptionGroups API request.
func (r DescribeOptionGroupsRequest) Send(ctx context.Context) (*DescribeOptionGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeOptionGroupsResponse{
		DescribeOptionGroupsOutput: r.Request.Data.(*DescribeOptionGroupsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeOptionGroupsRequestPaginator returns a paginator for DescribeOptionGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeOptionGroupsRequest(input)
//   p := rds.NewDescribeOptionGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeOptionGroupsPaginator(req DescribeOptionGroupsRequest) DescribeOptionGroupsPaginator {
	return DescribeOptionGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeOptionGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeOptionGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeOptionGroupsPaginator struct {
	aws.Pager
}

func (p *DescribeOptionGroupsPaginator) CurrentPage() *DescribeOptionGroupsOutput {
	return p.Pager.CurrentPage().(*DescribeOptionGroupsOutput)
}

// DescribeOptionGroupsResponse is the response type for the
// DescribeOptionGroups API operation.
type DescribeOptionGroupsResponse struct {
	*DescribeOptionGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeOptionGroups request.
func (r *DescribeOptionGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
