// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetSegmentDetectionInput struct {
	_ struct{} `type:"structure"`

	// Job identifier for the text detection operation for which you want results
	// returned. You get the job identifer from an initial call to StartSegmentDetection.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of text.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetSegmentDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentDetectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSegmentDetectionInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetSegmentDetectionOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects. There can be multiple audio streams. Each AudioMetadata
	// object contains metadata for a single audio stream. Audio information in
	// an AudioMetadata objects includes the audio codec, the number of audio channels,
	// the duration of the audio stream, and the sample rate. Audio metadata is
	// returned in each page of information returned by GetSegmentDetection.
	AudioMetadata []AudioMetadata `type:"list"`

	// Current status of the segment detection job.
	JobStatus VideoJobStatus `type:"string" enum:"true"`

	// If the previous response was incomplete (because there are more labels to
	// retrieve), Amazon Rekognition Video returns a pagination token in the response.
	// You can use this pagination token to retrieve the next set of text.
	NextToken *string `type:"string"`

	// An array of segments detected in a video.
	Segments []SegmentDetection `type:"list"`

	// An array containing the segment types requested in the call to StartSegmentDetection.
	SelectedSegmentTypes []SegmentTypeInfo `type:"list"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Currently, Amazon Rekognition Video returns a single object in the VideoMetadata
	// array. The object contains information about the video stream in the input
	// file that Amazon Rekognition Video chose to analyze. The VideoMetadata object
	// includes the video codec, video format and other information. Video metadata
	// is returned in each page of information returned by GetSegmentDetection.
	VideoMetadata []VideoMetadata `type:"list"`
}

// String returns the string representation
func (s GetSegmentDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSegmentDetection = "GetSegmentDetection"

// GetSegmentDetectionRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Gets the segment detection results of a Amazon Rekognition Video analysis
// started by StartSegmentDetection.
//
// Segment detection with Amazon Rekognition Video is an asynchronous operation.
// You start segment detection by calling StartSegmentDetection which returns
// a job identifier (JobId). When the segment detection operation finishes,
// Amazon Rekognition publishes a completion status to the Amazon Simple Notification
// Service topic registered in the initial call to StartSegmentDetection. To
// get the results of the segment detection operation, first check that the
// status value published to the Amazon SNS topic is SUCCEEDED. if so, call
// GetSegmentDetection and pass the job identifier (JobId) from the initial
// call of StartSegmentDetection.
//
// GetSegmentDetection returns detected segments in an array (Segments) of SegmentDetection
// objects. Segments is sorted by the segment types specified in the SegmentTypes
// input parameter of StartSegmentDetection. Each element of the array includes
// the detected segment, the precentage confidence in the acuracy of the detected
// segment, the type of the segment, and the frame in which the segment was
// detected.
//
// Use SelectedSegmentTypes to find out the type of segment detection requested
// in the call to StartSegmentDetection.
//
// Use the MaxResults parameter to limit the number of segment detections returned.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetSegmentDetection
// and populate the NextToken request parameter with the token value returned
// from the previous call to GetSegmentDetection.
//
// For more information, see Detecting Video Segments in Stored Video in the
// Amazon Rekognition Developer Guide.
//
//    // Example sending a request using GetSegmentDetectionRequest.
//    req := client.GetSegmentDetectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetSegmentDetectionRequest(input *GetSegmentDetectionInput) GetSegmentDetectionRequest {
	op := &aws.Operation{
		Name:       opGetSegmentDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSegmentDetectionInput{}
	}

	req := c.newRequest(op, input, &GetSegmentDetectionOutput{})

	return GetSegmentDetectionRequest{Request: req, Input: input, Copy: c.GetSegmentDetectionRequest}
}

// GetSegmentDetectionRequest is the request type for the
// GetSegmentDetection API operation.
type GetSegmentDetectionRequest struct {
	*aws.Request
	Input *GetSegmentDetectionInput
	Copy  func(*GetSegmentDetectionInput) GetSegmentDetectionRequest
}

// Send marshals and sends the GetSegmentDetection API request.
func (r GetSegmentDetectionRequest) Send(ctx context.Context) (*GetSegmentDetectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSegmentDetectionResponse{
		GetSegmentDetectionOutput: r.Request.Data.(*GetSegmentDetectionOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetSegmentDetectionRequestPaginator returns a paginator for GetSegmentDetection.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetSegmentDetectionRequest(input)
//   p := rekognition.NewGetSegmentDetectionRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetSegmentDetectionPaginator(req GetSegmentDetectionRequest) GetSegmentDetectionPaginator {
	return GetSegmentDetectionPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetSegmentDetectionInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetSegmentDetectionPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetSegmentDetectionPaginator struct {
	aws.Pager
}

func (p *GetSegmentDetectionPaginator) CurrentPage() *GetSegmentDetectionOutput {
	return p.Pager.CurrentPage().(*GetSegmentDetectionOutput)
}

// GetSegmentDetectionResponse is the response type for the
// GetSegmentDetection API operation.
type GetSegmentDetectionResponse struct {
	*GetSegmentDetectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSegmentDetection request.
func (r *GetSegmentDetectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
