// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchFacesInput struct {
	_ struct{} `type:"structure"`

	// ID of the collection the face belongs to.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`

	// ID of a face to find matches for in the collection.
	//
	// FaceId is a required field
	FaceId *string `type:"string" required:"true"`

	// Optional value specifying the minimum confidence in the face match to return.
	// For example, don't return any matches where confidence in matches is less
	// than 70%. The default value is 80%.
	FaceMatchThreshold *float64 `type:"float"`

	// Maximum number of faces to return. The operation returns the maximum number
	// of faces with the highest confidence in the match.
	MaxFaces *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s SearchFacesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchFacesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchFacesInput"}

	if s.CollectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CollectionId", 1))
	}

	if s.FaceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FaceId"))
	}
	if s.MaxFaces != nil && *s.MaxFaces < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxFaces", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchFacesOutput struct {
	_ struct{} `type:"structure"`

	// An array of faces that matched the input face, along with the confidence
	// in the match.
	FaceMatches []FaceMatch `type:"list"`

	// Version number of the face detection model associated with the input collection
	// (CollectionId).
	FaceModelVersion *string `type:"string"`

	// ID of the face that was searched for matches in a collection.
	SearchedFaceId *string `type:"string"`
}

// String returns the string representation
func (s SearchFacesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchFaces = "SearchFaces"

// SearchFacesRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// For a given input face ID, searches for matching faces in the collection
// the face belongs to. You get a face ID when you add a face to the collection
// using the IndexFaces operation. The operation compares the features of the
// input face with faces in the specified collection.
//
// You can also search faces without indexing faces by using the SearchFacesByImage
// operation.
//
// The operation response returns an array of faces that match, ordered by similarity
// score with the highest similarity first. More specifically, it is an array
// of metadata for each face match that is found. Along with the metadata, the
// response also includes a confidence value for each face match, indicating
// the confidence that the specific face matches the input face.
//
// For an example, see Searching for a Face Using Its Face ID in the Amazon
// Rekognition Developer Guide.
//
// This operation requires permissions to perform the rekognition:SearchFaces
// action.
//
//    // Example sending a request using SearchFacesRequest.
//    req := client.SearchFacesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) SearchFacesRequest(input *SearchFacesInput) SearchFacesRequest {
	op := &aws.Operation{
		Name:       opSearchFaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchFacesInput{}
	}

	req := c.newRequest(op, input, &SearchFacesOutput{})

	return SearchFacesRequest{Request: req, Input: input, Copy: c.SearchFacesRequest}
}

// SearchFacesRequest is the request type for the
// SearchFaces API operation.
type SearchFacesRequest struct {
	*aws.Request
	Input *SearchFacesInput
	Copy  func(*SearchFacesInput) SearchFacesRequest
}

// Send marshals and sends the SearchFaces API request.
func (r SearchFacesRequest) Send(ctx context.Context) (*SearchFacesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchFacesResponse{
		SearchFacesOutput: r.Request.Data.(*SearchFacesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SearchFacesResponse is the response type for the
// SearchFaces API operation.
type SearchFacesResponse struct {
	*SearchFacesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchFaces request.
func (r *SearchFacesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
