// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53domains

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The RejectDomainTransferFromAnotherAwsAccount request includes the following
// element.
type RejectDomainTransferFromAnotherAwsAccountInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that was specified when another AWS account submitted
	// a TransferDomainToAnotherAwsAccount (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html)
	// request.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RejectDomainTransferFromAnotherAwsAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectDomainTransferFromAnotherAwsAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RejectDomainTransferFromAnotherAwsAccountInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The RejectDomainTransferFromAnotherAwsAccount response includes the following
// element.
type RejectDomainTransferFromAnotherAwsAccountOutput struct {
	_ struct{} `type:"structure"`

	// The identifier that TransferDomainToAnotherAwsAccount returned to track the
	// progress of the request. Because the transfer request was rejected, the value
	// is no longer valid, and you can't use GetOperationDetail to query the operation
	// status.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s RejectDomainTransferFromAnotherAwsAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opRejectDomainTransferFromAnotherAwsAccount = "RejectDomainTransferFromAnotherAwsAccount"

// RejectDomainTransferFromAnotherAwsAccountRequest returns a request value for making API operation for
// Amazon Route 53 Domains.
//
// Rejects the transfer of a domain from another AWS account to the current
// AWS account. You initiate a transfer between AWS accounts using TransferDomainToAnotherAwsAccount
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
//
// Use either ListOperations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html)
// or GetOperationDetail (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html)
// to determine whether the operation succeeded. GetOperationDetail (https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html)
// provides additional information, for example, Domain Transfer from Aws Account
// 111122223333 has been cancelled.
//
//    // Example sending a request using RejectDomainTransferFromAnotherAwsAccountRequest.
//    req := client.RejectDomainTransferFromAnotherAwsAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RejectDomainTransferFromAnotherAwsAccount
func (c *Client) RejectDomainTransferFromAnotherAwsAccountRequest(input *RejectDomainTransferFromAnotherAwsAccountInput) RejectDomainTransferFromAnotherAwsAccountRequest {
	op := &aws.Operation{
		Name:       opRejectDomainTransferFromAnotherAwsAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectDomainTransferFromAnotherAwsAccountInput{}
	}

	req := c.newRequest(op, input, &RejectDomainTransferFromAnotherAwsAccountOutput{})

	return RejectDomainTransferFromAnotherAwsAccountRequest{Request: req, Input: input, Copy: c.RejectDomainTransferFromAnotherAwsAccountRequest}
}

// RejectDomainTransferFromAnotherAwsAccountRequest is the request type for the
// RejectDomainTransferFromAnotherAwsAccount API operation.
type RejectDomainTransferFromAnotherAwsAccountRequest struct {
	*aws.Request
	Input *RejectDomainTransferFromAnotherAwsAccountInput
	Copy  func(*RejectDomainTransferFromAnotherAwsAccountInput) RejectDomainTransferFromAnotherAwsAccountRequest
}

// Send marshals and sends the RejectDomainTransferFromAnotherAwsAccount API request.
func (r RejectDomainTransferFromAnotherAwsAccountRequest) Send(ctx context.Context) (*RejectDomainTransferFromAnotherAwsAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RejectDomainTransferFromAnotherAwsAccountResponse{
		RejectDomainTransferFromAnotherAwsAccountOutput: r.Request.Data.(*RejectDomainTransferFromAnotherAwsAccountOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RejectDomainTransferFromAnotherAwsAccountResponse is the response type for the
// RejectDomainTransferFromAnotherAwsAccount API operation.
type RejectDomainTransferFromAnotherAwsAccountResponse struct {
	*RejectDomainTransferFromAnotherAwsAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RejectDomainTransferFromAnotherAwsAccount request.
func (r *RejectDomainTransferFromAnotherAwsAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
