// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53domains

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A request for the authorization code for the specified domain. To transfer
// a domain to another registrar, you provide this value to the new registrar.
type RetrieveDomainAuthCodeInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that you want to get an authorization code for.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveDomainAuthCodeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveDomainAuthCodeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RetrieveDomainAuthCodeInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The RetrieveDomainAuthCode response includes the following element.
type RetrieveDomainAuthCodeOutput struct {
	_ struct{} `type:"structure"`

	// The authorization code for the domain.
	//
	// AuthCode is a required field
	AuthCode *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s RetrieveDomainAuthCodeOutput) String() string {
	return awsutil.Prettify(s)
}

const opRetrieveDomainAuthCode = "RetrieveDomainAuthCode"

// RetrieveDomainAuthCodeRequest returns a request value for making API operation for
// Amazon Route 53 Domains.
//
// This operation returns the AuthCode for the domain. To transfer a domain
// to another registrar, you provide this value to the new registrar.
//
//    // Example sending a request using RetrieveDomainAuthCodeRequest.
//    req := client.RetrieveDomainAuthCodeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RetrieveDomainAuthCode
func (c *Client) RetrieveDomainAuthCodeRequest(input *RetrieveDomainAuthCodeInput) RetrieveDomainAuthCodeRequest {
	op := &aws.Operation{
		Name:       opRetrieveDomainAuthCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveDomainAuthCodeInput{}
	}

	req := c.newRequest(op, input, &RetrieveDomainAuthCodeOutput{})

	return RetrieveDomainAuthCodeRequest{Request: req, Input: input, Copy: c.RetrieveDomainAuthCodeRequest}
}

// RetrieveDomainAuthCodeRequest is the request type for the
// RetrieveDomainAuthCode API operation.
type RetrieveDomainAuthCodeRequest struct {
	*aws.Request
	Input *RetrieveDomainAuthCodeInput
	Copy  func(*RetrieveDomainAuthCodeInput) RetrieveDomainAuthCodeRequest
}

// Send marshals and sends the RetrieveDomainAuthCode API request.
func (r RetrieveDomainAuthCodeRequest) Send(ctx context.Context) (*RetrieveDomainAuthCodeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RetrieveDomainAuthCodeResponse{
		RetrieveDomainAuthCodeOutput: r.Request.Data.(*RetrieveDomainAuthCodeOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RetrieveDomainAuthCodeResponse is the response type for the
// RetrieveDomainAuthCode API operation.
type RetrieveDomainAuthCodeResponse struct {
	*RetrieveDomainAuthCodeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RetrieveDomainAuthCode request.
func (r *RetrieveDomainAuthCodeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
