// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package route53domainsiface provides an interface to enable mocking the Amazon Route 53 Domains service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package route53domainsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/route53domains"
)

// ClientAPI provides an interface to enable mocking the
// route53domains.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Route 53 Domains.
//    func myFunc(svc route53domainsiface.ClientAPI) bool {
//        // Make svc.AcceptDomainTransferFromAnotherAwsAccount request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := route53domains.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        route53domainsiface.ClientPI
//    }
//    func (m *mockClientClient) AcceptDomainTransferFromAnotherAwsAccount(input *route53domains.AcceptDomainTransferFromAnotherAwsAccountInput) (*route53domains.AcceptDomainTransferFromAnotherAwsAccountOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AcceptDomainTransferFromAnotherAwsAccountRequest(*route53domains.AcceptDomainTransferFromAnotherAwsAccountInput) route53domains.AcceptDomainTransferFromAnotherAwsAccountRequest

	CancelDomainTransferToAnotherAwsAccountRequest(*route53domains.CancelDomainTransferToAnotherAwsAccountInput) route53domains.CancelDomainTransferToAnotherAwsAccountRequest

	CheckDomainAvailabilityRequest(*route53domains.CheckDomainAvailabilityInput) route53domains.CheckDomainAvailabilityRequest

	CheckDomainTransferabilityRequest(*route53domains.CheckDomainTransferabilityInput) route53domains.CheckDomainTransferabilityRequest

	DeleteTagsForDomainRequest(*route53domains.DeleteTagsForDomainInput) route53domains.DeleteTagsForDomainRequest

	DisableDomainAutoRenewRequest(*route53domains.DisableDomainAutoRenewInput) route53domains.DisableDomainAutoRenewRequest

	DisableDomainTransferLockRequest(*route53domains.DisableDomainTransferLockInput) route53domains.DisableDomainTransferLockRequest

	EnableDomainAutoRenewRequest(*route53domains.EnableDomainAutoRenewInput) route53domains.EnableDomainAutoRenewRequest

	EnableDomainTransferLockRequest(*route53domains.EnableDomainTransferLockInput) route53domains.EnableDomainTransferLockRequest

	GetContactReachabilityStatusRequest(*route53domains.GetContactReachabilityStatusInput) route53domains.GetContactReachabilityStatusRequest

	GetDomainDetailRequest(*route53domains.GetDomainDetailInput) route53domains.GetDomainDetailRequest

	GetDomainSuggestionsRequest(*route53domains.GetDomainSuggestionsInput) route53domains.GetDomainSuggestionsRequest

	GetOperationDetailRequest(*route53domains.GetOperationDetailInput) route53domains.GetOperationDetailRequest

	ListDomainsRequest(*route53domains.ListDomainsInput) route53domains.ListDomainsRequest

	ListOperationsRequest(*route53domains.ListOperationsInput) route53domains.ListOperationsRequest

	ListTagsForDomainRequest(*route53domains.ListTagsForDomainInput) route53domains.ListTagsForDomainRequest

	RegisterDomainRequest(*route53domains.RegisterDomainInput) route53domains.RegisterDomainRequest

	RejectDomainTransferFromAnotherAwsAccountRequest(*route53domains.RejectDomainTransferFromAnotherAwsAccountInput) route53domains.RejectDomainTransferFromAnotherAwsAccountRequest

	RenewDomainRequest(*route53domains.RenewDomainInput) route53domains.RenewDomainRequest

	ResendContactReachabilityEmailRequest(*route53domains.ResendContactReachabilityEmailInput) route53domains.ResendContactReachabilityEmailRequest

	RetrieveDomainAuthCodeRequest(*route53domains.RetrieveDomainAuthCodeInput) route53domains.RetrieveDomainAuthCodeRequest

	TransferDomainRequest(*route53domains.TransferDomainInput) route53domains.TransferDomainRequest

	TransferDomainToAnotherAwsAccountRequest(*route53domains.TransferDomainToAnotherAwsAccountInput) route53domains.TransferDomainToAnotherAwsAccountRequest

	UpdateDomainContactRequest(*route53domains.UpdateDomainContactInput) route53domains.UpdateDomainContactRequest

	UpdateDomainContactPrivacyRequest(*route53domains.UpdateDomainContactPrivacyInput) route53domains.UpdateDomainContactPrivacyRequest

	UpdateDomainNameserversRequest(*route53domains.UpdateDomainNameserversInput) route53domains.UpdateDomainNameserversRequest

	UpdateTagsForDomainRequest(*route53domains.UpdateTagsForDomainInput) route53domains.UpdateTagsForDomainRequest

	ViewBillingRequest(*route53domains.ViewBillingInput) route53domains.ViewBillingRequest
}

var _ ClientAPI = (*route53domains.Client)(nil)
