// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53resolver

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetResolverRulePolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver rule policy that you want to get information about.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverRulePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRulePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetResolverRulePolicyInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetResolverRulePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resolver rule policy that you specified in a GetResolverRulePolicy
	// request.
	ResolverRulePolicy *string `type:"string"`
}

// String returns the string representation
func (s GetResolverRulePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetResolverRulePolicy = "GetResolverRulePolicy"

// GetResolverRulePolicyRequest returns a request value for making API operation for
// Amazon Route 53 Resolver.
//
// Gets information about a resolver rule policy. A resolver rule policy specifies
// the Resolver operations and resources that you want to allow another AWS
// account to be able to use.
//
//    // Example sending a request using GetResolverRulePolicyRequest.
//    req := client.GetResolverRulePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy
func (c *Client) GetResolverRulePolicyRequest(input *GetResolverRulePolicyInput) GetResolverRulePolicyRequest {
	op := &aws.Operation{
		Name:       opGetResolverRulePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRulePolicyInput{}
	}

	req := c.newRequest(op, input, &GetResolverRulePolicyOutput{})

	return GetResolverRulePolicyRequest{Request: req, Input: input, Copy: c.GetResolverRulePolicyRequest}
}

// GetResolverRulePolicyRequest is the request type for the
// GetResolverRulePolicy API operation.
type GetResolverRulePolicyRequest struct {
	*aws.Request
	Input *GetResolverRulePolicyInput
	Copy  func(*GetResolverRulePolicyInput) GetResolverRulePolicyRequest
}

// Send marshals and sends the GetResolverRulePolicy API request.
func (r GetResolverRulePolicyRequest) Send(ctx context.Context) (*GetResolverRulePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetResolverRulePolicyResponse{
		GetResolverRulePolicyOutput: r.Request.Data.(*GetResolverRulePolicyOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetResolverRulePolicyResponse is the response type for the
// GetResolverRulePolicy API operation.
type GetResolverRulePolicyResponse struct {
	*GetResolverRulePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetResolverRulePolicy request.
func (r *GetResolverRulePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
