// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An access point used to access a bucket.
type AccessPoint struct {
	_ struct{} `type:"structure"`

	// The name of the bucket associated with this access point.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name of this access point.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// Indicates whether this access point allows access from the public internet.
	// If VpcConfiguration is specified for this access point, then NetworkOrigin
	// is VPC, and the access point doesn't allow access from the public internet.
	// Otherwise, NetworkOrigin is Internet, and the access point allows access
	// from the public internet, subject to the access point and bucket access policies.
	//
	// NetworkOrigin is a required field
	NetworkOrigin NetworkOrigin `type:"string" required:"true" enum:"true"`

	// The virtual private cloud (VPC) configuration for this access point, if one
	// exists.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s AccessPoint) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessPoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if len(s.NetworkOrigin) > 0 {
		v := s.NetworkOrigin

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NetworkOrigin", v, metadata)
	}
	if s.VpcConfiguration != nil {
		v := s.VpcConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConfiguration", v, metadata)
	}
	return nil
}

// A container element for the job configuration and status information returned
// by a Describe Job request.
type JobDescriptor struct {
	_ struct{} `type:"structure"`

	// Indicates whether confirmation is required before Amazon S3 begins running
	// the specified job. Confirmation is required only for jobs created through
	// the Amazon S3 console.
	ConfirmationRequired *bool `type:"boolean"`

	// A timestamp indicating when this job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description for this job, if one was provided in this job's Create Job
	// request.
	Description *string `min:"1" type:"string"`

	// If the specified job failed, this field contains information describing the
	// failure.
	FailureReasons []JobFailure `type:"list"`

	// The Amazon Resource Name (ARN) for this job.
	JobArn *string `min:"1" type:"string"`

	// The ID for the specified job.
	JobId *string `min:"5" type:"string"`

	// The configuration information for the specified job's manifest object.
	Manifest *JobManifest `type:"structure"`

	// The operation that the specified job is configured to execute on the objects
	// listed in the manifest.
	Operation *JobOperation `type:"structure"`

	// The priority of the specified job.
	Priority *int64 `type:"integer"`

	// Describes the total number of tasks that the specified job has executed,
	// the number of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary `type:"structure"`

	// Contains the configuration information for the job-completion report if you
	// requested one in the Create Job request.
	Report *JobReport `type:"structure"`

	// The Amazon Resource Name (ARN) for the AWS Identity and Access Management
	// (IAM) role assigned to execute the tasks for this job.
	RoleArn *string `min:"1" type:"string"`

	// The current status of the specified job.
	Status JobStatus `type:"string" enum:"true"`

	StatusUpdateReason *string `min:"1" type:"string"`

	// The reason why the specified job was suspended. A job is only suspended if
	// you create it through the Amazon S3 console. When you create the job, it
	// enters the Suspended state to await confirmation before running. After you
	// confirm the job, it automatically exits the Suspended state.
	SuspendedCause *string `min:"1" type:"string"`

	// The timestamp when this job was suspended, if it has been suspended.
	SuspendedDate *time.Time `type:"timestamp"`

	// A timestamp indicating when this job terminated. A job's termination date
	// is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s JobDescriptor) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobDescriptor) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfirmationRequired != nil {
		v := *s.ConfirmationRequired

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfirmationRequired", protocol.BoolValue(v), metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTime",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.StringValue(v), metadata)
	}
	if s.FailureReasons != nil {
		v := s.FailureReasons

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FailureReasons", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.JobArn != nil {
		v := *s.JobArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobArn", protocol.StringValue(v), metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobId", protocol.StringValue(v), metadata)
	}
	if s.Manifest != nil {
		v := s.Manifest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Manifest", v, metadata)
	}
	if s.Operation != nil {
		v := s.Operation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Operation", v, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if s.ProgressSummary != nil {
		v := s.ProgressSummary

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ProgressSummary", v, metadata)
	}
	if s.Report != nil {
		v := s.Report

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Report", v, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.StringValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.StatusUpdateReason != nil {
		v := *s.StatusUpdateReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusUpdateReason", protocol.StringValue(v), metadata)
	}
	if s.SuspendedCause != nil {
		v := *s.SuspendedCause

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SuspendedCause", protocol.StringValue(v), metadata)
	}
	if s.SuspendedDate != nil {
		v := *s.SuspendedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SuspendedDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.TerminationDate != nil {
		v := *s.TerminationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TerminationDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	return nil
}

// If this job failed, this element indicates why the job failed.
type JobFailure struct {
	_ struct{} `type:"structure"`

	// The failure code, if any, for the specified job.
	FailureCode *string `min:"1" type:"string"`

	// The failure reason, if any, for the specified job.
	FailureReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobFailure) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobFailure) MarshalFields(e protocol.FieldEncoder) error {
	if s.FailureCode != nil {
		v := *s.FailureCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailureCode", protocol.StringValue(v), metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailureReason", protocol.StringValue(v), metadata)
	}
	return nil
}

// Contains the configuration and status information for a single job retrieved
// as part of a job list.
type JobListDescriptor struct {
	_ struct{} `type:"structure"`

	// A timestamp indicating when the specified job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The user-specified description that was included in the specified job's Create
	// Job request.
	Description *string `min:"1" type:"string"`

	// The ID for the specified job.
	JobId *string `min:"5" type:"string"`

	// The operation that the specified job is configured to run on each object
	// listed in the manifest.
	Operation OperationName `type:"string" enum:"true"`

	// The current priority for the specified job.
	Priority *int64 `type:"integer"`

	// Describes the total number of tasks that the specified job has executed,
	// the number of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary `type:"structure"`

	// The specified job's current status.
	Status JobStatus `type:"string" enum:"true"`

	// A timestamp indicating when the specified job terminated. A job's termination
	// date is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s JobListDescriptor) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobListDescriptor) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTime",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.StringValue(v), metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobId", protocol.StringValue(v), metadata)
	}
	if len(s.Operation) > 0 {
		v := s.Operation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Operation", v, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if s.ProgressSummary != nil {
		v := s.ProgressSummary

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ProgressSummary", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.TerminationDate != nil {
		v := *s.TerminationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TerminationDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	return nil
}

// Contains the configuration information for a job's manifest.
type JobManifest struct {
	_ struct{} `type:"structure"`

	// Contains the information required to locate the specified job's manifest.
	//
	// Location is a required field
	Location *JobManifestLocation `type:"structure" required:"true"`

	// Describes the format of the specified job's manifest. If the manifest is
	// in CSV format, also describes the columns contained within the manifest.
	//
	// Spec is a required field
	Spec *JobManifestSpec `type:"structure" required:"true"`
}

// String returns the string representation
func (s JobManifest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobManifest"}

	if s.Location == nil {
		invalidParams.Add(aws.NewErrParamRequired("Location"))
	}

	if s.Spec == nil {
		invalidParams.Add(aws.NewErrParamRequired("Spec"))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(aws.ErrInvalidParams))
		}
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobManifest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Spec", v, metadata)
	}
	return nil
}

// Contains the information required to locate a manifest object.
type JobManifestLocation struct {
	_ struct{} `type:"structure"`

	// The ETag for the specified manifest object.
	//
	// ETag is a required field
	ETag *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for a manifest object.
	//
	// ObjectArn is a required field
	ObjectArn *string `min:"1" type:"string" required:"true"`

	// The optional version ID to identify a specific version of the manifest object.
	ObjectVersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobManifestLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifestLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobManifestLocation"}

	if s.ETag == nil {
		invalidParams.Add(aws.NewErrParamRequired("ETag"))
	}
	if s.ETag != nil && len(*s.ETag) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ETag", 1))
	}

	if s.ObjectArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectArn"))
	}
	if s.ObjectArn != nil && len(*s.ObjectArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ObjectArn", 1))
	}
	if s.ObjectVersionId != nil && len(*s.ObjectVersionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ObjectVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobManifestLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.ObjectArn != nil {
		v := *s.ObjectArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectArn", protocol.StringValue(v), metadata)
	}
	if s.ObjectVersionId != nil {
		v := *s.ObjectVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectVersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes the format of a manifest. If the manifest is in CSV format, also
// describes the columns contained within the manifest.
type JobManifestSpec struct {
	_ struct{} `type:"structure"`

	// If the specified manifest object is in the S3BatchOperations_CSV_20180820
	// format, this element describes which columns contain the required data.
	Fields []JobManifestFieldName `type:"list"`

	// Indicates which of the available formats the specified manifest uses.
	//
	// Format is a required field
	Format JobManifestFormat `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s JobManifestSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifestSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobManifestSpec"}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobManifestSpec) MarshalFields(e protocol.FieldEncoder) error {
	if s.Fields != nil {
		v := s.Fields

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Fields", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", v, metadata)
	}
	return nil
}

// The operation that you want this job to perform on each object listed in
// the manifest. For more information about the available operations, see Available
// Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html)
// in the Amazon Simple Storage Service Developer Guide.
type JobOperation struct {
	_ struct{} `type:"structure"`

	// Directs the specified job to invoke an AWS Lambda function on each object
	// in the manifest.
	LambdaInvoke *LambdaInvokeOperation `type:"structure"`

	// Directs the specified job to execute an Initiate Glacier Restore call on
	// each object in the manifest.
	S3InitiateRestoreObject *S3InitiateRestoreObjectOperation `type:"structure"`

	// Directs the specified job to execute a PUT Object acl call on each object
	// in the manifest.
	S3PutObjectAcl *S3SetObjectAclOperation `type:"structure"`

	// Directs the specified job to execute a PUT Copy object call on each object
	// in the manifest.
	S3PutObjectCopy *S3CopyObjectOperation `type:"structure"`

	// Contains the configuration parameters for a Set Object Legal Hold operation.
	// Amazon S3 Batch Operations passes each value through to the underlying PUT
	// Object Legal Hold API. For more information about the parameters for this
	// operation, see PUT Object Legal Hold (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.htmll#object-lock-legal-holds).
	S3PutObjectLegalHold *S3SetObjectLegalHoldOperation `type:"structure"`

	// Contains the configuration parameters for a Set Object Retention operation.
	// Amazon S3 Batch Operations passes each value through to the underlying PUT
	// Object Retention API. For more information about the parameters for this
	// operation, see PUT Object Retention (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes).
	S3PutObjectRetention *S3SetObjectRetentionOperation `type:"structure"`

	// Directs the specified job to execute a PUT Object tagging call on each object
	// in the manifest.
	S3PutObjectTagging *S3SetObjectTaggingOperation `type:"structure"`
}

// String returns the string representation
func (s JobOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobOperation"}
	if s.LambdaInvoke != nil {
		if err := s.LambdaInvoke.Validate(); err != nil {
			invalidParams.AddNested("LambdaInvoke", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3PutObjectAcl != nil {
		if err := s.S3PutObjectAcl.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectAcl", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3PutObjectCopy != nil {
		if err := s.S3PutObjectCopy.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectCopy", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3PutObjectLegalHold != nil {
		if err := s.S3PutObjectLegalHold.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectLegalHold", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3PutObjectRetention != nil {
		if err := s.S3PutObjectRetention.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectRetention", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3PutObjectTagging != nil {
		if err := s.S3PutObjectTagging.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectTagging", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.LambdaInvoke != nil {
		v := s.LambdaInvoke

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LambdaInvoke", v, metadata)
	}
	if s.S3InitiateRestoreObject != nil {
		v := s.S3InitiateRestoreObject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3InitiateRestoreObject", v, metadata)
	}
	if s.S3PutObjectAcl != nil {
		v := s.S3PutObjectAcl

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3PutObjectAcl", v, metadata)
	}
	if s.S3PutObjectCopy != nil {
		v := s.S3PutObjectCopy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3PutObjectCopy", v, metadata)
	}
	if s.S3PutObjectLegalHold != nil {
		v := s.S3PutObjectLegalHold

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3PutObjectLegalHold", v, metadata)
	}
	if s.S3PutObjectRetention != nil {
		v := s.S3PutObjectRetention

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3PutObjectRetention", v, metadata)
	}
	if s.S3PutObjectTagging != nil {
		v := s.S3PutObjectTagging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3PutObjectTagging", v, metadata)
	}
	return nil
}

// Describes the total number of tasks that the specified job has executed,
// the number of tasks that succeeded, and the number of tasks that failed.
type JobProgressSummary struct {
	_ struct{} `type:"structure"`

	NumberOfTasksFailed *int64 `type:"long"`

	NumberOfTasksSucceeded *int64 `type:"long"`

	TotalNumberOfTasks *int64 `type:"long"`
}

// String returns the string representation
func (s JobProgressSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobProgressSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.NumberOfTasksFailed != nil {
		v := *s.NumberOfTasksFailed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NumberOfTasksFailed", protocol.Int64Value(v), metadata)
	}
	if s.NumberOfTasksSucceeded != nil {
		v := *s.NumberOfTasksSucceeded

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NumberOfTasksSucceeded", protocol.Int64Value(v), metadata)
	}
	if s.TotalNumberOfTasks != nil {
		v := *s.TotalNumberOfTasks

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalNumberOfTasks", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Contains the configuration parameters for a job-completion report.
type JobReport struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the bucket where specified job-completion
	// report will be stored.
	Bucket *string `min:"1" type:"string"`

	// Indicates whether the specified job will generate a job-completion report.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The format of the specified job-completion report.
	Format JobReportFormat `type:"string" enum:"true"`

	// An optional prefix to describe where in the specified bucket the job-completion
	// report will be stored. Amazon S3 will store the job-completion report at
	// <prefix>/job-<job-id>/report.json.
	Prefix *string `min:"1" type:"string"`

	// Indicates whether the job-completion report will include details of all tasks
	// or only failed tasks.
	ReportScope JobReportScope `type:"string" enum:"true"`
}

// String returns the string representation
func (s JobReport) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobReport) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobReport"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 1))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobReport) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.ReportScope) > 0 {
		v := s.ReportScope

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReportScope", v, metadata)
	}
	return nil
}

// Contains the configuration parameters for a Lambda Invoke operation.
type LambdaInvokeOperation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the AWS Lambda function that the specified
	// job will invoke for each object in the manifest.
	FunctionArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaInvokeOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaInvokeOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaInvokeOperation"}
	if s.FunctionArn != nil && len(*s.FunctionArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaInvokeOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionArn", protocol.StringValue(v), metadata)
	}
	return nil
}

// Indicates whether this access point policy is public. For more information
// about how Amazon S3 evaluates policies to determine whether they are public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon Simple Storage Service Developer Guide.
type PolicyStatus struct {
	_ struct{} `type:"structure"`

	IsPublic *bool `locationName:"IsPublic" type:"boolean"`
}

// String returns the string representation
func (s PolicyStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PolicyStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsPublic != nil {
		v := *s.IsPublic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsPublic", protocol.BoolValue(v), metadata)
	}
	return nil
}

// The PublicAccessBlock configuration that you want to apply to this Amazon
// S3 bucket. You can enable the configuration options in any combination. For
// more information about when Amazon S3 considers a bucket or object public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon Simple Storage Service Developer Guide.
type PublicAccessBlockConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should block public access control lists (ACLs)
	// for buckets in this account. Setting this element to TRUE causes the following
	// behavior:
	//
	//    * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is
	//    public.
	//
	//    * PUT Object calls fail if the request includes a public ACL.
	//
	//    * PUT Bucket calls fail if the request includes a public ACL.
	//
	// Enabling this setting doesn't affect existing policies or ACLs.
	BlockPublicAcls *bool `locationName:"BlockPublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should block public bucket policies for buckets
	// in this account. Setting this element to TRUE causes Amazon S3 to reject
	// calls to PUT Bucket policy if the specified bucket policy allows public access.
	//
	// Enabling this setting doesn't affect existing bucket policies.
	BlockPublicPolicy *bool `locationName:"BlockPublicPolicy" type:"boolean"`

	// Specifies whether Amazon S3 should ignore public ACLs for buckets in this
	// account. Setting this element to TRUE causes Amazon S3 to ignore all public
	// ACLs on buckets in this account and any objects that they contain.
	//
	// Enabling this setting doesn't affect the persistence of any existing ACLs
	// and doesn't prevent new public ACLs from being set.
	IgnorePublicAcls *bool `locationName:"IgnorePublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should restrict public bucket policies for buckets
	// in this account. Setting this element to TRUE restricts access to buckets
	// with public policies to only AWS services and authorized users within this
	// account.
	//
	// Enabling this setting doesn't affect previously stored bucket policies, except
	// that public and cross-account access within any public bucket policy, including
	// non-public delegation to specific accounts, is blocked.
	RestrictPublicBuckets *bool `locationName:"RestrictPublicBuckets" type:"boolean"`
}

// String returns the string representation
func (s PublicAccessBlockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicAccessBlockConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlockPublicAcls != nil {
		v := *s.BlockPublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BlockPublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.BlockPublicPolicy != nil {
		v := *s.BlockPublicPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BlockPublicPolicy", protocol.BoolValue(v), metadata)
	}
	if s.IgnorePublicAcls != nil {
		v := *s.IgnorePublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IgnorePublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.RestrictPublicBuckets != nil {
		v := *s.RestrictPublicBuckets

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RestrictPublicBuckets", protocol.BoolValue(v), metadata)
	}
	return nil
}

type S3AccessControlList struct {
	_ struct{} `type:"structure"`

	Grants []S3Grant `type:"list"`

	// Owner is a required field
	Owner *S3ObjectOwner `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3AccessControlList) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3AccessControlList) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3AccessControlList"}

	if s.Owner == nil {
		invalidParams.Add(aws.NewErrParamRequired("Owner"))
	}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Owner != nil {
		if err := s.Owner.Validate(); err != nil {
			invalidParams.AddNested("Owner", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3AccessControlList) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grants != nil {
		v := s.Grants

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Grants", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	return nil
}

type S3AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	AccessControlList *S3AccessControlList `type:"structure"`

	CannedAccessControlList S3CannedAccessControlList `type:"string" enum:"true"`
}

// String returns the string representation
func (s S3AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3AccessControlPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3AccessControlPolicy"}
	if s.AccessControlList != nil {
		if err := s.AccessControlList.Validate(); err != nil {
			invalidParams.AddNested("AccessControlList", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3AccessControlPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlList != nil {
		v := s.AccessControlList

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AccessControlList", v, metadata)
	}
	if len(s.CannedAccessControlList) > 0 {
		v := s.CannedAccessControlList

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CannedAccessControlList", v, metadata)
	}
	return nil
}

// Contains the configuration parameters for a PUT Copy object operation. Amazon
// S3 Batch Operations passes each value through to the underlying PUT Copy
// object API. For more information about the parameters for this operation,
// see PUT Object - Copy (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html).
type S3CopyObjectOperation struct {
	_ struct{} `type:"structure"`

	AccessControlGrants []S3Grant `type:"list"`

	CannedAccessControlList S3CannedAccessControlList `type:"string" enum:"true"`

	MetadataDirective S3MetadataDirective `type:"string" enum:"true"`

	ModifiedSinceConstraint *time.Time `type:"timestamp"`

	NewObjectMetadata *S3ObjectMetadata `type:"structure"`

	NewObjectTagging []S3Tag `type:"list"`

	// The Legal Hold status to be applied to all objects in the Batch Operations
	// job.
	ObjectLockLegalHoldStatus S3ObjectLockLegalHoldStatus `type:"string" enum:"true"`

	// The Retention mode to be applied to all objects in the Batch Operations job.
	ObjectLockMode S3ObjectLockMode `type:"string" enum:"true"`

	// The date when the applied Object Retention configuration will expire on all
	// objects in the Batch Operations job.
	ObjectLockRetainUntilDate *time.Time `type:"timestamp"`

	RedirectLocation *string `min:"1" type:"string"`

	RequesterPays *bool `type:"boolean"`

	SSEAwsKmsKeyId *string `min:"1" type:"string"`

	StorageClass S3StorageClass `type:"string" enum:"true"`

	TargetKeyPrefix *string `min:"1" type:"string"`

	TargetResource *string `min:"1" type:"string"`

	UnModifiedSinceConstraint *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s S3CopyObjectOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3CopyObjectOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3CopyObjectOperation"}
	if s.RedirectLocation != nil && len(*s.RedirectLocation) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RedirectLocation", 1))
	}
	if s.SSEAwsKmsKeyId != nil && len(*s.SSEAwsKmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SSEAwsKmsKeyId", 1))
	}
	if s.TargetKeyPrefix != nil && len(*s.TargetKeyPrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetKeyPrefix", 1))
	}
	if s.TargetResource != nil && len(*s.TargetResource) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetResource", 1))
	}
	if s.AccessControlGrants != nil {
		for i, v := range s.AccessControlGrants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlGrants", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.NewObjectMetadata != nil {
		if err := s.NewObjectMetadata.Validate(); err != nil {
			invalidParams.AddNested("NewObjectMetadata", err.(aws.ErrInvalidParams))
		}
	}
	if s.NewObjectTagging != nil {
		for i, v := range s.NewObjectTagging {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NewObjectTagging", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3CopyObjectOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlGrants != nil {
		v := s.AccessControlGrants

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AccessControlGrants", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.CannedAccessControlList) > 0 {
		v := s.CannedAccessControlList

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CannedAccessControlList", v, metadata)
	}
	if len(s.MetadataDirective) > 0 {
		v := s.MetadataDirective

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MetadataDirective", v, metadata)
	}
	if s.ModifiedSinceConstraint != nil {
		v := *s.ModifiedSinceConstraint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ModifiedSinceConstraint",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.NewObjectMetadata != nil {
		v := s.NewObjectMetadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NewObjectMetadata", v, metadata)
	}
	if s.NewObjectTagging != nil {
		v := s.NewObjectTagging

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NewObjectTagging", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ObjectLockLegalHoldStatus) > 0 {
		v := s.ObjectLockLegalHoldStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectLockLegalHoldStatus", v, metadata)
	}
	if len(s.ObjectLockMode) > 0 {
		v := s.ObjectLockMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectLockMode", v, metadata)
	}
	if s.ObjectLockRetainUntilDate != nil {
		v := *s.ObjectLockRetainUntilDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectLockRetainUntilDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.RedirectLocation != nil {
		v := *s.RedirectLocation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RedirectLocation", protocol.StringValue(v), metadata)
	}
	if s.RequesterPays != nil {
		v := *s.RequesterPays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequesterPays", protocol.BoolValue(v), metadata)
	}
	if s.SSEAwsKmsKeyId != nil {
		v := *s.SSEAwsKmsKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SSEAwsKmsKeyId", protocol.StringValue(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.TargetKeyPrefix != nil {
		v := *s.TargetKeyPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetKeyPrefix", protocol.StringValue(v), metadata)
	}
	if s.TargetResource != nil {
		v := *s.TargetResource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetResource", protocol.StringValue(v), metadata)
	}
	if s.UnModifiedSinceConstraint != nil {
		v := *s.UnModifiedSinceConstraint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UnModifiedSinceConstraint",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	return nil
}

type S3Grant struct {
	_ struct{} `type:"structure"`

	Grantee *S3Grantee `type:"structure"`

	Permission S3Permission `type:"string" enum:"true"`
}

// String returns the string representation
func (s S3Grant) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Grant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Grant) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grantee != nil {
		v := s.Grantee

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Grantee", v, metadata)
	}
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permission", v, metadata)
	}
	return nil
}

type S3Grantee struct {
	_ struct{} `type:"structure"`

	DisplayName *string `min:"1" type:"string"`

	Identifier *string `min:"1" type:"string"`

	TypeIdentifier S3GranteeTypeIdentifier `type:"string" enum:"true"`
}

// String returns the string representation
func (s S3Grantee) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Grantee) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Grantee"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DisplayName", 1))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Grantee) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.Identifier != nil {
		v := *s.Identifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Identifier", protocol.StringValue(v), metadata)
	}
	if len(s.TypeIdentifier) > 0 {
		v := s.TypeIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TypeIdentifier", v, metadata)
	}
	return nil
}

// Contains the configuration parameters for an Initiate Glacier Restore job.
// Amazon S3 Batch Operations passes each value through to the underlying POST
// Object restore API. For more information about the parameters for this operation,
// see Restoring Archives (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request).
type S3InitiateRestoreObjectOperation struct {
	_ struct{} `type:"structure"`

	ExpirationInDays *int64 `type:"integer"`

	GlacierJobTier S3GlacierJobTier `type:"string" enum:"true"`
}

// String returns the string representation
func (s S3InitiateRestoreObjectOperation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3InitiateRestoreObjectOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExpirationInDays != nil {
		v := *s.ExpirationInDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpirationInDays", protocol.Int64Value(v), metadata)
	}
	if len(s.GlacierJobTier) > 0 {
		v := s.GlacierJobTier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GlacierJobTier", v, metadata)
	}
	return nil
}

type S3ObjectLockLegalHold struct {
	_ struct{} `type:"structure"`

	// The Legal Hold status to be applied to all objects in the Batch Operations
	// job.
	//
	// Status is a required field
	Status S3ObjectLockLegalHoldStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s S3ObjectLockLegalHold) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectLockLegalHold) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ObjectLockLegalHold"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3ObjectLockLegalHold) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

type S3ObjectMetadata struct {
	_ struct{} `type:"structure"`

	CacheControl *string `min:"1" type:"string"`

	ContentDisposition *string `min:"1" type:"string"`

	ContentEncoding *string `min:"1" type:"string"`

	ContentLanguage *string `min:"1" type:"string"`

	ContentLength *int64 `type:"long"`

	ContentMD5 *string `min:"1" type:"string"`

	ContentType *string `min:"1" type:"string"`

	HttpExpiresDate *time.Time `type:"timestamp"`

	RequesterCharged *bool `type:"boolean"`

	SSEAlgorithm S3SSEAlgorithm `type:"string" enum:"true"`

	UserMetadata map[string]string `type:"map"`
}

// String returns the string representation
func (s S3ObjectMetadata) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectMetadata) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ObjectMetadata"}
	if s.CacheControl != nil && len(*s.CacheControl) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CacheControl", 1))
	}
	if s.ContentDisposition != nil && len(*s.ContentDisposition) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContentDisposition", 1))
	}
	if s.ContentEncoding != nil && len(*s.ContentEncoding) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContentEncoding", 1))
	}
	if s.ContentLanguage != nil && len(*s.ContentLanguage) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContentLanguage", 1))
	}
	if s.ContentMD5 != nil && len(*s.ContentMD5) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContentMD5", 1))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3ObjectMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.CacheControl != nil {
		v := *s.CacheControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CacheControl", protocol.StringValue(v), metadata)
	}
	if s.ContentDisposition != nil {
		v := *s.ContentDisposition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentDisposition", protocol.StringValue(v), metadata)
	}
	if s.ContentEncoding != nil {
		v := *s.ContentEncoding

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentEncoding", protocol.StringValue(v), metadata)
	}
	if s.ContentLanguage != nil {
		v := *s.ContentLanguage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentLanguage", protocol.StringValue(v), metadata)
	}
	if s.ContentLength != nil {
		v := *s.ContentLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentLength", protocol.Int64Value(v), metadata)
	}
	if s.ContentMD5 != nil {
		v := *s.ContentMD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentMD5", protocol.StringValue(v), metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentType", protocol.StringValue(v), metadata)
	}
	if s.HttpExpiresDate != nil {
		v := *s.HttpExpiresDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpExpiresDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.RequesterCharged != nil {
		v := *s.RequesterCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequesterCharged", protocol.BoolValue(v), metadata)
	}
	if len(s.SSEAlgorithm) > 0 {
		v := s.SSEAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SSEAlgorithm", v, metadata)
	}
	if s.UserMetadata != nil {
		v := s.UserMetadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "UserMetadata", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.StringValue(v1))
		}
		ms0.End()

	}
	return nil
}

type S3ObjectOwner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `min:"1" type:"string"`

	ID *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3ObjectOwner) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectOwner) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ObjectOwner"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DisplayName", 1))
	}
	if s.ID != nil && len(*s.ID) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3ObjectOwner) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	return nil
}

type S3Retention struct {
	_ struct{} `type:"structure"`

	// The Retention mode to be applied to all objects in the Batch Operations job.
	Mode S3ObjectLockRetentionMode `type:"string" enum:"true"`

	// The date when the applied Object Retention will expire on all objects in
	// the Batch Operations job.
	RetainUntilDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s S3Retention) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Retention) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", v, metadata)
	}
	if s.RetainUntilDate != nil {
		v := *s.RetainUntilDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RetainUntilDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	return nil
}

// Contains the configuration parameters for a Set Object ACL operation. Amazon
// S3 Batch Operations passes each value through to the underlying PUT Object
// acl API. For more information about the parameters for this operation, see
// PUT Object acl (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html).
type S3SetObjectAclOperation struct {
	_ struct{} `type:"structure"`

	AccessControlPolicy *S3AccessControlPolicy `type:"structure"`
}

// String returns the string representation
func (s S3SetObjectAclOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectAclOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3SetObjectAclOperation"}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3SetObjectAclOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlPolicy != nil {
		v := s.AccessControlPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AccessControlPolicy", v, metadata)
	}
	return nil
}

// Contains the configuration parameters for a Set Object Legal Hold operation.
// Amazon S3 Batch Operations passes each value through to the underlying PUT
// Object Legal Hold API. For more information about the parameters for this
// operation, see PUT Object Legal Hold (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.htmll#object-lock-legal-holds).
type S3SetObjectLegalHoldOperation struct {
	_ struct{} `type:"structure"`

	// The Legal Hold contains the status to be applied to all objects in the Batch
	// Operations job.
	//
	// LegalHold is a required field
	LegalHold *S3ObjectLockLegalHold `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3SetObjectLegalHoldOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectLegalHoldOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3SetObjectLegalHoldOperation"}

	if s.LegalHold == nil {
		invalidParams.Add(aws.NewErrParamRequired("LegalHold"))
	}
	if s.LegalHold != nil {
		if err := s.LegalHold.Validate(); err != nil {
			invalidParams.AddNested("LegalHold", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3SetObjectLegalHoldOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.LegalHold != nil {
		v := s.LegalHold

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LegalHold", v, metadata)
	}
	return nil
}

// Contains the configuration parameters for a Set Object Retention operation.
// Amazon S3 Batch Operations passes each value through to the underlying PUT
// Object Retention API. For more information about the parameters for this
// operation, see PUT Object Retention (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes).
type S3SetObjectRetentionOperation struct {
	_ struct{} `type:"structure"`

	// Indicates if the operation should be applied to objects in the Batch Operations
	// job even if they have Governance-type Object Lock in place.
	BypassGovernanceRetention *bool `type:"boolean"`

	// Amazon S3 object lock Retention contains the retention mode to be applied
	// to all objects in the Batch Operations job.
	//
	// Retention is a required field
	Retention *S3Retention `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3SetObjectRetentionOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectRetentionOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3SetObjectRetentionOperation"}

	if s.Retention == nil {
		invalidParams.Add(aws.NewErrParamRequired("Retention"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3SetObjectRetentionOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.BypassGovernanceRetention != nil {
		v := *s.BypassGovernanceRetention

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BypassGovernanceRetention", protocol.BoolValue(v), metadata)
	}
	if s.Retention != nil {
		v := s.Retention

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Retention", v, metadata)
	}
	return nil
}

// Contains the configuration parameters for a Set Object Tagging operation.
// Amazon S3 Batch Operations passes each value through to the underlying PUT
// Object tagging API. For more information about the parameters for this operation,
// see PUT Object tagging (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTtagging.html).
type S3SetObjectTaggingOperation struct {
	_ struct{} `type:"structure"`

	TagSet []S3Tag `type:"list"`
}

// String returns the string representation
func (s S3SetObjectTaggingOperation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectTaggingOperation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3SetObjectTaggingOperation"}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3SetObjectTaggingOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.TagSet != nil {
		v := s.TagSet

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TagSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

type S3Tag struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// The virtual private cloud (VPC) configuration for an access point.
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// If this field is specified, this access point will only allow connections
	// from the specified VPC ID.
	//
	// VpcId is a required field
	VpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VpcConfiguration"}

	if s.VpcId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.StringValue(v), metadata)
	}
	return nil
}
