// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateCompilationJobInput struct {
	_ struct{} `type:"structure"`

	// A name for the model compilation job. The name must be unique within the
	// AWS Region and within your AWS account.
	//
	// CompilationJobName is a required field
	CompilationJobName *string `min:"1" type:"string" required:"true"`

	// Provides information about the location of input model artifacts, the name
	// and shape of the expected data inputs, and the framework in which the model
	// was trained.
	//
	// InputConfig is a required field
	InputConfig *InputConfig `type:"structure" required:"true"`

	// Provides information about the output location for the compiled model and
	// the target device the model runs on.
	//
	// OutputConfig is a required field
	OutputConfig *OutputConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker
	// to perform tasks on your behalf.
	//
	// During model compilation, Amazon SageMaker needs your permission to:
	//
	//    * Read input data from an S3 bucket
	//
	//    * Write model artifacts to an S3 bucket
	//
	//    * Write logs to Amazon CloudWatch Logs
	//
	//    * Publish metrics to Amazon CloudWatch
	//
	// You grant permissions for all of these tasks to an IAM role. To pass this
	// role to Amazon SageMaker, the caller of this API must have the iam:PassRole
	// permission. For more information, see Amazon SageMaker Roles. (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html)
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies a limit to how long a model compilation job can run. When the job
	// reaches the time limit, Amazon SageMaker ends the compilation job. Use this
	// API to cap model training costs.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCompilationJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCompilationJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCompilationJobInput"}

	if s.CompilationJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CompilationJobName"))
	}
	if s.CompilationJobName != nil && len(*s.CompilationJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CompilationJobName", 1))
	}

	if s.InputConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputConfig"))
	}

	if s.OutputConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputConfig"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if s.StoppingCondition == nil {
		invalidParams.Add(aws.NewErrParamRequired("StoppingCondition"))
	}
	if s.InputConfig != nil {
		if err := s.InputConfig.Validate(); err != nil {
			invalidParams.AddNested("InputConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateCompilationJobOutput struct {
	_ struct{} `type:"structure"`

	// If the action is successful, the service sends back an HTTP 200 response.
	// Amazon SageMaker returns the following data in JSON format:
	//
	//    * CompilationJobArn: The Amazon Resource Name (ARN) of the compiled job.
	//
	// CompilationJobArn is a required field
	CompilationJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCompilationJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateCompilationJob = "CreateCompilationJob"

// CreateCompilationJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Starts a model compilation job. After the model has been compiled, Amazon
// SageMaker saves the resulting model artifacts to an Amazon Simple Storage
// Service (Amazon S3) bucket that you specify.
//
// If you choose to host your model using Amazon SageMaker hosting services,
// you can use the resulting model artifacts as part of the model. You can also
// use the artifacts with AWS IoT Greengrass. In that case, deploy them as an
// ML resource.
//
// In the request body, you provide the following:
//
//    * A name for the compilation job
//
//    * Information about the input model artifacts
//
//    * The output location for the compiled model and the device (target) that
//    the model runs on
//
//    * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker
//    assumes to perform the model compilation job
//
// You can also provide a Tag to track the model compilation job's resource
// use and costs. The response body contains the CompilationJobArn for the compiled
// job.
//
// To stop a model compilation job, use StopCompilationJob. To get information
// about a particular model compilation job, use DescribeCompilationJob. To
// get information about multiple model compilation jobs, use ListCompilationJobs.
//
//    // Example sending a request using CreateCompilationJobRequest.
//    req := client.CreateCompilationJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob
func (c *Client) CreateCompilationJobRequest(input *CreateCompilationJobInput) CreateCompilationJobRequest {
	op := &aws.Operation{
		Name:       opCreateCompilationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCompilationJobInput{}
	}

	req := c.newRequest(op, input, &CreateCompilationJobOutput{})

	return CreateCompilationJobRequest{Request: req, Input: input, Copy: c.CreateCompilationJobRequest}
}

// CreateCompilationJobRequest is the request type for the
// CreateCompilationJob API operation.
type CreateCompilationJobRequest struct {
	*aws.Request
	Input *CreateCompilationJobInput
	Copy  func(*CreateCompilationJobInput) CreateCompilationJobRequest
}

// Send marshals and sends the CreateCompilationJob API request.
func (r CreateCompilationJobRequest) Send(ctx context.Context) (*CreateCompilationJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCompilationJobResponse{
		CreateCompilationJobOutput: r.Request.Data.(*CreateCompilationJobOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCompilationJobResponse is the response type for the
// CreateCompilationJob API operation.
type CreateCompilationJobResponse struct {
	*CreateCompilationJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCompilationJob request.
func (r *CreateCompilationJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
