// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTrialComponentsInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only components created after the specified time.
	CreatedAfter *time.Time `type:"timestamp"`

	// A filter that returns only components created before the specified time.
	CreatedBefore *time.Time `type:"timestamp"`

	// A filter that returns only components that are part of the specified experiment.
	// If you specify ExperimentName, you can't filter by SourceArn or TrialName.
	ExperimentName *string `min:"1" type:"string"`

	// The maximum number of components to return in the response. The default value
	// is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous call to ListTrialComponents didn't return the full set of
	// components, the call returns a token for getting the next set of components.
	NextToken *string `type:"string"`

	// The property used to sort results. The default value is CreationTime.
	SortBy SortTrialComponentsBy `type:"string" enum:"true"`

	// The sort order. The default value is Descending.
	SortOrder SortOrder `type:"string" enum:"true"`

	// A filter that returns only components that have the specified source Amazon
	// Resource Name (ARN). If you specify SourceArn, you can't filter by ExperimentName
	// or TrialName.
	SourceArn *string `type:"string"`

	// A filter that returns only components that are part of the specified trial.
	// If you specify TrialName, you can't filter by ExperimentName or SourceArn.
	TrialName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTrialComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrialComponentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTrialComponentsInput"}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExperimentName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTrialComponentsOutput struct {
	_ struct{} `type:"structure"`

	// A token for getting the next set of components, if there are any.
	NextToken *string `type:"string"`

	// A list of the summaries of your trial components.
	TrialComponentSummaries []TrialComponentSummary `type:"list"`
}

// String returns the string representation
func (s ListTrialComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTrialComponents = "ListTrialComponents"

// ListTrialComponentsRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Lists the trial components in your account. You can sort the list by trial
// component name or creation time. You can filter the list to show only components
// that were created in a specific time range. You can also filter on one of
// the following:
//
//    * ExperimentName
//
//    * SourceArn
//
//    * TrialName
//
//    // Example sending a request using ListTrialComponentsRequest.
//    req := client.ListTrialComponentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrialComponents
func (c *Client) ListTrialComponentsRequest(input *ListTrialComponentsInput) ListTrialComponentsRequest {
	op := &aws.Operation{
		Name:       opListTrialComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrialComponentsInput{}
	}

	req := c.newRequest(op, input, &ListTrialComponentsOutput{})

	return ListTrialComponentsRequest{Request: req, Input: input, Copy: c.ListTrialComponentsRequest}
}

// ListTrialComponentsRequest is the request type for the
// ListTrialComponents API operation.
type ListTrialComponentsRequest struct {
	*aws.Request
	Input *ListTrialComponentsInput
	Copy  func(*ListTrialComponentsInput) ListTrialComponentsRequest
}

// Send marshals and sends the ListTrialComponents API request.
func (r ListTrialComponentsRequest) Send(ctx context.Context) (*ListTrialComponentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTrialComponentsResponse{
		ListTrialComponentsOutput: r.Request.Data.(*ListTrialComponentsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTrialComponentsRequestPaginator returns a paginator for ListTrialComponents.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTrialComponentsRequest(input)
//   p := sagemaker.NewListTrialComponentsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTrialComponentsPaginator(req ListTrialComponentsRequest) ListTrialComponentsPaginator {
	return ListTrialComponentsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTrialComponentsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTrialComponentsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTrialComponentsPaginator struct {
	aws.Pager
}

func (p *ListTrialComponentsPaginator) CurrentPage() *ListTrialComponentsOutput {
	return p.Pager.CurrentPage().(*ListTrialComponentsOutput)
}

// ListTrialComponentsResponse is the response type for the
// ListTrialComponents API operation.
type ListTrialComponentsResponse struct {
	*ListTrialComponentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTrialComponents request.
func (r *ListTrialComponentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
