// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The user profile name.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`

	// A collection of settings.
	UserSettings *UserSettings `type:"structure"`
}

// String returns the string representation
func (s UpdateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateUserProfileInput"}

	if s.DomainId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainId"))
	}

	if s.UserProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserProfileName"))
	}
	if s.UserSettings != nil {
		if err := s.UserSettings.Validate(); err != nil {
			invalidParams.AddNested("UserSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The user profile Amazon Resource Name (ARN).
	UserProfileArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateUserProfile = "UpdateUserProfile"

// UpdateUserProfileRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Updates a user profile.
//
//    // Example sending a request using UpdateUserProfileRequest.
//    req := client.UpdateUserProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateUserProfile
func (c *Client) UpdateUserProfileRequest(input *UpdateUserProfileInput) UpdateUserProfileRequest {
	op := &aws.Operation{
		Name:       opUpdateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserProfileInput{}
	}

	req := c.newRequest(op, input, &UpdateUserProfileOutput{})

	return UpdateUserProfileRequest{Request: req, Input: input, Copy: c.UpdateUserProfileRequest}
}

// UpdateUserProfileRequest is the request type for the
// UpdateUserProfile API operation.
type UpdateUserProfileRequest struct {
	*aws.Request
	Input *UpdateUserProfileInput
	Copy  func(*UpdateUserProfileInput) UpdateUserProfileRequest
}

// Send marshals and sends the UpdateUserProfile API request.
func (r UpdateUserProfileRequest) Send(ctx context.Context) (*UpdateUserProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateUserProfileResponse{
		UpdateUserProfileOutput: r.Request.Data.(*UpdateUserProfileOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateUserProfileResponse is the response type for the
// UpdateUserProfile API operation.
type UpdateUserProfileResponse struct {
	*UpdateUserProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateUserProfile request.
func (r *UpdateUserProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
