// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Specifies the training algorithm to use in a CreateTrainingJob request.
//
// For more information about algorithms provided by Amazon SageMaker, see Algorithms
// (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information
// about using your own algorithms, see Using Your Own Algorithms with Amazon
// SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
type AlgorithmSpecification struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm resource to use for the training job. This must
	// be an algorithm resource that you created or subscribe to on AWS Marketplace.
	// If you specify a value for this parameter, you can't specify a value for
	// TrainingImage.
	AlgorithmName *string `min:"1" type:"string"`

	// To generate and save time-series metrics during training, set to true. The
	// default is false and time-series metrics aren't generated except in the following
	// cases:
	//
	//    * You use one of the Amazon SageMaker built-in algorithms
	//
	//    * You use one of the following Prebuilt Amazon SageMaker Docker Images
	//    (https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html):
	//    Tensorflow (version >= 1.15) MXNet (version >= 1.6) PyTorch (version >=
	//    1.3)
	//
	//    * You specify at least one MetricDefinition
	EnableSageMakerMetricsTimeSeries *bool `type:"boolean"`

	// A list of metric definition objects. Each object specifies the metric name
	// and regular expressions used to parse algorithm logs. Amazon SageMaker publishes
	// each metric to Amazon CloudWatch.
	MetricDefinitions []MetricDefinition `type:"list"`

	// The registry path of the Docker image that contains the training algorithm.
	// For information about docker registry paths for built-in algorithms, see
	// Algorithms Provided by Amazon SageMaker: Common Parameters (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	// Amazon SageMaker supports both registry/repository[:tag] and registry/repository[@digest]
	// image path formats. For more information, see Using Your Own Algorithms with
	// Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	TrainingImage *string `type:"string"`

	// The input mode that the algorithm supports. For the input modes that Amazon
	// SageMaker algorithms support, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	// If an algorithm supports the File input mode, Amazon SageMaker downloads
	// the training data from S3 to the provisioned ML storage Volume, and mounts
	// the directory to docker volume for training container. If an algorithm supports
	// the Pipe input mode, Amazon SageMaker streams data directly from S3 to the
	// container.
	//
	// In File mode, make sure you provision ML storage volume with sufficient capacity
	// to accommodate the data download from S3. In addition to the training data,
	// the ML storage volume also stores the output model. The algorithm container
	// use ML storage volume to also store intermediate information, if any.
	//
	// For distributed algorithms using File mode, training data is distributed
	// uniformly, and your training duration is predictable if the input data objects
	// size is approximately same. Amazon SageMaker does not split the files any
	// further for model training. If the object sizes are skewed, training won't
	// be optimal as the data distribution is also skewed where one host in a training
	// cluster is overloaded, thus becoming bottleneck in training.
	//
	// TrainingInputMode is a required field
	TrainingInputMode TrainingInputMode `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AlgorithmSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AlgorithmSpecification"}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlgorithmName", 1))
	}
	if len(s.TrainingInputMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TrainingInputMode"))
	}
	if s.MetricDefinitions != nil {
		for i, v := range s.MetricDefinitions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDefinitions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the validation and image scan statuses of the algorithm.
type AlgorithmStatusDetails struct {
	_ struct{} `type:"structure"`

	// The status of the scan of the algorithm's Docker image container.
	ImageScanStatuses []AlgorithmStatusItem `type:"list"`

	// The status of algorithm validation.
	ValidationStatuses []AlgorithmStatusItem `type:"list"`
}

// String returns the string representation
func (s AlgorithmStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// Represents the overall status of an algorithm.
type AlgorithmStatusItem struct {
	_ struct{} `type:"structure"`

	// if the overall status is Failed, the reason for the failure.
	FailureReason *string `type:"string"`

	// The name of the algorithm for which the overall status is being reported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The current status.
	//
	// Status is a required field
	Status DetailedAlgorithmStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AlgorithmStatusItem) String() string {
	return awsutil.Prettify(s)
}

// Provides summary information about an algorithm.
type AlgorithmSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `min:"1" type:"string" required:"true"`

	// A brief description of the algorithm.
	AlgorithmDescription *string `type:"string"`

	// The name of the algorithm that is described by the summary.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// The overall status of the algorithm.
	//
	// AlgorithmStatus is a required field
	AlgorithmStatus AlgorithmStatus `type:"string" required:"true" enum:"true"`

	// A timestamp that shows when the algorithm was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AlgorithmSummary) String() string {
	return awsutil.Prettify(s)
}

// Defines a training job and a batch transform job that Amazon SageMaker runs
// to validate your algorithm.
//
// The data provided in the validation profile is made available to your buyers
// on AWS Marketplace.
type AlgorithmValidationProfile struct {
	_ struct{} `type:"structure"`

	// The name of the profile for the algorithm. The name must have 1 to 63 characters.
	// Valid characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// ProfileName is a required field
	ProfileName *string `min:"1" type:"string" required:"true"`

	// The TrainingJobDefinition object that describes the training job that Amazon
	// SageMaker runs to validate your algorithm.
	//
	// TrainingJobDefinition is a required field
	TrainingJobDefinition *TrainingJobDefinition `type:"structure" required:"true"`

	// The TransformJobDefinition object that describes the transform job that Amazon
	// SageMaker runs to validate your algorithm.
	TransformJobDefinition *TransformJobDefinition `type:"structure"`
}

// String returns the string representation
func (s AlgorithmValidationProfile) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmValidationProfile) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AlgorithmValidationProfile"}

	if s.ProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfileName", 1))
	}

	if s.TrainingJobDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingJobDefinition"))
	}
	if s.TrainingJobDefinition != nil {
		if err := s.TrainingJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TrainingJobDefinition", err.(aws.ErrInvalidParams))
		}
	}
	if s.TransformJobDefinition != nil {
		if err := s.TransformJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TransformJobDefinition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies configurations for one or more training jobs that Amazon SageMaker
// runs to test the algorithm.
type AlgorithmValidationSpecification struct {
	_ struct{} `type:"structure"`

	// An array of AlgorithmValidationProfile objects, each of which specifies a
	// training job and batch transform job that Amazon SageMaker runs to validate
	// your algorithm.
	//
	// ValidationProfiles is a required field
	ValidationProfiles []AlgorithmValidationProfile `min:"1" type:"list" required:"true"`

	// The IAM roles that Amazon SageMaker uses to run the training jobs.
	//
	// ValidationRole is a required field
	ValidationRole *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AlgorithmValidationSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmValidationSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AlgorithmValidationSpecification"}

	if s.ValidationProfiles == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValidationProfiles"))
	}
	if s.ValidationProfiles != nil && len(s.ValidationProfiles) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ValidationProfiles", 1))
	}

	if s.ValidationRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValidationRole"))
	}
	if s.ValidationRole != nil && len(*s.ValidationRole) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ValidationRole", 20))
	}
	if s.ValidationProfiles != nil {
		for i, v := range s.ValidationProfiles {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationProfiles", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configures how labels are consolidated across human workers and processes
// output data.
type AnnotationConsolidationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a Lambda function implements the logic
	// for annotation consolidation (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html)
	// and to process output data.
	//
	// This parameter is required for all labeling jobs. For built-in task types
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html), use
	// one of the following Amazon SageMaker Ground Truth Lambda function ARNs for
	// AnnotationConsolidationLambdaArn. For custom labeling workflows, see Post-annotation
	// Lambda (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda).
	//
	// Bounding box - Finds the most similar boxes from different workers based
	// on the Jaccard index of the boxes.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox
	//
	// Image classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of an image based on annotations from individual
	// workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass
	//
	// Multi-label image classification - Uses a variant of the Expectation Maximization
	// approach to estimate the true classes of an image based on annotations from
	// individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel
	//
	// Semantic segmentation - Treats each pixel in an image as a multi-class classification
	// and treats pixel annotations from workers as "votes" for the correct label.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation
	//
	// Text classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of text based on annotations from individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass
	//
	// Multi-label text classification - Uses a variant of the Expectation Maximization
	// approach to estimate the true classes of text based on annotations from individual
	// workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel
	//
	// Named entity recognition - Groups similar selections and calculates aggregate
	// boundaries, resolving to most-assigned label.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition
	//
	// 3D point cloud object detection - Use this task type when you want workers
	// to classify objects in a 3D point cloud by drawing 3D cuboids around objects.
	// For example, you can use this task type to ask workers to identify different
	// types of objects in a point cloud, such as cars, bikes, and pedestrians.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection
	//
	// 3D point cloud object tracking - Use this task type when you want workers
	// to draw 3D cuboids around objects that appear in a sequence of 3D point cloud
	// frames. For example, you can use this task type to ask workers to track the
	// movement of vehicles across multiple point cloud frames.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking
	//
	// 3D point cloud semantic segmentation - Use this task type when you want workers
	// to create a point-level semantic segmentation masks by painting objects in
	// a 3D point cloud using different colors where each color is assigned to one
	// of the classes you specify.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation
	//
	// Use the following ARNs for Label Verification and Adjustment Jobs
	//
	// Use label verification and adjustment jobs to review and adjust labels. To
	// learn more, see Verify and Adjust Labels (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html).
	//
	// Semantic segmentation adjustment - Treats each pixel in an image as a multi-class
	// classification and treats pixel adjusted annotations from workers as "votes"
	// for the correct label.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation
	//
	// Semantic segmentation verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgment for semantic
	// segmentation labels based on annotations from individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation
	//
	// Bounding box verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgement for bounding
	// box labels based on annotations from individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox
	//
	// Bounding box adjustment - Finds the most similar boxes from different workers
	// based on the Jaccard index of the adjusted annotations.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox
	//
	// 3D point cloud object detection adjustment - Use this task type when you
	// want workers to adjust 3D cuboids around objects in a 3D point cloud.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// 3D point cloud object tracking adjustment - Use this task type when you want
	// workers to adjust 3D cuboids around objects that appear in a sequence of
	// 3D point cloud frames.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// 3D point cloud semantic segmentation adjustment - Use this task type when
	// you want workers to adjust a point-level semantic segmentation masks using
	// a paint tool.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// AnnotationConsolidationLambdaArn is a required field
	AnnotationConsolidationLambdaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AnnotationConsolidationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnnotationConsolidationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnnotationConsolidationConfig"}

	if s.AnnotationConsolidationLambdaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnnotationConsolidationLambdaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The app's details.
type AppDetails struct {
	_ struct{} `type:"structure"`

	// The name of the app.
	AppName *string `type:"string"`

	// The type of app.
	AppType AppType `type:"string" enum:"true"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The status.
	Status AppStatus `type:"string" enum:"true"`

	// The user profile name.
	UserProfileName *string `type:"string"`
}

// String returns the string representation
func (s AppDetails) String() string {
	return awsutil.Prettify(s)
}

// Configuration to run a processing job in a specified container image.
type AppSpecification struct {
	_ struct{} `type:"structure"`

	// The arguments for a container used to run a processing job.
	ContainerArguments []string `min:"1" type:"list"`

	// The entrypoint for a container used to run a processing job.
	ContainerEntrypoint []string `min:"1" type:"list"`

	// The container image to be run by the processing job.
	//
	// ImageUri is a required field
	ImageUri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AppSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AppSpecification"}
	if s.ContainerArguments != nil && len(s.ContainerArguments) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerArguments", 1))
	}
	if s.ContainerEntrypoint != nil && len(s.ContainerEntrypoint) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerEntrypoint", 1))
	}

	if s.ImageUri == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An AutoPilot job will return recommendations, or candidates. Each candidate
// has futher details about the steps involed, and the status.
type AutoMLCandidate struct {
	_ struct{} `type:"structure"`

	// The candidate name.
	//
	// CandidateName is a required field
	CandidateName *string `min:"1" type:"string" required:"true"`

	// The candidate's status.
	//
	// CandidateStatus is a required field
	CandidateStatus CandidateStatus `type:"string" required:"true" enum:"true"`

	// The candidate's steps.
	//
	// CandidateSteps is a required field
	CandidateSteps []AutoMLCandidateStep `type:"list" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The end time.
	EndTime *time.Time `type:"timestamp"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// The candidate result from a job.
	FinalAutoMLJobObjectiveMetric *FinalAutoMLJobObjectiveMetric `type:"structure"`

	// The inference containers.
	InferenceContainers []AutoMLContainerDefinition `type:"list"`

	// The last modified time.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// The objective status.
	//
	// ObjectiveStatus is a required field
	ObjectiveStatus ObjectiveStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AutoMLCandidate) String() string {
	return awsutil.Prettify(s)
}

// Information about the steps for a Candidate, and what step it is working
// on.
type AutoMLCandidateStep struct {
	_ struct{} `type:"structure"`

	// The ARN for the Candidate's step.
	//
	// CandidateStepArn is a required field
	CandidateStepArn *string `min:"1" type:"string" required:"true"`

	// The name for the Candidate's step.
	//
	// CandidateStepName is a required field
	CandidateStepName *string `min:"1" type:"string" required:"true"`

	// Whether the Candidate is at the transform, training, or processing step.
	//
	// CandidateStepType is a required field
	CandidateStepType CandidateStepType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AutoMLCandidateStep) String() string {
	return awsutil.Prettify(s)
}

// Similar to Channel. A channel is a named input source that training algorithms
// can consume. Refer to Channel for detailed descriptions.
type AutoMLChannel struct {
	_ struct{} `type:"structure"`

	// You can use Gzip or None. The default value is None.
	CompressionType CompressionType `type:"string" enum:"true"`

	// The data source.
	//
	// DataSource is a required field
	DataSource *AutoMLDataSource `type:"structure" required:"true"`

	// The name of the target variable in supervised learning, a.k.a. 'y'.
	//
	// TargetAttributeName is a required field
	TargetAttributeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLChannel) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLChannel) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoMLChannel"}

	if s.DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSource"))
	}

	if s.TargetAttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetAttributeName"))
	}
	if s.TargetAttributeName != nil && len(*s.TargetAttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetAttributeName", 1))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of container definitions that describe the different containers that
// make up one AutoML candidate. Refer to ContainerDefinition for more details.
type AutoMLContainerDefinition struct {
	_ struct{} `type:"structure"`

	// Environment variables to set in the container. Refer to ContainerDefinition
	// for more details.
	Environment map[string]string `type:"map"`

	// The ECR path of the container. Refer to ContainerDefinition for more details.
	//
	// Image is a required field
	Image *string `type:"string" required:"true"`

	// The location of the model artifacts. Refer to ContainerDefinition for more
	// details.
	//
	// ModelDataUrl is a required field
	ModelDataUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// The data source for the AutoPilot job.
type AutoMLDataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the input data.
	//
	// The input data must be in CSV format and contain at least 1000 rows.
	//
	// S3DataSource is a required field
	S3DataSource *AutoMLS3DataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s AutoMLDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoMLDataSource"}

	if s.S3DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Artifacts that are generation during a job.
type AutoMLJobArtifacts struct {
	_ struct{} `type:"structure"`

	// The URL to the notebook location.
	CandidateDefinitionNotebookLocation *string `min:"1" type:"string"`

	// The URL to the notebook location.
	DataExplorationNotebookLocation *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AutoMLJobArtifacts) String() string {
	return awsutil.Prettify(s)
}

// How long a job is allowed to run, or how many candidates a job is allowed
// to generate.
type AutoMLJobCompletionCriteria struct {
	_ struct{} `type:"structure"`

	// The maximum time, in seconds, an AutoML job is allowed to wait for a trial
	// to complete. It must be equal to or greater than MaxRuntimePerTrainingJobInSeconds.
	MaxAutoMLJobRuntimeInSeconds *int64 `min:"1" type:"integer"`

	// The maximum number of times a training job is allowed to run.
	MaxCandidates *int64 `min:"1" type:"integer"`

	// The maximum time, in seconds, a job is allowed to run.
	MaxRuntimePerTrainingJobInSeconds *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s AutoMLJobCompletionCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLJobCompletionCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoMLJobCompletionCriteria"}
	if s.MaxAutoMLJobRuntimeInSeconds != nil && *s.MaxAutoMLJobRuntimeInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxAutoMLJobRuntimeInSeconds", 1))
	}
	if s.MaxCandidates != nil && *s.MaxCandidates < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxCandidates", 1))
	}
	if s.MaxRuntimePerTrainingJobInSeconds != nil && *s.MaxRuntimePerTrainingJobInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRuntimePerTrainingJobInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A collection of settings used for a job.
type AutoMLJobConfig struct {
	_ struct{} `type:"structure"`

	// How long a job is allowed to run, or how many candidates a job is allowed
	// to generate.
	CompletionCriteria *AutoMLJobCompletionCriteria `type:"structure"`

	// Security configuration for traffic encryption or Amazon VPC settings.
	SecurityConfig *AutoMLSecurityConfig `type:"structure"`
}

// String returns the string representation
func (s AutoMLJobConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLJobConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoMLJobConfig"}
	if s.CompletionCriteria != nil {
		if err := s.CompletionCriteria.Validate(); err != nil {
			invalidParams.AddNested("CompletionCriteria", err.(aws.ErrInvalidParams))
		}
	}
	if s.SecurityConfig != nil {
		if err := s.SecurityConfig.Validate(); err != nil {
			invalidParams.AddNested("SecurityConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Applies a metric to minimize or maximize for the job's objective.
type AutoMLJobObjective struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName AutoMLMetricEnum `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AutoMLJobObjective) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLJobObjective) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoMLJobObjective"}
	if len(s.MetricName) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a summary about a job.
type AutoMLJobSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the job.
	//
	// AutoMLJobArn is a required field
	AutoMLJobArn *string `min:"1" type:"string" required:"true"`

	// The name of the object you are requesting.
	//
	// AutoMLJobName is a required field
	AutoMLJobName *string `min:"1" type:"string" required:"true"`

	// The job's secondary status.
	//
	// AutoMLJobSecondaryStatus is a required field
	AutoMLJobSecondaryStatus AutoMLJobSecondaryStatus `type:"string" required:"true" enum:"true"`

	// The job's status.
	//
	// AutoMLJobStatus is a required field
	AutoMLJobStatus AutoMLJobStatus `type:"string" required:"true" enum:"true"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The end time.
	EndTime *time.Time `type:"timestamp"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// When the job was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AutoMLJobSummary) String() string {
	return awsutil.Prettify(s)
}

// The output data configuration.
type AutoMLOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The AWS KMS encryption key ID.
	KmsKeyId *string `type:"string"`

	// The Amazon S3 output path. Must be 128 characters or less.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLOutputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoMLOutputDataConfig"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Amazon S3 data source.
type AutoMLS3DataSource struct {
	_ struct{} `type:"structure"`

	// The data type.
	//
	// S3DataType is a required field
	S3DataType AutoMLS3DataType `type:"string" required:"true" enum:"true"`

	// The URL to the Amazon S3 data source.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLS3DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLS3DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoMLS3DataSource"}
	if len(s.S3DataType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("S3DataType"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Security options.
type AutoMLSecurityConfig struct {
	_ struct{} `type:"structure"`

	// Whether to use traffic encryption between the container layers.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// The key used to encrypt stored data.
	VolumeKmsKeyId *string `type:"string"`

	// VPC configuration.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s AutoMLSecurityConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLSecurityConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoMLSecurityConfig"}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CaptureContentTypeHeader struct {
	_ struct{} `type:"structure"`

	CsvContentTypes []string `min:"1" type:"list"`

	JsonContentTypes []string `min:"1" type:"list"`
}

// String returns the string representation
func (s CaptureContentTypeHeader) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptureContentTypeHeader) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CaptureContentTypeHeader"}
	if s.CsvContentTypes != nil && len(s.CsvContentTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CsvContentTypes", 1))
	}
	if s.JsonContentTypes != nil && len(s.JsonContentTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JsonContentTypes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CaptureOption struct {
	_ struct{} `type:"structure"`

	// CaptureMode is a required field
	CaptureMode CaptureMode `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CaptureOption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptureOption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CaptureOption"}
	if len(s.CaptureMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("CaptureMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of categorical hyperparameters to tune.
type CategoricalParameterRange struct {
	_ struct{} `type:"structure"`

	// The name of the categorical hyperparameter to tune.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A list of the categories for the hyperparameter.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CategoricalParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CategoricalParameterRange"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the possible values for a categorical hyperparameter.
type CategoricalParameterRangeSpecification struct {
	_ struct{} `type:"structure"`

	// The allowed categories for the hyperparameter.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CategoricalParameterRangeSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalParameterRangeSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CategoricalParameterRangeSpecification"}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A channel is a named input source that training algorithms can consume.
type Channel struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// If training data is compressed, the compression type. The default value is
	// None. CompressionType is used only in Pipe input mode. In File mode, leave
	// this field unset or set it to None.
	CompressionType CompressionType `type:"string" enum:"true"`

	// The MIME type of the data.
	ContentType *string `type:"string"`

	// The location of the channel data.
	//
	// DataSource is a required field
	DataSource *DataSource `type:"structure" required:"true"`

	// (Optional) The input mode to use for the data channel in a training job.
	// If you don't set a value for InputMode, Amazon SageMaker uses the value set
	// for TrainingInputMode. Use this parameter to override the TrainingInputMode
	// setting in a AlgorithmSpecification request when you have a channel that
	// needs a different input mode from the training job's general setting. To
	// download the data from Amazon Simple Storage Service (Amazon S3) to the provisioned
	// ML storage volume, and mount the directory to a Docker volume, use File input
	// mode. To stream data directly from Amazon S3 to the container, choose Pipe
	// input mode.
	//
	// To use a model for incremental training, choose File input model.
	InputMode TrainingInputMode `type:"string" enum:"true"`

	// Specify RecordIO as the value when input data is in raw format but the training
	// algorithm requires the RecordIO format. In this case, Amazon SageMaker wraps
	// each individual S3 object in a RecordIO record. If the input data is already
	// in RecordIO format, you don't need to set this attribute. For more information,
	// see Create a Dataset Using RecordIO (https://mxnet.apache.org/api/architecture/note_data_loading#data-format).
	//
	// In File mode, leave this field unset or set it to None.
	RecordWrapperType RecordWrapper `type:"string" enum:"true"`

	// A configuration for a shuffle option for input data in a channel. If you
	// use S3Prefix for S3DataType, this shuffles the results of the S3 key prefix
	// matches. If you use ManifestFile, the order of the S3 object references in
	// the ManifestFile is shuffled. If you use AugmentedManifestFile, the order
	// of the JSON lines in the AugmentedManifestFile is shuffled. The shuffling
	// order is determined using the Seed value.
	//
	// For Pipe input mode, shuffling is done at the start of every epoch. With
	// large datasets this ensures that the order of the training data is different
	// for each epoch, it helps reduce bias and possible overfitting. In a multi-node
	// training job when ShuffleConfig is combined with S3DataDistributionType of
	// ShardedByS3Key, the data is shuffled across nodes so that the content sent
	// to a particular node on the first epoch might be sent to a different node
	// on the second epoch.
	ShuffleConfig *ShuffleConfig `type:"structure"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Channel) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Channel"}

	if s.ChannelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelName", 1))
	}

	if s.DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSource"))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(aws.ErrInvalidParams))
		}
	}
	if s.ShuffleConfig != nil {
		if err := s.ShuffleConfig.Validate(); err != nil {
			invalidParams.AddNested("ShuffleConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a named input source, called a channel, to be used by an algorithm.
type ChannelSpecification struct {
	_ struct{} `type:"structure"`

	// A brief description of the channel.
	Description *string `type:"string"`

	// Indicates whether the channel is required by the algorithm.
	IsRequired *bool `type:"boolean"`

	// The name of the channel.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The allowed compression types, if data compression is used.
	SupportedCompressionTypes []CompressionType `type:"list"`

	// The supported MIME types for the data.
	//
	// SupportedContentTypes is a required field
	SupportedContentTypes []string `type:"list" required:"true"`

	// The allowed input mode, either FILE or PIPE.
	//
	// In FILE mode, Amazon SageMaker copies the data from the input source onto
	// the local Amazon Elastic Block Store (Amazon EBS) volumes before starting
	// your training algorithm. This is the most commonly used input mode.
	//
	// In PIPE mode, Amazon SageMaker streams input data from the source directly
	// to your algorithm without using the EBS volume.
	//
	// SupportedInputModes is a required field
	SupportedInputModes []TrainingInputMode `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ChannelSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ChannelSpecification"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SupportedContentTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedContentTypes"))
	}

	if s.SupportedInputModes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedInputModes"))
	}
	if s.SupportedInputModes != nil && len(s.SupportedInputModes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SupportedInputModes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about the output location for managed spot training
// checkpoint data.
type CheckpointConfig struct {
	_ struct{} `type:"structure"`

	// (Optional) The local directory where checkpoints are written. The default
	// directory is /opt/ml/checkpoints/.
	LocalPath *string `type:"string"`

	// Identifies the S3 path where you want Amazon SageMaker to store checkpoints.
	// For example, s3://bucket-name/key-name-prefix.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CheckpointConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckpointConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CheckpointConfig"}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies summary information about a Git repository.
type CodeRepositorySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Git repository.
	//
	// CodeRepositoryArn is a required field
	CodeRepositoryArn *string `min:"1" type:"string" required:"true"`

	// The name of the Git repository.
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`

	// The date and time that the Git repository was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Configuration details for the Git repository, including the URL where it
	// is located and the ARN of the AWS Secrets Manager secret that contains the
	// credentials used to access the repository.
	GitConfig *GitConfig `type:"structure"`

	// The date and time that the Git repository was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s CodeRepositorySummary) String() string {
	return awsutil.Prettify(s)
}

// Identifies a Amazon Cognito user group. A user group can be used in on or
// more work teams.
type CognitoMemberDefinition struct {
	_ struct{} `type:"structure"`

	// An identifier for an application client. You must create the app client ID
	// using Amazon Cognito.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// An identifier for a user group.
	//
	// UserGroup is a required field
	UserGroup *string `min:"1" type:"string" required:"true"`

	// An identifier for a user pool. The user pool must be in the same region as
	// the service that you are calling.
	//
	// UserPool is a required field
	UserPool *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CognitoMemberDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoMemberDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CognitoMemberDefinition"}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}

	if s.UserGroup == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserGroup"))
	}
	if s.UserGroup != nil && len(*s.UserGroup) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserGroup", 1))
	}

	if s.UserPool == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPool"))
	}
	if s.UserPool != nil && len(*s.UserPool) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPool", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration information for tensor collections.
type CollectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the tensor collection. The name must be unique relative to other
	// rule configuration names.
	CollectionName *string `min:"1" type:"string"`

	// Parameter values for the tensor collection. The allowed parameters are "name",
	// "include_regex", "reduction_config", "save_config", "tensor_names", and "save_histogram".
	CollectionParameters map[string]string `type:"map"`
}

// String returns the string representation
func (s CollectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CollectionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CollectionConfiguration"}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CollectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A summary of a model compilation job.
type CompilationJobSummary struct {
	_ struct{} `type:"structure"`

	// The time when the model compilation job completed.
	CompilationEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the model compilation job.
	//
	// CompilationJobArn is a required field
	CompilationJobArn *string `type:"string" required:"true"`

	// The name of the model compilation job that you want a summary for.
	//
	// CompilationJobName is a required field
	CompilationJobName *string `min:"1" type:"string" required:"true"`

	// The status of the model compilation job.
	//
	// CompilationJobStatus is a required field
	CompilationJobStatus CompilationJobStatus `type:"string" required:"true" enum:"true"`

	// The time when the model compilation job started.
	CompilationStartTime *time.Time `type:"timestamp"`

	// The type of device that the model will run on after compilation has completed.
	//
	// CompilationTargetDevice is a required field
	CompilationTargetDevice TargetDevice `type:"string" required:"true" enum:"true"`

	// The time when the model compilation job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The time when the model compilation job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CompilationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes the container, as part of model definition.
type ContainerDefinition struct {
	_ struct{} `type:"structure"`

	// This parameter is ignored for models that contain only a PrimaryContainer.
	//
	// When a ContainerDefinition is part of an inference pipeline, the value of
	// the parameter uniquely identifies the container for the purposes of logging
	// and metrics. For information, see Use Logs and Metrics to Monitor an Inference
	// Pipeline (https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html).
	// If you don't specify a value for this parameter for a ContainerDefinition
	// that is part of an inference pipeline, a unique name is automatically assigned
	// based on the position of the ContainerDefinition in the pipeline. If you
	// specify a value for the ContainerHostName for any ContainerDefinition that
	// is part of an inference pipeline, you must specify a value for the ContainerHostName
	// parameter of every ContainerDefinition in that pipeline.
	ContainerHostname *string `type:"string"`

	// The environment variables to set in the Docker container. Each key and value
	// in the Environment string to string map can have length of up to 1024. We
	// support up to 16 entries in the map.
	Environment map[string]string `type:"map"`

	// The Amazon EC2 Container Registry (Amazon ECR) path where inference code
	// is stored. If you are using your own custom algorithm instead of an algorithm
	// provided by Amazon SageMaker, the inference code must meet Amazon SageMaker
	// requirements. Amazon SageMaker supports both registry/repository[:tag] and
	// registry/repository[@digest] image path formats. For more information, see
	// Using Your Own Algorithms with Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html)
	Image *string `type:"string"`

	// Whether the container hosts a single model or multiple models.
	Mode ContainerMode `type:"string" enum:"true"`

	// The S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix). The S3 path is required for Amazon SageMaker built-in algorithms,
	// but not if you use your own algorithms. For more information on built-in
	// algorithms, see Common Parameters (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	//
	// If you provide a value for this parameter, Amazon SageMaker uses AWS Security
	// Token Service to download model artifacts from the S3 path you provide. AWS
	// STS is activated in your IAM user account by default. If you previously deactivated
	// AWS STS for a region, you need to reactivate AWS STS for that region. For
	// more information, see Activating and Deactivating AWS STS in an AWS Region
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
	// in the AWS Identity and Access Management User Guide.
	//
	// If you use a built-in algorithm to create a model, Amazon SageMaker requires
	// that you provide a S3 path to the model artifacts in ModelDataUrl.
	ModelDataUrl *string `type:"string"`

	// The name or Amazon Resource Name (ARN) of the model package to use to create
	// the model.
	ModelPackageName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContainerDefinition"}
	if s.ModelPackageName != nil && len(*s.ModelPackageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelPackageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of continuous hyperparameters to tune.
type ContinuousParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum value for the hyperparameter. The tuning job uses floating-point
	// values between MinValue value and this value for tuning.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum value for the hyperparameter. The tuning job uses floating-point
	// values between this value and MaxValuefor tuning.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`

	// The name of the continuous hyperparameter to tune.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values:
	//
	// Auto
	//
	// Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
	//
	// Linear
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have only values greater than
	// 0.
	//
	// ReverseLogarithmic
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a reverse logarithmic scale.
	//
	// Reverse logarithmic scaling works only for ranges that are entirely within
	// the range 0<=x<1.0.
	ScalingType HyperParameterScalingType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ContinuousParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContinuousParameterRange"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the possible values for a continuous hyperparameter.
type ContinuousParameterRangeSpecification struct {
	_ struct{} `type:"structure"`

	// The maximum floating-point value allowed.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum floating-point value allowed.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ContinuousParameterRangeSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousParameterRangeSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContinuousParameterRangeSpecification"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DataCaptureConfig struct {
	_ struct{} `type:"structure"`

	CaptureContentTypeHeader *CaptureContentTypeHeader `type:"structure"`

	// CaptureOptions is a required field
	CaptureOptions []CaptureOption `min:"1" type:"list" required:"true"`

	// DestinationS3Uri is a required field
	DestinationS3Uri *string `type:"string" required:"true"`

	EnableCapture *bool `type:"boolean"`

	// InitialSamplingPercentage is a required field
	InitialSamplingPercentage *int64 `type:"integer" required:"true"`

	KmsKeyId *string `type:"string"`
}

// String returns the string representation
func (s DataCaptureConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataCaptureConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataCaptureConfig"}

	if s.CaptureOptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("CaptureOptions"))
	}
	if s.CaptureOptions != nil && len(s.CaptureOptions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CaptureOptions", 1))
	}

	if s.DestinationS3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationS3Uri"))
	}

	if s.InitialSamplingPercentage == nil {
		invalidParams.Add(aws.NewErrParamRequired("InitialSamplingPercentage"))
	}
	if s.CaptureContentTypeHeader != nil {
		if err := s.CaptureContentTypeHeader.Validate(); err != nil {
			invalidParams.AddNested("CaptureContentTypeHeader", err.(aws.ErrInvalidParams))
		}
	}
	if s.CaptureOptions != nil {
		for i, v := range s.CaptureOptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptureOptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DataCaptureConfigSummary struct {
	_ struct{} `type:"structure"`

	// CaptureStatus is a required field
	CaptureStatus CaptureStatus `type:"string" required:"true" enum:"true"`

	// CurrentSamplingPercentage is a required field
	CurrentSamplingPercentage *int64 `type:"integer" required:"true"`

	// DestinationS3Uri is a required field
	DestinationS3Uri *string `type:"string" required:"true"`

	// EnableCapture is a required field
	EnableCapture *bool `type:"boolean" required:"true"`

	// KmsKeyId is a required field
	KmsKeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DataCaptureConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// The data structure used to specify the data to be used for inference in a
// batch transform job and to associate the data that is relevant to the prediction
// results in the output. The input filter provided allows you to exclude input
// data that is not needed for inference in a batch transform job. The output
// filter provided allows you to include input data relevant to interpreting
// the predictions in the output from the job. For more information, see Associate
// Prediction Results with their Corresponding Input Records (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
type DataProcessing struct {
	_ struct{} `type:"structure"`

	// A JSONPath (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators)
	// expression used to select a portion of the input data to pass to the algorithm.
	// Use the InputFilter parameter to exclude fields, such as an ID column, from
	// the input. If you want Amazon SageMaker to pass the entire input dataset
	// to the algorithm, accept the default value $.
	//
	// Examples: "$", "$[1:]", "$.features"
	InputFilter *string `type:"string"`

	// Specifies the source of the data to join with the transformed data. The valid
	// values are None and Input. The default value is None, which specifies not
	// to join the input with the transformed data. If you want the batch transform
	// job to join the original input data with the transformed data, set JoinSource
	// to Input.
	//
	// For JSON or JSONLines objects, such as a JSON array, Amazon SageMaker adds
	// the transformed data to the input JSON object in an attribute called SageMakerOutput.
	// The joined result for JSON must be a key-value pair object. If the input
	// is not a key-value pair object, Amazon SageMaker creates a new JSON file.
	// In the new JSON file, and the input data is stored under the SageMakerInput
	// key and the results are stored in SageMakerOutput.
	//
	// For CSV files, Amazon SageMaker combines the transformed data with the input
	// data at the end of the input data and stores it in the output file. The joined
	// data has the joined input data followed by the transformed data and the output
	// is a CSV file.
	JoinSource JoinSource `type:"string" enum:"true"`

	// A JSONPath (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators)
	// expression used to select a portion of the joined dataset to save in the
	// output file for a batch transform job. If you want Amazon SageMaker to store
	// the entire input dataset in the output file, leave the default value, $.
	// If you specify indexes that aren't within the dimension size of the joined
	// dataset, you get an error.
	//
	// Examples: "$", "$[0,5:]", "$['id','SageMakerOutput']"
	OutputFilter *string `type:"string"`
}

// String returns the string representation
func (s DataProcessing) String() string {
	return awsutil.Prettify(s)
}

// Describes the location of the channel data.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The file system that is associated with a channel.
	FileSystemDataSource *FileSystemDataSource `type:"structure"`

	// The S3 location of the data source that is associated with a channel.
	S3DataSource *S3DataSource `type:"structure"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSource"}
	if s.FileSystemDataSource != nil {
		if err := s.FileSystemDataSource.Validate(); err != nil {
			invalidParams.AddNested("FileSystemDataSource", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration information for the debug hook parameters, collection configuration,
// and storage paths.
type DebugHookConfig struct {
	_ struct{} `type:"structure"`

	// Configuration information for tensor collections.
	CollectionConfigurations []CollectionConfiguration `type:"list"`

	// Configuration information for the debug hook parameters.
	HookParameters map[string]string `type:"map"`

	// Path to local storage location for tensors. Defaults to /opt/ml/output/tensors/.
	LocalPath *string `type:"string"`

	// Path to Amazon S3 storage location for tensors.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DebugHookConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DebugHookConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DebugHookConfig"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}
	if s.CollectionConfigurations != nil {
		for i, v := range s.CollectionConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CollectionConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration information for debugging rules.
type DebugRuleConfiguration struct {
	_ struct{} `type:"structure"`

	// The instance type to deploy for a training job.
	InstanceType ProcessingInstanceType `type:"string" enum:"true"`

	// Path to local storage location for output of rules. Defaults to /opt/ml/processing/output/rule/.
	LocalPath *string `type:"string"`

	// The name of the rule configuration. It must be unique relative to other rule
	// configuration names.
	//
	// RuleConfigurationName is a required field
	RuleConfigurationName *string `min:"1" type:"string" required:"true"`

	// The Amazon Elastic Container (ECR) Image for the managed rule evaluation.
	//
	// RuleEvaluatorImage is a required field
	RuleEvaluatorImage *string `type:"string" required:"true"`

	// Runtime configuration for rule container.
	RuleParameters map[string]string `type:"map"`

	// Path to Amazon S3 storage location for rules.
	S3OutputPath *string `type:"string"`

	// The size, in GB, of the ML storage volume attached to the processing instance.
	VolumeSizeInGB *int64 `type:"integer"`
}

// String returns the string representation
func (s DebugRuleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DebugRuleConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DebugRuleConfiguration"}

	if s.RuleConfigurationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleConfigurationName"))
	}
	if s.RuleConfigurationName != nil && len(*s.RuleConfigurationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleConfigurationName", 1))
	}

	if s.RuleEvaluatorImage == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleEvaluatorImage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the status of the rule evaluation.
type DebugRuleEvaluationStatus struct {
	_ struct{} `type:"structure"`

	// Timestamp when the rule evaluation status was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the rule configuration
	RuleConfigurationName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the rule evaluation job.
	RuleEvaluationJobArn *string `type:"string"`

	// Status of the rule evaluation.
	RuleEvaluationStatus RuleEvaluationStatus `type:"string" enum:"true"`

	// Details from the rule evaluation.
	StatusDetails *string `type:"string"`
}

// String returns the string representation
func (s DebugRuleEvaluationStatus) String() string {
	return awsutil.Prettify(s)
}

// Gets the Amazon EC2 Container Registry path of the docker image of the model
// that is hosted in this ProductionVariant.
//
// If you used the registry/repository[:tag] form to specify the image path
// of the primary container when you created the model hosted in this ProductionVariant,
// the path resolves to a path of the form registry/repository[@digest]. A digest
// is a hash value that identifies a specific version of an image. For information
// about Amazon ECR paths, see Pulling an Image (https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html)
// in the Amazon ECR User Guide.
type DeployedImage struct {
	_ struct{} `type:"structure"`

	// The date and time when the image path for the model resolved to the ResolvedImage
	ResolutionTime *time.Time `type:"timestamp"`

	// The specific digest path of the image hosted in this ProductionVariant.
	ResolvedImage *string `type:"string"`

	// The image path you specified when you created the model.
	SpecifiedImage *string `type:"string"`
}

// String returns the string representation
func (s DeployedImage) String() string {
	return awsutil.Prettify(s)
}

// Specifies weight and capacity values for a production variant.
type DesiredWeightAndCapacity struct {
	_ struct{} `type:"structure"`

	// The variant's capacity.
	DesiredInstanceCount *int64 `min:"1" type:"integer"`

	// The variant's weight.
	DesiredWeight *float64 `type:"float"`

	// The name of the variant to update.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DesiredWeightAndCapacity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DesiredWeightAndCapacity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DesiredWeightAndCapacity"}
	if s.DesiredInstanceCount != nil && *s.DesiredInstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("DesiredInstanceCount", 1))
	}

	if s.VariantName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VariantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The domain's details.
type DomainDetails struct {
	_ struct{} `type:"structure"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// The domain's Amazon Resource Name (ARN).
	DomainArn *string `type:"string"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The domain name.
	DomainName *string `type:"string"`

	// The last modified time.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The status.
	Status DomainStatus `type:"string" enum:"true"`

	// The domain's URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DomainDetails) String() string {
	return awsutil.Prettify(s)
}

// Provides summary information for an endpoint configuration.
type EndpointConfigSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint configuration was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint configuration.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EndpointConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// Input object for the endpoint
type EndpointInput struct {
	_ struct{} `type:"structure"`

	// An endpoint in customer's account which has enabled DataCaptureConfig enabled.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// Path to the filesystem where the endpoint data is available to the container.
	//
	// LocalPath is a required field
	LocalPath *string `type:"string" required:"true"`

	// Whether input data distributed in Amazon S3 is fully replicated or sharded
	// by an S3 key. Defauts to FullyReplicated
	S3DataDistributionType ProcessingS3DataDistributionType `type:"string" enum:"true"`

	// Whether the Pipe or File is used as the input mode for transfering data for
	// the monitoring job. Pipe mode is recommended for large datasets. File mode
	// is useful for small files that fit in memory. Defaults to File.
	S3InputMode ProcessingS3InputMode `type:"string" enum:"true"`
}

// String returns the string representation
func (s EndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EndpointInput"}

	if s.EndpointName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointName"))
	}

	if s.LocalPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocalPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information for an endpoint.
type EndpointSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the endpoint was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`

	// The name of the endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The status of the endpoint.
	//
	//    * OutOfService: Endpoint is not available to take incoming requests.
	//
	//    * Creating: CreateEndpoint is executing.
	//
	//    * Updating: UpdateEndpoint or UpdateEndpointWeightsAndCapacities is executing.
	//
	//    * SystemUpdating: Endpoint is undergoing maintenance and cannot be updated
	//    or deleted or re-scaled until it has completed. This maintenance operation
	//    does not change any customer-specified values such as VPC config, KMS
	//    encryption, model, instance type, or instance count.
	//
	//    * RollingBack: Endpoint fails to scale up or down or change its variant
	//    weight and is in the process of rolling back to its previous configuration.
	//    Once the rollback completes, endpoint returns to an InService status.
	//    This transitional status only applies to an endpoint that has autoscaling
	//    enabled and is undergoing variant weight or capacity changes as part of
	//    an UpdateEndpointWeightsAndCapacities call or when the UpdateEndpointWeightsAndCapacities
	//    operation is called explicitly.
	//
	//    * InService: Endpoint is available to process incoming requests.
	//
	//    * Deleting: DeleteEndpoint is executing.
	//
	//    * Failed: Endpoint could not be created, updated, or re-scaled. Use DescribeEndpointOutput$FailureReason
	//    for information about the failure. DeleteEndpoint is the only operation
	//    that can be performed on a failed endpoint.
	//
	// To get a list of endpoints with a specified status, use the ListEndpointsInput$StatusEquals
	// filter.
	//
	// EndpointStatus is a required field
	EndpointStatus EndpointStatus `type:"string" required:"true" enum:"true"`

	// A timestamp that shows when the endpoint was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s EndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// The properties of an experiment as returned by the Search API.
type Experiment struct {
	_ struct{} `type:"structure"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	CreatedBy *UserContext `type:"structure"`

	// When the experiment was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the experiment.
	Description *string `type:"string"`

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string `type:"string"`

	// The name of the experiment.
	ExperimentName *string `min:"1" type:"string"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	LastModifiedBy *UserContext `type:"structure"`

	// When the experiment was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The source of the experiment.
	Source *ExperimentSource `type:"structure"`

	// The list of tags that are associated with the experiment. You can use Search
	// API to search on the tags.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s Experiment) String() string {
	return awsutil.Prettify(s)
}

// Configuration for the experiment.
type ExperimentConfig struct {
	_ struct{} `type:"structure"`

	// The name of the experiment.
	ExperimentName *string `min:"1" type:"string"`

	// Display name for the trial component.
	TrialComponentDisplayName *string `min:"1" type:"string"`

	// The name of the trial.
	TrialName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ExperimentConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExperimentConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExperimentConfig"}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExperimentName", 1))
	}
	if s.TrialComponentDisplayName != nil && len(*s.TrialComponentDisplayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrialComponentDisplayName", 1))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The source of the experiment.
type ExperimentSource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source.
	//
	// SourceArn is a required field
	SourceArn *string `type:"string" required:"true"`

	// The source type.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s ExperimentSource) String() string {
	return awsutil.Prettify(s)
}

// A summary of the properties of an experiment. To get the complete set of
// properties, call the DescribeExperiment API and provide the ExperimentName.
type ExperimentSummary struct {
	_ struct{} `type:"structure"`

	// When the experiment was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string `type:"string"`

	// The name of the experiment.
	ExperimentName *string `min:"1" type:"string"`

	// The source of the experiment.
	ExperimentSource *ExperimentSource `type:"structure"`

	// When the experiment was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ExperimentSummary) String() string {
	return awsutil.Prettify(s)
}

// Specifies a file system data source for a channel.
type FileSystemDataSource struct {
	_ struct{} `type:"structure"`

	// The full path to the directory to associate with the channel.
	//
	// DirectoryPath is a required field
	DirectoryPath *string `type:"string" required:"true"`

	// The access mode of the mount of the directory associated with the channel.
	// A directory can be mounted either in ro (read-only) or rw (read-write) mode.
	//
	// FileSystemAccessMode is a required field
	FileSystemAccessMode FileSystemAccessMode `type:"string" required:"true" enum:"true"`

	// The file system id.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The file system type.
	//
	// FileSystemType is a required field
	FileSystemType FileSystemType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s FileSystemDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileSystemDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FileSystemDataSource"}

	if s.DirectoryPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryPath"))
	}
	if len(s.FileSystemAccessMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemAccessMode"))
	}

	if s.FileSystemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(aws.NewErrParamMinLen("FileSystemId", 11))
	}
	if len(s.FileSystemType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A conditional statement for a search expression that includes a resource
// property, a Boolean operator, and a value. Resources that match the statement
// are returned in the results from the Search API.
//
// If you specify a Value, but not an Operator, Amazon SageMaker uses the equals
// operator.
//
// In search, there are several property types:
//
// Metrics
//
// To define a metric filter, enter a value using the form "Metrics.<name>",
// where <name> is a metric name. For example, the following filter searches
// for training jobs with an "accuracy" metric greater than "0.9":
//
// {
//
// "Name": "Metrics.accuracy",
//
// "Operator": "GreaterThan",
//
// "Value": "0.9"
//
// }
//
// HyperParameters
//
// To define a hyperparameter filter, enter a value with the form "HyperParameters.<name>".
// Decimal hyperparameter values are treated as a decimal in a comparison if
// the specified Value is also a decimal value. If the specified Value is an
// integer, the decimal hyperparameter values are treated as integers. For example,
// the following filter is satisfied by training jobs with a "learning_rate"
// hyperparameter that is less than "0.5":
//
// {
//
// "Name": "HyperParameters.learning_rate",
//
// "Operator": "LessThan",
//
// "Value": "0.5"
//
// }
//
// Tags
//
// To define a tag filter, enter a value with the form Tags.<key>.
type Filter struct {
	_ struct{} `type:"structure"`

	// A resource property name. For example, TrainingJobName. For valid property
	// names, see SearchRecord. You must specify a valid property for the resource.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A Boolean binary operator that is used to evaluate the filter. The operator
	// field contains one of the following values:
	//
	// Equals
	//
	// The value of Name equals Value.
	//
	// NotEquals
	//
	// The value of Name doesn't equal Value.
	//
	// Exists
	//
	// The Name property exists.
	//
	// NotExists
	//
	// The Name property does not exist.
	//
	// GreaterThan
	//
	// The value of Name is greater than Value. Not supported for text properties.
	//
	// GreaterThanOrEqualTo
	//
	// The value of Name is greater than or equal to Value. Not supported for text
	// properties.
	//
	// LessThan
	//
	// The value of Name is less than Value. Not supported for text properties.
	//
	// LessThanOrEqualTo
	//
	// The value of Name is less than or equal to Value. Not supported for text
	// properties.
	//
	// In
	//
	// The value of Name is one of the comma delimited strings in Value. Only supported
	// for text properties.
	//
	// Contains
	//
	// The value of Name contains the string Value. Only supported for text properties.
	//
	// A SearchExpression can include the Contains operator multiple times when
	// the value of Name is one of the following:
	//
	//    * Experiment.DisplayName
	//
	//    * Experiment.ExperimentName
	//
	//    * Experiment.Tags
	//
	//    * Trial.DisplayName
	//
	//    * Trial.TrialName
	//
	//    * Trial.Tags
	//
	//    * TrialComponent.DisplayName
	//
	//    * TrialComponent.TrialComponentName
	//
	//    * TrialComponent.Tags
	//
	//    * TrialComponent.InputArtifacts
	//
	//    * TrialComponent.OutputArtifacts
	//
	// A SearchExpression can include only one Contains operator for all other values
	// of Name. In these cases, if you include multiple Contains operators in the
	// SearchExpression, the result is the following error message: "'CONTAINS'
	// operator usage limit of 1 exceeded."
	Operator Operator `type:"string" enum:"true"`

	// A value used with Name and Operator to determine which resources satisfy
	// the filter's condition. For numerical properties, Value must be an integer
	// or floating-point decimal. For timestamp properties, Value must be an ISO
	// 8601 date-time string of the following format: YYYY-mm-dd'T'HH:MM:SS.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The candidate result from a job.
type FinalAutoMLJobObjectiveMetric struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName AutoMLMetricEnum `type:"string" required:"true" enum:"true"`

	// The metric type used.
	Type AutoMLJobObjectiveType `type:"string" enum:"true"`

	// The value of the metric.
	//
	// Value is a required field
	Value *float64 `type:"float" required:"true"`
}

// String returns the string representation
func (s FinalAutoMLJobObjectiveMetric) String() string {
	return awsutil.Prettify(s)
}

// Shows the final value for the objective metric for a training job that was
// launched by a hyperparameter tuning job. You define the objective metric
// in the HyperParameterTuningJobObjective parameter of HyperParameterTuningJobConfig.
type FinalHyperParameterTuningJobObjectiveMetric struct {
	_ struct{} `type:"structure"`

	// The name of the objective metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// Whether to minimize or maximize the objective metric. Valid values are Minimize
	// and Maximize.
	Type HyperParameterTuningJobObjectiveType `type:"string" enum:"true"`

	// The value of the objective metric.
	//
	// Value is a required field
	Value *float64 `type:"float" required:"true"`
}

// String returns the string representation
func (s FinalHyperParameterTuningJobObjectiveMetric) String() string {
	return awsutil.Prettify(s)
}

// Contains information about where human output will be stored.
type FlowDefinitionOutputConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Key Management Service (KMS) key ID for server-side encryption.
	KmsKeyId *string `type:"string"`

	// The Amazon S3 path where the object containing human output will be made
	// available.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FlowDefinitionOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowDefinitionOutputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FlowDefinitionOutputConfig"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains summary information about the flow definition.
type FlowDefinitionSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp when SageMaker created the flow definition.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The reason why the flow definition creation failed. A failure reason is returned
	// only when the flow definition status is Failed.
	FailureReason *string `type:"string"`

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// The name of the flow definition.
	//
	// FlowDefinitionName is a required field
	FlowDefinitionName *string `min:"1" type:"string" required:"true"`

	// The status of the flow definition. Valid values:
	//
	// FlowDefinitionStatus is a required field
	FlowDefinitionStatus FlowDefinitionStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s FlowDefinitionSummary) String() string {
	return awsutil.Prettify(s)
}

// Specifies configuration details for a Git repository in your AWS account.
type GitConfig struct {
	_ struct{} `type:"structure"`

	// The default branch for the Git repository.
	Branch *string `min:"1" type:"string"`

	// The URL where the Git repository is located.
	//
	// RepositoryUrl is a required field
	RepositoryUrl *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains
	// the credentials used to access the git repository. The secret must have a
	// staging label of AWSCURRENT and must be in the following format:
	//
	// {"username": UserName, "password": Password}
	SecretArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GitConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GitConfig"}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Branch", 1))
	}

	if s.RepositoryUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryUrl"))
	}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies configuration details for a Git repository when the repository
// is updated.
type GitConfigForUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains
	// the credentials used to access the git repository. The secret must have a
	// staging label of AWSCURRENT and must be in the following format:
	//
	// {"username": UserName, "password": Password}
	SecretArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GitConfigForUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitConfigForUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GitConfigForUpdate"}
	if s.SecretArn != nil && len(*s.SecretArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines under what conditions SageMaker creates a human loop. Used within
// . See for the required format of activation conditions.
type HumanLoopActivationConditionsConfig struct {
	_ struct{} `type:"structure"`

	// JSON expressing use-case specific conditions declaratively. If any condition
	// is matched, atomic tasks are created against the configured work team. The
	// set of conditions is different for Rekognition and Textract. For more information
	// about how to structure the JSON, see JSON Schema for Human Loop Activation
	// Conditions in Amazon Augmented AI (https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html)
	// in the Amazon SageMaker Developer Guide.
	//
	// HumanLoopActivationConditions is a required field
	HumanLoopActivationConditions aws.JSONValue `type:"jsonvalue" required:"true"`
}

// String returns the string representation
func (s HumanLoopActivationConditionsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopActivationConditionsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HumanLoopActivationConditionsConfig"}

	if s.HumanLoopActivationConditions == nil {
		invalidParams.Add(aws.NewErrParamRequired("HumanLoopActivationConditions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about how and under what conditions SageMaker creates
// a human loop. If HumanLoopActivationConfig is not given, then all requests
// go to humans.
type HumanLoopActivationConfig struct {
	_ struct{} `type:"structure"`

	// Container structure for defining under what conditions SageMaker creates
	// a human loop.
	//
	// HumanLoopActivationConditionsConfig is a required field
	HumanLoopActivationConditionsConfig *HumanLoopActivationConditionsConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s HumanLoopActivationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopActivationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HumanLoopActivationConfig"}

	if s.HumanLoopActivationConditionsConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("HumanLoopActivationConditionsConfig"))
	}
	if s.HumanLoopActivationConditionsConfig != nil {
		if err := s.HumanLoopActivationConditionsConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopActivationConditionsConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the work to be performed by human workers.
type HumanLoopConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the human task user interface.
	//
	// HumanTaskUiArn is a required field
	HumanTaskUiArn *string `type:"string" required:"true"`

	// Defines the amount of money paid to an Amazon Mechanical Turk worker for
	// each task performed.
	//
	// Use one of the following prices for bounding box tasks. Prices are in US
	// dollars and should be based on the complexity of the task; the longer it
	// takes in your initial testing, the more you should offer.
	//
	//    * 0.036
	//
	//    * 0.048
	//
	//    * 0.060
	//
	//    * 0.072
	//
	//    * 0.120
	//
	//    * 0.240
	//
	//    * 0.360
	//
	//    * 0.480
	//
	//    * 0.600
	//
	//    * 0.720
	//
	//    * 0.840
	//
	//    * 0.960
	//
	//    * 1.080
	//
	//    * 1.200
	//
	// Use one of the following prices for image classification, text classification,
	// and custom tasks. Prices are in US dollars.
	//
	//    * 0.012
	//
	//    * 0.024
	//
	//    * 0.036
	//
	//    * 0.048
	//
	//    * 0.060
	//
	//    * 0.072
	//
	//    * 0.120
	//
	//    * 0.240
	//
	//    * 0.360
	//
	//    * 0.480
	//
	//    * 0.600
	//
	//    * 0.720
	//
	//    * 0.840
	//
	//    * 0.960
	//
	//    * 1.080
	//
	//    * 1.200
	//
	// Use one of the following prices for semantic segmentation tasks. Prices are
	// in US dollars.
	//
	//    * 0.840
	//
	//    * 0.960
	//
	//    * 1.080
	//
	//    * 1.200
	//
	// Use one of the following prices for Textract AnalyzeDocument Important Form
	// Key Amazon Augmented AI review tasks. Prices are in US dollars.
	//
	//    * 2.400
	//
	//    * 2.280
	//
	//    * 2.160
	//
	//    * 2.040
	//
	//    * 1.920
	//
	//    * 1.800
	//
	//    * 1.680
	//
	//    * 1.560
	//
	//    * 1.440
	//
	//    * 1.320
	//
	//    * 1.200
	//
	//    * 1.080
	//
	//    * 0.960
	//
	//    * 0.840
	//
	//    * 0.720
	//
	//    * 0.600
	//
	//    * 0.480
	//
	//    * 0.360
	//
	//    * 0.240
	//
	//    * 0.120
	//
	//    * 0.072
	//
	//    * 0.060
	//
	//    * 0.048
	//
	//    * 0.036
	//
	//    * 0.024
	//
	//    * 0.012
	//
	// Use one of the following prices for Rekognition DetectModerationLabels Amazon
	// Augmented AI review tasks. Prices are in US dollars.
	//
	//    * 1.200
	//
	//    * 1.080
	//
	//    * 0.960
	//
	//    * 0.840
	//
	//    * 0.720
	//
	//    * 0.600
	//
	//    * 0.480
	//
	//    * 0.360
	//
	//    * 0.240
	//
	//    * 0.120
	//
	//    * 0.072
	//
	//    * 0.060
	//
	//    * 0.048
	//
	//    * 0.036
	//
	//    * 0.024
	//
	//    * 0.012
	//
	// Use one of the following prices for Amazon Augmented AI custom human review
	// tasks. Prices are in US dollars.
	//
	//    * 1.200
	//
	//    * 1.080
	//
	//    * 0.960
	//
	//    * 0.840
	//
	//    * 0.720
	//
	//    * 0.600
	//
	//    * 0.480
	//
	//    * 0.360
	//
	//    * 0.240
	//
	//    * 0.120
	//
	//    * 0.072
	//
	//    * 0.060
	//
	//    * 0.048
	//
	//    * 0.036
	//
	//    * 0.024
	//
	//    * 0.012
	PublicWorkforceTaskPrice *PublicWorkforceTaskPrice `type:"structure"`

	// The length of time that a task remains available for labeling by human workers.
	TaskAvailabilityLifetimeInSeconds *int64 `min:"1" type:"integer"`

	// The number of distinct workers who will perform the same task on each object.
	// For example, if TaskCount is set to 3 for an image classification labeling
	// job, three workers will classify each input image. Increasing TaskCount can
	// improve label accuracy.
	//
	// TaskCount is a required field
	TaskCount *int64 `min:"1" type:"integer" required:"true"`

	// A description for the human worker task.
	//
	// TaskDescription is a required field
	TaskDescription *string `min:"1" type:"string" required:"true"`

	// Keywords used to describe the task so that workers can discover the task.
	TaskKeywords []string `min:"1" type:"list"`

	// The amount of time that a worker has to complete a task.
	TaskTimeLimitInSeconds *int64 `min:"30" type:"integer"`

	// A title for the human worker task.
	//
	// TaskTitle is a required field
	TaskTitle *string `min:"1" type:"string" required:"true"`

	// Amazon Resource Name (ARN) of a team of workers.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HumanLoopConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HumanLoopConfig"}

	if s.HumanTaskUiArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("HumanTaskUiArn"))
	}
	if s.TaskAvailabilityLifetimeInSeconds != nil && *s.TaskAvailabilityLifetimeInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TaskAvailabilityLifetimeInSeconds", 1))
	}

	if s.TaskCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskCount"))
	}
	if s.TaskCount != nil && *s.TaskCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TaskCount", 1))
	}

	if s.TaskDescription == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskDescription"))
	}
	if s.TaskDescription != nil && len(*s.TaskDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskDescription", 1))
	}
	if s.TaskKeywords != nil && len(s.TaskKeywords) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskKeywords", 1))
	}
	if s.TaskTimeLimitInSeconds != nil && *s.TaskTimeLimitInSeconds < 30 {
		invalidParams.Add(aws.NewErrParamMinValue("TaskTimeLimitInSeconds", 30))
	}

	if s.TaskTitle == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskTitle"))
	}
	if s.TaskTitle != nil && len(*s.TaskTitle) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskTitle", 1))
	}

	if s.WorkteamArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkteamArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Container for configuring the source of human task requests.
type HumanLoopRequestSource struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon Rekognition or Amazon Textract are used as the integration
	// source. The default field settings and JSON parsing rules are different based
	// on the integration source. Valid values:
	//
	// AwsManagedHumanLoopRequestSource is a required field
	AwsManagedHumanLoopRequestSource AwsManagedHumanLoopRequestSource `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HumanLoopRequestSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopRequestSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HumanLoopRequestSource"}
	if len(s.AwsManagedHumanLoopRequestSource) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AwsManagedHumanLoopRequestSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information required for human workers to complete a labeling task.
type HumanTaskConfig struct {
	_ struct{} `type:"structure"`

	// Configures how labels are consolidated across human workers.
	//
	// AnnotationConsolidationConfig is a required field
	AnnotationConsolidationConfig *AnnotationConsolidationConfig `type:"structure" required:"true"`

	// Defines the maximum number of data objects that can be labeled by human workers
	// at the same time. Also referred to as batch size. Each object may have more
	// than one worker at one time. The default value is 1000 objects.
	MaxConcurrentTaskCount *int64 `min:"1" type:"integer"`

	// The number of human workers that will label an object.
	//
	// NumberOfHumanWorkersPerDataObject is a required field
	NumberOfHumanWorkersPerDataObject *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of a Lambda function that is run before a
	// data object is sent to a human worker. Use this function to provide input
	// to a custom labeling job.
	//
	// For built-in task types (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html),
	// use one of the following Amazon SageMaker Ground Truth Lambda function ARNs
	// for PreHumanTaskLambdaArn. For custom labeling workflows, see Pre-annotation
	// Lambda (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda).
	//
	// Bounding box - Finds the most similar boxes from different workers based
	// on the Jaccard index of the boxes.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox
	//
	// Image classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of an image based on annotations from individual
	// workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass
	//
	// Multi-label image classification - Uses a variant of the Expectation Maximization
	// approach to estimate the true classes of an image based on annotations from
	// individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel
	//
	// Semantic segmentation - Treats each pixel in an image as a multi-class classification
	// and treats pixel annotations from workers as "votes" for the correct label.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation
	//
	// Text classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of text based on annotations from individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass
	//
	// Multi-label text classification - Uses a variant of the Expectation Maximization
	// approach to estimate the true classes of text based on annotations from individual
	// workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel
	//
	// Named entity recognition - Groups similar selections and calculates aggregate
	// boundaries, resolving to most-assigned label.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition
	//
	// 3D Point Cloud Modalities
	//
	// Use the following pre-annotation lambdas for 3D point cloud labeling modality
	// tasks. See 3D Point Cloud Task types (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html)
	// to learn more.
	//
	// 3D Point Cloud Object Detection - Use this task type when you want workers
	// to classify objects in a 3D point cloud by drawing 3D cuboids around objects.
	// For example, you can use this task type to ask workers to identify different
	// types of objects in a point cloud, such as cars, bikes, and pedestrians.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection
	//
	// 3D Point Cloud Object Tracking - Use this task type when you want workers
	// to draw 3D cuboids around objects that appear in a sequence of 3D point cloud
	// frames. For example, you can use this task type to ask workers to track the
	// movement of vehicles across multiple point cloud frames.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking
	//
	// 3D Point Cloud Semantic Segmentation - Use this task type when you want workers
	// to create a point-level semantic segmentation masks by painting objects in
	// a 3D point cloud using different colors where each color is assigned to one
	// of the classes you specify.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation
	//
	// Use the following ARNs for Label Verification and Adjustment Jobs
	//
	// Use label verification and adjustment jobs to review and adjust labels. To
	// learn more, see Verify and Adjust Labels (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html).
	//
	// Bounding box verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgement for bounding
	// box labels based on annotations from individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// Bounding box adjustment - Finds the most similar boxes from different workers
	// based on the Jaccard index of the adjusted annotations.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox
	//
	// Semantic segmentation verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgment for semantic
	// segmentation labels based on annotations from individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation
	//
	// Semantic segmentation adjustment - Treats each pixel in an image as a multi-class
	// classification and treats pixel adjusted annotations from workers as "votes"
	// for the correct label.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation
	//
	// 3D point cloud object detection adjustment - Adjust 3D cuboids in a point
	// cloud frame.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// 3D point cloud object tracking adjustment - Adjust 3D cuboids across a sequence
	// of point cloud frames.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// 3D point cloud semantic segmentation adjustment - Adjust semantic segmentation
	// masks in a 3D point cloud.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// PreHumanTaskLambdaArn is a required field
	PreHumanTaskLambdaArn *string `type:"string" required:"true"`

	// The price that you pay for each task performed by an Amazon Mechanical Turk
	// worker.
	PublicWorkforceTaskPrice *PublicWorkforceTaskPrice `type:"structure"`

	// The length of time that a task remains available for labeling by human workers.
	// If you choose the Amazon Mechanical Turk workforce, the maximum is 12 hours
	// (43200). The default value is 864000 seconds (10 days). For private and vendor
	// workforces, the maximum is as listed.
	TaskAvailabilityLifetimeInSeconds *int64 `min:"60" type:"integer"`

	// A description of the task for your human workers.
	//
	// TaskDescription is a required field
	TaskDescription *string `min:"1" type:"string" required:"true"`

	// Keywords used to describe the task so that workers on Amazon Mechanical Turk
	// can discover the task.
	TaskKeywords []string `min:"1" type:"list"`

	// The amount of time that a worker has to complete a task.
	//
	// TaskTimeLimitInSeconds is a required field
	TaskTimeLimitInSeconds *int64 `min:"30" type:"integer" required:"true"`

	// A title for the task for your human workers.
	//
	// TaskTitle is a required field
	TaskTitle *string `min:"1" type:"string" required:"true"`

	// Information about the user interface that workers use to complete the labeling
	// task.
	//
	// UiConfig is a required field
	UiConfig *UiConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the work team assigned to complete the
	// tasks.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HumanTaskConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanTaskConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HumanTaskConfig"}

	if s.AnnotationConsolidationConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnnotationConsolidationConfig"))
	}
	if s.MaxConcurrentTaskCount != nil && *s.MaxConcurrentTaskCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxConcurrentTaskCount", 1))
	}

	if s.NumberOfHumanWorkersPerDataObject == nil {
		invalidParams.Add(aws.NewErrParamRequired("NumberOfHumanWorkersPerDataObject"))
	}
	if s.NumberOfHumanWorkersPerDataObject != nil && *s.NumberOfHumanWorkersPerDataObject < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("NumberOfHumanWorkersPerDataObject", 1))
	}

	if s.PreHumanTaskLambdaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PreHumanTaskLambdaArn"))
	}
	if s.TaskAvailabilityLifetimeInSeconds != nil && *s.TaskAvailabilityLifetimeInSeconds < 60 {
		invalidParams.Add(aws.NewErrParamMinValue("TaskAvailabilityLifetimeInSeconds", 60))
	}

	if s.TaskDescription == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskDescription"))
	}
	if s.TaskDescription != nil && len(*s.TaskDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskDescription", 1))
	}
	if s.TaskKeywords != nil && len(s.TaskKeywords) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskKeywords", 1))
	}

	if s.TaskTimeLimitInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskTimeLimitInSeconds"))
	}
	if s.TaskTimeLimitInSeconds != nil && *s.TaskTimeLimitInSeconds < 30 {
		invalidParams.Add(aws.NewErrParamMinValue("TaskTimeLimitInSeconds", 30))
	}

	if s.TaskTitle == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskTitle"))
	}
	if s.TaskTitle != nil && len(*s.TaskTitle) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskTitle", 1))
	}

	if s.UiConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("UiConfig"))
	}

	if s.WorkteamArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkteamArn"))
	}
	if s.AnnotationConsolidationConfig != nil {
		if err := s.AnnotationConsolidationConfig.Validate(); err != nil {
			invalidParams.AddNested("AnnotationConsolidationConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Container for human task user interface information.
type HumanTaskUiSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp when SageMaker created the human task user interface.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the human task user interface.
	//
	// HumanTaskUiArn is a required field
	HumanTaskUiArn *string `type:"string" required:"true"`

	// The name of the human task user interface.
	//
	// HumanTaskUiName is a required field
	HumanTaskUiName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s HumanTaskUiSummary) String() string {
	return awsutil.Prettify(s)
}

// Specifies which training algorithm to use for training jobs that a hyperparameter
// tuning job launches and the metrics to monitor.
type HyperParameterAlgorithmSpecification struct {
	_ struct{} `type:"structure"`

	// The name of the resource algorithm to use for the hyperparameter tuning job.
	// If you specify a value for this parameter, do not specify a value for TrainingImage.
	AlgorithmName *string `min:"1" type:"string"`

	// An array of MetricDefinition objects that specify the metrics that the algorithm
	// emits.
	MetricDefinitions []MetricDefinition `type:"list"`

	// The registry path of the Docker image that contains the training algorithm.
	// For information about Docker registry paths for built-in algorithms, see
	// Algorithms Provided by Amazon SageMaker: Common Parameters (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	// Amazon SageMaker supports both registry/repository[:tag] and registry/repository[@digest]
	// image path formats. For more information, see Using Your Own Algorithms with
	// Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	TrainingImage *string `type:"string"`

	// The input mode that the algorithm supports: File or Pipe. In File input mode,
	// Amazon SageMaker downloads the training data from Amazon S3 to the storage
	// volume that is attached to the training instance and mounts the directory
	// to the Docker volume for the training container. In Pipe input mode, Amazon
	// SageMaker streams data directly from Amazon S3 to the container.
	//
	// If you specify File mode, make sure that you provision the storage volume
	// that is attached to the training instance with enough capacity to accommodate
	// the training data downloaded from Amazon S3, the model artifacts, and intermediate
	// information.
	//
	// For more information about input modes, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	//
	// TrainingInputMode is a required field
	TrainingInputMode TrainingInputMode `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HyperParameterAlgorithmSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterAlgorithmSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterAlgorithmSpecification"}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlgorithmName", 1))
	}
	if len(s.TrainingInputMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TrainingInputMode"))
	}
	if s.MetricDefinitions != nil {
		for i, v := range s.MetricDefinitions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDefinitions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a hyperparameter to be used by an algorithm.
type HyperParameterSpecification struct {
	_ struct{} `type:"structure"`

	// The default value for this hyperparameter. If a default value is specified,
	// a hyperparameter cannot be required.
	DefaultValue *string `type:"string"`

	// A brief description of the hyperparameter.
	Description *string `type:"string"`

	// Indicates whether this hyperparameter is required.
	IsRequired *bool `type:"boolean"`

	// Indicates whether this hyperparameter is tunable in a hyperparameter tuning
	// job.
	IsTunable *bool `type:"boolean"`

	// The name of this hyperparameter. The name must be unique.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The allowed range for this hyperparameter.
	Range *ParameterRange `type:"structure"`

	// The type of this hyperparameter. The valid types are Integer, Continuous,
	// Categorical, and FreeText.
	//
	// Type is a required field
	Type ParameterType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HyperParameterSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterSpecification"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the training jobs launched by a hyperparameter tuning job.
type HyperParameterTrainingJobDefinition struct {
	_ struct{} `type:"structure"`

	// The HyperParameterAlgorithmSpecification object that specifies the resource
	// algorithm to use for the training jobs that the tuning job launches.
	//
	// AlgorithmSpecification is a required field
	AlgorithmSpecification *HyperParameterAlgorithmSpecification `type:"structure" required:"true"`

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig `type:"structure"`

	// The job definition name.
	DefinitionName *string `min:"1" type:"string"`

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use
	// a deep learning algorithm in distributed training.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// A Boolean indicating whether managed spot training is enabled (True) or not
	// (False).
	EnableManagedSpotTraining *bool `type:"boolean"`

	// Isolates the training container. No inbound or outbound network calls can
	// be made, except for calls between peers within a training cluster for distributed
	// training. If network isolation is used for training jobs that are configured
	// to use a VPC, Amazon SageMaker downloads and uploads customer data and model
	// artifacts through the specified VPC, but the training container does not
	// have network access.
	EnableNetworkIsolation *bool `type:"boolean"`

	// Specifies ranges of integer, continuous, and categorical hyperparameters
	// that a hyperparameter tuning job searches. The hyperparameter tuning job
	// launches training jobs with hyperparameter values within these ranges to
	// find the combination of values that result in the training job with the best
	// performance as measured by the objective metric of the hyperparameter tuning
	// job.
	//
	// You can specify a maximum of 20 hyperparameters that a hyperparameter tuning
	// job can search over. Every possible value of a categorical parameter range
	// counts against this limit.
	HyperParameterRanges *ParameterRanges `type:"structure"`

	// An array of Channel objects that specify the input for the training jobs
	// that the tuning job launches.
	InputDataConfig []Channel `min:"1" type:"list"`

	// Specifies the path to the Amazon S3 bucket where you store model artifacts
	// from the training jobs that the tuning job launches.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The resources, including the compute instances and storage volumes, to use
	// for the training jobs that the tuning job launches.
	//
	// Storage volumes store model artifacts and incremental states. Training algorithms
	// might also use storage volumes for scratch space. If you want Amazon SageMaker
	// to use the storage volume to store the training data, choose File as the
	// TrainingInputMode in the algorithm specification. For distributed training
	// algorithms, specify an instance count greater than 1.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the training
	// jobs that the tuning job launches.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the values of hyperparameters that do not change for the tuning
	// job.
	StaticHyperParameters map[string]string `type:"map"`

	// Specifies a limit to how long a model hyperparameter training job can run.
	// It also specifies how long you are willing to wait for a managed spot training
	// job to complete. When the job reaches the a limit, Amazon SageMaker ends
	// the training job. Use this API to cap model training costs.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// Defines the objective metric for a hyperparameter tuning job. Hyperparameter
	// tuning uses the value of this metric to evaluate the training jobs it launches,
	// and returns the training job that results in either the highest or lowest
	// value for this metric, depending on the value you specify for the Type parameter.
	TuningObjective *HyperParameterTuningJobObjective `type:"structure"`

	// The VpcConfig object that specifies the VPC that you want the training jobs
	// that this hyperparameter tuning job launches to connect to. Control access
	// to and from your training container by configuring the VPC. For more information,
	// see Protect Training Jobs by Using an Amazon Virtual Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s HyperParameterTrainingJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTrainingJobDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterTrainingJobDefinition"}

	if s.AlgorithmSpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlgorithmSpecification"))
	}
	if s.DefinitionName != nil && len(*s.DefinitionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DefinitionName", 1))
	}
	if s.InputDataConfig != nil && len(s.InputDataConfig) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputDataConfig", 1))
	}

	if s.OutputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputDataConfig"))
	}

	if s.ResourceConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceConfig"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if s.StoppingCondition == nil {
		invalidParams.Add(aws.NewErrParamRequired("StoppingCondition"))
	}
	if s.AlgorithmSpecification != nil {
		if err := s.AlgorithmSpecification.Validate(); err != nil {
			invalidParams.AddNested("AlgorithmSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.CheckpointConfig != nil {
		if err := s.CheckpointConfig.Validate(); err != nil {
			invalidParams.AddNested("CheckpointConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.HyperParameterRanges != nil {
		if err := s.HyperParameterRanges.Validate(); err != nil {
			invalidParams.AddNested("HyperParameterRanges", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputDataConfig != nil {
		for i, v := range s.InputDataConfig {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputDataConfig", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(aws.ErrInvalidParams))
		}
	}
	if s.TuningObjective != nil {
		if err := s.TuningObjective.Validate(); err != nil {
			invalidParams.AddNested("TuningObjective", err.(aws.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies summary information about a training job.
type HyperParameterTrainingJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the training job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The reason that the training job failed.
	FailureReason *string `type:"string"`

	// The FinalHyperParameterTuningJobObjectiveMetric object that specifies the
	// value of the objective metric of the tuning job that launched this training
	// job.
	FinalHyperParameterTuningJobObjectiveMetric *FinalHyperParameterTuningJobObjectiveMetric `type:"structure"`

	// The status of the objective metric for the training job:
	//
	//    * Succeeded: The final objective metric for the training job was evaluated
	//    by the hyperparameter tuning job and used in the hyperparameter tuning
	//    process.
	//
	//    * Pending: The training job is in progress and evaluation of its final
	//    objective metric is pending.
	//
	//    * Failed: The final objective metric for the training job was not evaluated,
	//    and was not used in the hyperparameter tuning process. This typically
	//    occurs when the training job failed or did not emit an objective metric.
	ObjectiveStatus ObjectiveStatus `type:"string" enum:"true"`

	// Specifies the time when the training job ends on training instances. You
	// are billed for the time interval between the value of TrainingStartTime and
	// this time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker
	// detects a job failure.
	TrainingEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`

	// The training job definition name.
	TrainingJobDefinitionName *string `min:"1" type:"string"`

	// The name of the training job.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// The status of the training job.
	//
	// TrainingJobStatus is a required field
	TrainingJobStatus TrainingJobStatus `type:"string" required:"true" enum:"true"`

	// The date and time that the training job started.
	TrainingStartTime *time.Time `type:"timestamp"`

	// A list of the hyperparameters for which you specified ranges to search.
	//
	// TunedHyperParameters is a required field
	TunedHyperParameters map[string]string `type:"map" required:"true"`

	// The HyperParameter tuning job that launched the training job.
	TuningJobName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s HyperParameterTrainingJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Configures a hyperparameter tuning job.
type HyperParameterTuningJobConfig struct {
	_ struct{} `type:"structure"`

	// The HyperParameterTuningJobObjective object that specifies the objective
	// metric for this tuning job.
	HyperParameterTuningJobObjective *HyperParameterTuningJobObjective `type:"structure"`

	// The ParameterRanges object that specifies the ranges of hyperparameters that
	// this tuning job searches.
	ParameterRanges *ParameterRanges `type:"structure"`

	// The ResourceLimits object that specifies the maximum number of training jobs
	// and parallel training jobs for this tuning job.
	//
	// ResourceLimits is a required field
	ResourceLimits *ResourceLimits `type:"structure" required:"true"`

	// Specifies how hyperparameter tuning chooses the combinations of hyperparameter
	// values to use for the training job it launches. To use the Bayesian search
	// strategy, set this to Bayesian. To randomly search, set it to Random. For
	// information about search strategies, see How Hyperparameter Tuning Works
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
	//
	// Strategy is a required field
	Strategy HyperParameterTuningJobStrategyType `type:"string" required:"true" enum:"true"`

	// Specifies whether to use early stopping for training jobs launched by the
	// hyperparameter tuning job. This can be one of the following values (the default
	// value is OFF):
	//
	// OFF
	//
	// Training jobs launched by the hyperparameter tuning job do not use early
	// stopping.
	//
	// AUTO
	//
	// Amazon SageMaker stops training jobs launched by the hyperparameter tuning
	// job when they are unlikely to perform better than previously completed training
	// jobs. For more information, see Stop Training Jobs Early (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html).
	TrainingJobEarlyStoppingType TrainingJobEarlyStoppingType `type:"string" enum:"true"`

	// The tuning job's completion criteria.
	TuningJobCompletionCriteria *TuningJobCompletionCriteria `type:"structure"`
}

// String returns the string representation
func (s HyperParameterTuningJobConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTuningJobConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterTuningJobConfig"}

	if s.ResourceLimits == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceLimits"))
	}
	if len(s.Strategy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Strategy"))
	}
	if s.HyperParameterTuningJobObjective != nil {
		if err := s.HyperParameterTuningJobObjective.Validate(); err != nil {
			invalidParams.AddNested("HyperParameterTuningJobObjective", err.(aws.ErrInvalidParams))
		}
	}
	if s.ParameterRanges != nil {
		if err := s.ParameterRanges.Validate(); err != nil {
			invalidParams.AddNested("ParameterRanges", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResourceLimits != nil {
		if err := s.ResourceLimits.Validate(); err != nil {
			invalidParams.AddNested("ResourceLimits", err.(aws.ErrInvalidParams))
		}
	}
	if s.TuningJobCompletionCriteria != nil {
		if err := s.TuningJobCompletionCriteria.Validate(); err != nil {
			invalidParams.AddNested("TuningJobCompletionCriteria", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the objective metric for a hyperparameter tuning job. Hyperparameter
// tuning uses the value of this metric to evaluate the training jobs it launches,
// and returns the training job that results in either the highest or lowest
// value for this metric, depending on the value you specify for the Type parameter.
type HyperParameterTuningJobObjective struct {
	_ struct{} `type:"structure"`

	// The name of the metric to use for the objective metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// Whether to minimize or maximize the objective metric.
	//
	// Type is a required field
	Type HyperParameterTuningJobObjectiveType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HyperParameterTuningJobObjective) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTuningJobObjective) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterTuningJobObjective"}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MetricName", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information about a hyperparameter tuning job.
type HyperParameterTuningJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the tuning job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The date and time that the tuning job ended.
	HyperParameterTuningEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the tuning job.
	//
	// HyperParameterTuningJobArn is a required field
	HyperParameterTuningJobArn *string `type:"string" required:"true"`

	// The name of the tuning job.
	//
	// HyperParameterTuningJobName is a required field
	HyperParameterTuningJobName *string `min:"1" type:"string" required:"true"`

	// The status of the tuning job.
	//
	// HyperParameterTuningJobStatus is a required field
	HyperParameterTuningJobStatus HyperParameterTuningJobStatus `type:"string" required:"true" enum:"true"`

	// The date and time that the tuning job was modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The ObjectiveStatusCounters object that specifies the numbers of training
	// jobs, categorized by objective metric status, that this tuning job launched.
	//
	// ObjectiveStatusCounters is a required field
	ObjectiveStatusCounters *ObjectiveStatusCounters `type:"structure" required:"true"`

	// The ResourceLimits object that specifies the maximum number of training jobs
	// and parallel training jobs allowed for this tuning job.
	ResourceLimits *ResourceLimits `type:"structure"`

	// Specifies the search strategy hyperparameter tuning uses to choose which
	// hyperparameters to use for each iteration. Currently, the only valid value
	// is Bayesian.
	//
	// Strategy is a required field
	Strategy HyperParameterTuningJobStrategyType `type:"string" required:"true" enum:"true"`

	// The TrainingJobStatusCounters object that specifies the numbers of training
	// jobs, categorized by status, that this tuning job launched.
	//
	// TrainingJobStatusCounters is a required field
	TrainingJobStatusCounters *TrainingJobStatusCounters `type:"structure" required:"true"`
}

// String returns the string representation
func (s HyperParameterTuningJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Specifies the configuration for a hyperparameter tuning job that uses one
// or more previous hyperparameter tuning jobs as a starting point. The results
// of previous tuning jobs are used to inform which combinations of hyperparameters
// to search over in the new tuning job.
//
// All training jobs launched by the new hyperparameter tuning job are evaluated
// by using the objective metric, and the training job that performs the best
// is compared to the best training jobs from the parent tuning jobs. From these,
// the training job that performs the best as measured by the objective metric
// is returned as the overall best training job.
//
// All training jobs launched by parent hyperparameter tuning jobs and the new
// hyperparameter tuning jobs count against the limit of training jobs for the
// tuning job.
type HyperParameterTuningJobWarmStartConfig struct {
	_ struct{} `type:"structure"`

	// An array of hyperparameter tuning jobs that are used as the starting point
	// for the new hyperparameter tuning job. For more information about warm starting
	// a hyperparameter tuning job, see Using a Previous Hyperparameter Tuning Job
	// as a Starting Point (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-warm-start.html).
	//
	// Hyperparameter tuning jobs created before October 1, 2018 cannot be used
	// as parent jobs for warm start tuning jobs.
	//
	// ParentHyperParameterTuningJobs is a required field
	ParentHyperParameterTuningJobs []ParentHyperParameterTuningJob `min:"1" type:"list" required:"true"`

	// Specifies one of the following:
	//
	// IDENTICAL_DATA_AND_ALGORITHM
	//
	// The new hyperparameter tuning job uses the same input data and training image
	// as the parent tuning jobs. You can change the hyperparameter ranges to search
	// and the maximum number of training jobs that the hyperparameter tuning job
	// launches. You cannot use a new version of the training algorithm, unless
	// the changes in the new version do not affect the algorithm itself. For example,
	// changes that improve logging or adding support for a different data format
	// are allowed. You can also change hyperparameters from tunable to static,
	// and from static to tunable, but the total number of static plus tunable hyperparameters
	// must remain the same as it is in all parent jobs. The objective metric for
	// the new tuning job must be the same as for all parent jobs.
	//
	// TRANSFER_LEARNING
	//
	// The new hyperparameter tuning job can include input data, hyperparameter
	// ranges, maximum number of concurrent training jobs, and maximum number of
	// training jobs that are different than those of its parent hyperparameter
	// tuning jobs. The training image can also be a different version from the
	// version used in the parent hyperparameter tuning job. You can also change
	// hyperparameters from tunable to static, and from static to tunable, but the
	// total number of static plus tunable hyperparameters must remain the same
	// as it is in all parent jobs. The objective metric for the new tuning job
	// must be the same as for all parent jobs.
	//
	// WarmStartType is a required field
	WarmStartType HyperParameterTuningJobWarmStartType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HyperParameterTuningJobWarmStartConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTuningJobWarmStartConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterTuningJobWarmStartConfig"}

	if s.ParentHyperParameterTuningJobs == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParentHyperParameterTuningJobs"))
	}
	if s.ParentHyperParameterTuningJobs != nil && len(s.ParentHyperParameterTuningJobs) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParentHyperParameterTuningJobs", 1))
	}
	if len(s.WarmStartType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("WarmStartType"))
	}
	if s.ParentHyperParameterTuningJobs != nil {
		for i, v := range s.ParentHyperParameterTuningJobs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParentHyperParameterTuningJobs", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines how to perform inference generation after a training job is run.
type InferenceSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon ECR registry path of the Docker image that contains the inference
	// code.
	//
	// Containers is a required field
	Containers []ModelPackageContainerDefinition `min:"1" type:"list" required:"true"`

	// The supported MIME types for the input data.
	//
	// SupportedContentTypes is a required field
	SupportedContentTypes []string `type:"list" required:"true"`

	// A list of the instance types that are used to generate inferences in real-time.
	//
	// SupportedRealtimeInferenceInstanceTypes is a required field
	SupportedRealtimeInferenceInstanceTypes []ProductionVariantInstanceType `type:"list" required:"true"`

	// The supported MIME types for the output data.
	//
	// SupportedResponseMIMETypes is a required field
	SupportedResponseMIMETypes []string `type:"list" required:"true"`

	// A list of the instance types on which a transformation job can be run or
	// on which an endpoint can be deployed.
	//
	// SupportedTransformInstanceTypes is a required field
	SupportedTransformInstanceTypes []TransformInstanceType `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InferenceSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferenceSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InferenceSpecification"}

	if s.Containers == nil {
		invalidParams.Add(aws.NewErrParamRequired("Containers"))
	}
	if s.Containers != nil && len(s.Containers) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Containers", 1))
	}

	if s.SupportedContentTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedContentTypes"))
	}

	if s.SupportedRealtimeInferenceInstanceTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedRealtimeInferenceInstanceTypes"))
	}

	if s.SupportedResponseMIMETypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedResponseMIMETypes"))
	}

	if s.SupportedTransformInstanceTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedTransformInstanceTypes"))
	}
	if s.SupportedTransformInstanceTypes != nil && len(s.SupportedTransformInstanceTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SupportedTransformInstanceTypes", 1))
	}
	if s.Containers != nil {
		for i, v := range s.Containers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Containers", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about the location of input model artifacts, the name
// and shape of the expected data inputs, and the framework in which the model
// was trained.
type InputConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the name and shape of the expected data inputs for your trained
	// model with a JSON dictionary form. The data inputs are InputConfig$Framework
	// specific.
	//
	//    * TensorFlow: You must specify the name and shape (NHWC format) of the
	//    expected data inputs using a dictionary format for your trained model.
	//    The dictionary formats required for the console and CLI are different.
	//    Examples for one input: If using the console, {"input":[1,1024,1024,3]}
	//    If using the CLI, {\"input\":[1,1024,1024,3]} Examples for two inputs:
	//    If using the console, {"data1": [1,28,28,1], "data2":[1,28,28,1]} If using
	//    the CLI, {\"data1\": [1,28,28,1], \"data2\":[1,28,28,1]}
	//
	//    * KERAS: You must specify the name and shape (NCHW format) of expected
	//    data inputs using a dictionary format for your trained model. Note that
	//    while Keras model artifacts should be uploaded in NHWC (channel-last)
	//    format, DataInputConfig should be specified in NCHW (channel-first) format.
	//    The dictionary formats required for the console and CLI are different.
	//    Examples for one input: If using the console, {"input_1":[1,3,224,224]}
	//    If using the CLI, {\"input_1\":[1,3,224,224]} Examples for two inputs:
	//    If using the console, {"input_1": [1,3,224,224], "input_2":[1,3,224,224]}
	//    If using the CLI, {\"input_1\": [1,3,224,224], \"input_2\":[1,3,224,224]}
	//
	//    * MXNET/ONNX: You must specify the name and shape (NCHW format) of the
	//    expected data inputs in order using a dictionary format for your trained
	//    model. The dictionary formats required for the console and CLI are different.
	//    Examples for one input: If using the console, {"data":[1,3,1024,1024]}
	//    If using the CLI, {\"data\":[1,3,1024,1024]} Examples for two inputs:
	//    If using the console, {"var1": [1,1,28,28], "var2":[1,1,28,28]} If using
	//    the CLI, {\"var1\": [1,1,28,28], \"var2\":[1,1,28,28]}
	//
	//    * PyTorch: You can either specify the name and shape (NCHW format) of
	//    expected data inputs in order using a dictionary format for your trained
	//    model or you can specify the shape only using a list format. The dictionary
	//    formats required for the console and CLI are different. The list formats
	//    for the console and CLI are the same. Examples for one input in dictionary
	//    format: If using the console, {"input0":[1,3,224,224]} If using the CLI,
	//    {\"input0\":[1,3,224,224]} Example for one input in list format: [[1,3,224,224]]
	//    Examples for two inputs in dictionary format: If using the console, {"input0":[1,3,224,224],
	//    "input1":[1,3,224,224]} If using the CLI, {\"input0\":[1,3,224,224], \"input1\":[1,3,224,224]}
	//    Example for two inputs in list format: [[1,3,224,224], [1,3,224,224]]
	//
	//    * XGBOOST: input data name and shape are not needed.
	//
	// DataInputConfig is a required field
	DataInputConfig *string `min:"1" type:"string" required:"true"`

	// Identifies the framework in which the model was trained. For example: TENSORFLOW.
	//
	// Framework is a required field
	Framework Framework `type:"string" required:"true" enum:"true"`

	// The S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix).
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputConfig"}

	if s.DataInputConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataInputConfig"))
	}
	if s.DataInputConfig != nil && len(*s.DataInputConfig) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataInputConfig", 1))
	}
	if len(s.Framework) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Framework"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For a hyperparameter of the integer type, specifies the range that a hyperparameter
// tuning job searches.
type IntegerParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum value of the hyperparameter to search.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum value of the hyperparameter to search.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`

	// The name of the hyperparameter to search.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values:
	//
	// Auto
	//
	// Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
	//
	// Linear
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have only values greater than
	// 0.
	ScalingType HyperParameterScalingType `type:"string" enum:"true"`
}

// String returns the string representation
func (s IntegerParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IntegerParameterRange"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the possible values for an integer hyperparameter.
type IntegerParameterRangeSpecification struct {
	_ struct{} `type:"structure"`

	// The maximum integer value allowed.
	//
	// MaxValue is a required field
	MaxValue *string `type:"string" required:"true"`

	// The minimum integer value allowed.
	//
	// MinValue is a required field
	MinValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IntegerParameterRangeSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerParameterRangeSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IntegerParameterRangeSpecification"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Jupyter server's app settings.
type JupyterServerAppSettings struct {
	_ struct{} `type:"structure"`

	// The default instance type and the Amazon Resource Name (ARN) of the SageMaker
	// image created on the instance.
	DefaultResourceSpec *ResourceSpec `type:"structure"`
}

// String returns the string representation
func (s JupyterServerAppSettings) String() string {
	return awsutil.Prettify(s)
}

// The kernel gateway app settings.
type KernelGatewayAppSettings struct {
	_ struct{} `type:"structure"`

	// The default instance type and the Amazon Resource Name (ARN) of the SageMaker
	// image created on the instance.
	DefaultResourceSpec *ResourceSpec `type:"structure"`
}

// String returns the string representation
func (s KernelGatewayAppSettings) String() string {
	return awsutil.Prettify(s)
}

// Provides a breakdown of the number of objects labeled.
type LabelCounters struct {
	_ struct{} `type:"structure"`

	// The total number of objects that could not be labeled due to an error.
	FailedNonRetryableError *int64 `type:"integer"`

	// The total number of objects labeled by a human worker.
	HumanLabeled *int64 `type:"integer"`

	// The total number of objects labeled by automated data labeling.
	MachineLabeled *int64 `type:"integer"`

	// The total number of objects labeled.
	TotalLabeled *int64 `type:"integer"`

	// The total number of objects not yet labeled.
	Unlabeled *int64 `type:"integer"`
}

// String returns the string representation
func (s LabelCounters) String() string {
	return awsutil.Prettify(s)
}

// Provides counts for human-labeled tasks in the labeling job.
type LabelCountersForWorkteam struct {
	_ struct{} `type:"structure"`

	// The total number of data objects labeled by a human worker.
	HumanLabeled *int64 `type:"integer"`

	// The total number of data objects that need to be labeled by a human worker.
	PendingHuman *int64 `type:"integer"`

	// The total number of tasks in the labeling job.
	Total *int64 `type:"integer"`
}

// String returns the string representation
func (s LabelCountersForWorkteam) String() string {
	return awsutil.Prettify(s)
}

// Provides configuration information for auto-labeling of your data objects.
// A LabelingJobAlgorithmsConfig object must be supplied in order to use auto-labeling.
type LabelingJobAlgorithmsConfig struct {
	_ struct{} `type:"structure"`

	// At the end of an auto-label job Amazon SageMaker Ground Truth sends the Amazon
	// Resource Nam (ARN) of the final model used for auto-labeling. You can use
	// this model as the starting point for subsequent similar jobs by providing
	// the ARN of the model here.
	InitialActiveLearningModelArn *string `min:"20" type:"string"`

	// Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling.
	// You must select one of the following ARNs:
	//
	//    * Image classification arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/image-classification
	//
	//    * Text classification arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/text-classification
	//
	//    * Object detection arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/object-detection
	//
	//    * Semantic Segmentation arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/semantic-segmentation
	//
	// LabelingJobAlgorithmSpecificationArn is a required field
	LabelingJobAlgorithmSpecificationArn *string `type:"string" required:"true"`

	// Provides configuration information for a labeling job.
	LabelingJobResourceConfig *LabelingJobResourceConfig `type:"structure"`
}

// String returns the string representation
func (s LabelingJobAlgorithmsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobAlgorithmsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobAlgorithmsConfig"}
	if s.InitialActiveLearningModelArn != nil && len(*s.InitialActiveLearningModelArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("InitialActiveLearningModelArn", 20))
	}

	if s.LabelingJobAlgorithmSpecificationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LabelingJobAlgorithmSpecificationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Attributes of the data specified by the customer. Use these to describe the
// data to be labeled.
type LabelingJobDataAttributes struct {
	_ struct{} `type:"structure"`

	// Declares that your content is free of personally identifiable information
	// or adult content. Amazon SageMaker may restrict the Amazon Mechanical Turk
	// workers that can view your task based on this information.
	ContentClassifiers []ContentClassifier `type:"list"`
}

// String returns the string representation
func (s LabelingJobDataAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides information about the location of input data.
type LabelingJobDataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the input data objects.
	//
	// S3DataSource is a required field
	S3DataSource *LabelingJobS3DataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s LabelingJobDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobDataSource"}

	if s.S3DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information for a work team.
type LabelingJobForWorkteamSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the labeling job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// A unique identifier for a labeling job. You can use this to refer to a specific
	// labeling job.
	//
	// JobReferenceCode is a required field
	JobReferenceCode *string `min:"1" type:"string" required:"true"`

	// Provides information about the progress of a labeling job.
	LabelCounters *LabelCountersForWorkteam `type:"structure"`

	// The name of the labeling job that the work team is assigned to.
	LabelingJobName *string `min:"1" type:"string"`

	// The configured number of workers per data object.
	NumberOfHumanWorkersPerDataObject *int64 `min:"1" type:"integer"`

	// WorkRequesterAccountId is a required field
	WorkRequesterAccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobForWorkteamSummary) String() string {
	return awsutil.Prettify(s)
}

// Input configuration information for a labeling job.
type LabelingJobInputConfig struct {
	_ struct{} `type:"structure"`

	// Attributes of the data specified by the customer.
	DataAttributes *LabelingJobDataAttributes `type:"structure"`

	// The location of the input data.
	//
	// DataSource is a required field
	DataSource *LabelingJobDataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s LabelingJobInputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobInputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobInputConfig"}

	if s.DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSource"))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the location of the output produced by the labeling job.
type LabelingJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the most recent Amazon SageMaker model
	// trained as part of automated data labeling.
	FinalActiveLearningModelArn *string `min:"20" type:"string"`

	// The Amazon S3 bucket location of the manifest file for labeled data.
	//
	// OutputDatasetS3Uri is a required field
	OutputDatasetS3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// Output configuration information for a labeling job.
type LabelingJobOutputConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service ID of the key used to encrypt the output data,
	// if any.
	//
	// If you use a KMS key ID or an alias of your master key, the Amazon SageMaker
	// execution role must include permissions to call kms:Encrypt. If you don't
	// provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon
	// S3 for your role's account. Amazon SageMaker uses server-side encryption
	// with KMS-managed keys for LabelingJobOutputConfig. If you use a bucket policy
	// with an s3:PutObject permission that only allows objects with server-side
	// encryption, set the condition key of s3:x-amz-server-side-encryption to "aws:kms".
	// For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// The KMS key policy must grant permission to the IAM role that you specify
	// in your CreateLabelingJob request. For more information, see Using Key Policies
	// in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	// in the AWS Key Management Service Developer Guide.
	KmsKeyId *string `type:"string"`

	// The Amazon S3 location to write output data.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobOutputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobOutputConfig"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information for labeling jobs.
type LabelingJobResourceConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt data on the storage volume attached to the ML compute instance(s)
	// that run the training job. The VolumeKmsKeyId can be any of the following
	// formats:
	//
	//    * // KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`
}

// String returns the string representation
func (s LabelingJobResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// The Amazon S3 location of the input data objects.
type LabelingJobS3DataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the manifest file that describes the input data
	// objects.
	//
	// ManifestS3Uri is a required field
	ManifestS3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobS3DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobS3DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobS3DataSource"}

	if s.ManifestS3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("ManifestS3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A set of conditions for stopping a labeling job. If any of the conditions
// are met, the job is automatically stopped. You can use these conditions to
// control the cost of data labeling.
//
// Labeling jobs fail after 30 days with an appropriate client error message.
type LabelingJobStoppingConditions struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that can be labeled by human workers.
	MaxHumanLabeledObjectCount *int64 `min:"1" type:"integer"`

	// The maximum number of input data objects that should be labeled.
	MaxPercentageOfInputDatasetLabeled *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s LabelingJobStoppingConditions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelingJobStoppingConditions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LabelingJobStoppingConditions"}
	if s.MaxHumanLabeledObjectCount != nil && *s.MaxHumanLabeledObjectCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxHumanLabeledObjectCount", 1))
	}
	if s.MaxPercentageOfInputDatasetLabeled != nil && *s.MaxPercentageOfInputDatasetLabeled < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxPercentageOfInputDatasetLabeled", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information about a labeling job.
type LabelingJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function used to consolidate
	// the annotations from individual workers into a label for a data object. For
	// more information, see Annotation Consolidation (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html).
	AnnotationConsolidationLambdaArn *string `type:"string"`

	// The date and time that the job was created (timestamp).
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// If the LabelingJobStatus field is Failed, this field contains a description
	// of the error.
	FailureReason *string `type:"string"`

	// Input configuration for the labeling job.
	InputConfig *LabelingJobInputConfig `type:"structure"`

	// Counts showing the progress of the labeling job.
	//
	// LabelCounters is a required field
	LabelCounters *LabelCounters `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
	//
	// LabelingJobArn is a required field
	LabelingJobArn *string `type:"string" required:"true"`

	// The name of the labeling job.
	//
	// LabelingJobName is a required field
	LabelingJobName *string `min:"1" type:"string" required:"true"`

	// The location of the output produced by the labeling job.
	LabelingJobOutput *LabelingJobOutput `type:"structure"`

	// The current status of the labeling job.
	//
	// LabelingJobStatus is a required field
	LabelingJobStatus LabelingJobStatus `type:"string" required:"true" enum:"true"`

	// The date and time that the job was last modified (timestamp).
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of a Lambda function. The function is run
	// before each data object is sent to a worker.
	//
	// PreHumanTaskLambdaArn is a required field
	PreHumanTaskLambdaArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the work team assigned to the job.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LabelingJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Defines the Amazon Cognito user group that is part of a work team.
type MemberDefinition struct {
	_ struct{} `type:"structure"`

	// The Amazon Cognito user group that is part of the work team.
	CognitoMemberDefinition *CognitoMemberDefinition `type:"structure"`
}

// String returns the string representation
func (s MemberDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MemberDefinition"}
	if s.CognitoMemberDefinition != nil {
		if err := s.CognitoMemberDefinition.Validate(); err != nil {
			invalidParams.AddNested("CognitoMemberDefinition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The name, value, and date and time of a metric that was emitted to Amazon
// CloudWatch.
type MetricData struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	MetricName *string `min:"1" type:"string"`

	// The date and time that the algorithm emitted the metric.
	Timestamp *time.Time `type:"timestamp"`

	// The value of the metric.
	Value *float64 `type:"float"`
}

// String returns the string representation
func (s MetricData) String() string {
	return awsutil.Prettify(s)
}

// Specifies a metric that the training algorithm writes to stderr or stdout
// . Amazon SageMakerhyperparameter tuning captures all defined metrics. You
// specify one metric that a hyperparameter tuning job uses as its objective
// metric to choose the best training job.
type MetricDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A regular expression that searches the output of a training job and gets
	// the value of the metric. For more information about using regular expressions
	// to define metrics, see Defining Objective Metrics (https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html).
	//
	// Regex is a required field
	Regex *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MetricDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricDefinition"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Regex == nil {
		invalidParams.Add(aws.NewErrParamRequired("Regex"))
	}
	if s.Regex != nil && len(*s.Regex) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Regex", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about the location that is configured for storing model
// artifacts.
//
// Model artifacts are the output that results from training a model, and typically
// consist of trained parameters, a model defintion that desribes how to compute
// inferences, and other metadata.
type ModelArtifacts struct {
	_ struct{} `type:"structure"`

	// The path of the S3 object that contains the model artifacts. For example,
	// s3://bucket-name/keynameprefix/model.tar.gz.
	//
	// S3ModelArtifacts is a required field
	S3ModelArtifacts *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModelArtifacts) String() string {
	return awsutil.Prettify(s)
}

// Configures the timeout and maximum number of retries for processing a transform
// job invocation.
type ModelClientConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of retries when invocation requests are failing.
	InvocationsMaxRetries *int64 `type:"integer"`

	// The timeout value in seconds for an invocation request.
	InvocationsTimeoutInSeconds *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ModelClientConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelClientConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelClientConfig"}
	if s.InvocationsTimeoutInSeconds != nil && *s.InvocationsTimeoutInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("InvocationsTimeoutInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the Docker container for the model package.
type ModelPackageContainerDefinition struct {
	_ struct{} `type:"structure"`

	// The DNS host name for the Docker container.
	ContainerHostname *string `type:"string"`

	// The Amazon EC2 Container Registry (Amazon ECR) path where inference code
	// is stored.
	//
	// If you are using your own custom algorithm instead of an algorithm provided
	// by Amazon SageMaker, the inference code must meet Amazon SageMaker requirements.
	// Amazon SageMaker supports both registry/repository[:tag] and registry/repository[@digest]
	// image path formats. For more information, see Using Your Own Algorithms with
	// Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	//
	// Image is a required field
	Image *string `type:"string" required:"true"`

	// An MD5 hash of the training algorithm that identifies the Docker image used
	// for training.
	ImageDigest *string `type:"string"`

	// The Amazon S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix).
	ModelDataUrl *string `type:"string"`

	// The AWS Marketplace product ID of the model package.
	ProductId *string `type:"string"`
}

// String returns the string representation
func (s ModelPackageContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelPackageContainerDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelPackageContainerDefinition"}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the validation and image scan statuses of the model package.
type ModelPackageStatusDetails struct {
	_ struct{} `type:"structure"`

	// The status of the scan of the Docker image container for the model package.
	ImageScanStatuses []ModelPackageStatusItem `type:"list"`

	// The validation status of the model package.
	//
	// ValidationStatuses is a required field
	ValidationStatuses []ModelPackageStatusItem `type:"list" required:"true"`
}

// String returns the string representation
func (s ModelPackageStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// Represents the overall status of a model package.
type ModelPackageStatusItem struct {
	_ struct{} `type:"structure"`

	// if the overall status is Failed, the reason for the failure.
	FailureReason *string `type:"string"`

	// The name of the model package for which the overall status is being reported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The current status.
	//
	// Status is a required field
	Status DetailedModelPackageStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ModelPackageStatusItem) String() string {
	return awsutil.Prettify(s)
}

// Provides summary information about a model package.
type ModelPackageSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the model package was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the model package.
	//
	// ModelPackageArn is a required field
	ModelPackageArn *string `min:"1" type:"string" required:"true"`

	// A brief description of the model package.
	ModelPackageDescription *string `type:"string"`

	// The name of the model package.
	//
	// ModelPackageName is a required field
	ModelPackageName *string `min:"1" type:"string" required:"true"`

	// The overall status of the model package.
	//
	// ModelPackageStatus is a required field
	ModelPackageStatus ModelPackageStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ModelPackageSummary) String() string {
	return awsutil.Prettify(s)
}

// Contains data, such as the inputs and targeted instance types that are used
// in the process of validating the model package.
//
// The data provided in the validation profile is made available to your buyers
// on AWS Marketplace.
type ModelPackageValidationProfile struct {
	_ struct{} `type:"structure"`

	// The name of the profile for the model package.
	//
	// ProfileName is a required field
	ProfileName *string `min:"1" type:"string" required:"true"`

	// The TransformJobDefinition object that describes the transform job used for
	// the validation of the model package.
	//
	// TransformJobDefinition is a required field
	TransformJobDefinition *TransformJobDefinition `type:"structure" required:"true"`
}

// String returns the string representation
func (s ModelPackageValidationProfile) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelPackageValidationProfile) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelPackageValidationProfile"}

	if s.ProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfileName", 1))
	}

	if s.TransformJobDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformJobDefinition"))
	}
	if s.TransformJobDefinition != nil {
		if err := s.TransformJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TransformJobDefinition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies batch transform jobs that Amazon SageMaker runs to validate your
// model package.
type ModelPackageValidationSpecification struct {
	_ struct{} `type:"structure"`

	// An array of ModelPackageValidationProfile objects, each of which specifies
	// a batch transform job that Amazon SageMaker runs to validate your model package.
	//
	// ValidationProfiles is a required field
	ValidationProfiles []ModelPackageValidationProfile `min:"1" type:"list" required:"true"`

	// The IAM roles to be used for the validation of the model package.
	//
	// ValidationRole is a required field
	ValidationRole *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ModelPackageValidationSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelPackageValidationSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModelPackageValidationSpecification"}

	if s.ValidationProfiles == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValidationProfiles"))
	}
	if s.ValidationProfiles != nil && len(s.ValidationProfiles) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ValidationProfiles", 1))
	}

	if s.ValidationRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("ValidationRole"))
	}
	if s.ValidationRole != nil && len(*s.ValidationRole) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ValidationRole", 20))
	}
	if s.ValidationProfiles != nil {
		for i, v := range s.ValidationProfiles {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationProfiles", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information about a model.
type ModelSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that indicates when the model was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the model.
	//
	// ModelArn is a required field
	ModelArn *string `min:"20" type:"string" required:"true"`

	// The name of the model that you want a summary for.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModelSummary) String() string {
	return awsutil.Prettify(s)
}

// Container image configuration object for the monitoring job.
type MonitoringAppSpecification struct {
	_ struct{} `type:"structure"`

	// An array of arguments for the container used to run the monitoring job.
	ContainerArguments []string `min:"1" type:"list"`

	// Specifies the entrypoint for a container used to run the monitoring job.
	ContainerEntrypoint []string `min:"1" type:"list"`

	// The container image to be run by the monitoring job.
	//
	// ImageUri is a required field
	ImageUri *string `type:"string" required:"true"`

	// An Amazon S3 URI to a script that is called after analysis has been performed.
	// Applicable only for the built-in (first party) containers.
	PostAnalyticsProcessorSourceUri *string `type:"string"`

	// An Amazon S3 URI to a script that is called per row prior to running analysis.
	// It can base64 decode the payload and convert it into a flatted json so that
	// the built-in container can use the converted data. Applicable only for the
	// built-in (first party) containers.
	RecordPreprocessorSourceUri *string `type:"string"`
}

// String returns the string representation
func (s MonitoringAppSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringAppSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringAppSpecification"}
	if s.ContainerArguments != nil && len(s.ContainerArguments) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerArguments", 1))
	}
	if s.ContainerEntrypoint != nil && len(s.ContainerEntrypoint) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerEntrypoint", 1))
	}

	if s.ImageUri == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration for monitoring constraints and monitoring statistics. These
// baseline resources are compared against the results of the current job from
// the series of jobs scheduled to collect data periodically.
type MonitoringBaselineConfig struct {
	_ struct{} `type:"structure"`

	// The baseline constraint file in Amazon S3 that the current monitoring job
	// should validated against.
	ConstraintsResource *MonitoringConstraintsResource `type:"structure"`

	// The baseline statistics file in Amazon S3 that the current monitoring job
	// should be validated against.
	StatisticsResource *MonitoringStatisticsResource `type:"structure"`
}

// String returns the string representation
func (s MonitoringBaselineConfig) String() string {
	return awsutil.Prettify(s)
}

// Configuration for the cluster used to run model monitoring jobs.
type MonitoringClusterConfig struct {
	_ struct{} `type:"structure"`

	// The number of ML compute instances to use in the model monitoring job. For
	// distributed processing jobs, specify a value greater than 1. The default
	// value is 1.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// The ML compute instance type for the processing job.
	//
	// InstanceType is a required field
	InstanceType ProcessingInstanceType `type:"string" required:"true" enum:"true"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt data on the storage volume attached to the ML compute instance(s)
	// that run the model monitoring job.
	VolumeKmsKeyId *string `type:"string"`

	// The size of the ML storage volume, in gigabytes, that you want to provision.
	// You must specify sufficient ML storage for your scenario.
	//
	// VolumeSizeInGB is a required field
	VolumeSizeInGB *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s MonitoringClusterConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringClusterConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringClusterConfig"}

	if s.InstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceCount"))
	}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("InstanceCount", 1))
	}
	if len(s.InstanceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}

	if s.VolumeSizeInGB == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeSizeInGB"))
	}
	if s.VolumeSizeInGB != nil && *s.VolumeSizeInGB < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VolumeSizeInGB", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The constraints resource for a monitoring job.
type MonitoringConstraintsResource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 URI for the constraints resource.
	S3Uri *string `type:"string"`
}

// String returns the string representation
func (s MonitoringConstraintsResource) String() string {
	return awsutil.Prettify(s)
}

// Summary of information about the last monitoring job to run.
type MonitoringExecutionSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the monitoring job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The name of teh endpoint used to run the monitoring job.
	EndpointName *string `type:"string"`

	// Contains the reason a monitoring job failed, if it failed.
	FailureReason *string `type:"string"`

	// A timestamp that indicates the last time the monitoring job was modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// The status of the monitoring job.
	//
	// MonitoringExecutionStatus is a required field
	MonitoringExecutionStatus ExecutionStatus `type:"string" required:"true" enum:"true"`

	// The name of the monitoring schedule.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the monitoring job.
	ProcessingJobArn *string `type:"string"`

	// The time the monitoring job was scheduled.
	//
	// ScheduledTime is a required field
	ScheduledTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s MonitoringExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// The inputs for a monitoring job.
type MonitoringInput struct {
	_ struct{} `type:"structure"`

	// The endpoint for a monitoring job.
	//
	// EndpointInput is a required field
	EndpointInput *EndpointInput `type:"structure" required:"true"`
}

// String returns the string representation
func (s MonitoringInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringInput"}

	if s.EndpointInput == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointInput"))
	}
	if s.EndpointInput != nil {
		if err := s.EndpointInput.Validate(); err != nil {
			invalidParams.AddNested("EndpointInput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the monitoring job.
type MonitoringJobDefinition struct {
	_ struct{} `type:"structure"`

	// Baseline configuration used to validate that the data conforms to the specified
	// constraints and statistics
	BaselineConfig *MonitoringBaselineConfig `type:"structure"`

	// Sets the environment variables in the Docker container.
	Environment map[string]string `type:"map"`

	// Configures the monitoring job to run a specified Docker container image.
	//
	// MonitoringAppSpecification is a required field
	MonitoringAppSpecification *MonitoringAppSpecification `type:"structure" required:"true"`

	// The array of inputs for the monitoring job. Currently we support monitoring
	// an Amazon SageMaker Endpoint.
	//
	// MonitoringInputs is a required field
	MonitoringInputs []MonitoringInput `min:"1" type:"list" required:"true"`

	// The array of outputs from the monitoring job to be uploaded to Amazon Simple
	// Storage Service (Amazon S3).
	//
	// MonitoringOutputConfig is a required field
	MonitoringOutputConfig *MonitoringOutputConfig `type:"structure" required:"true"`

	// Identifies the resources, ML compute instances, and ML storage volumes to
	// deploy for a monitoring job. In distributed processing, you specify more
	// than one instance.
	//
	// MonitoringResources is a required field
	MonitoringResources *MonitoringResources `type:"structure" required:"true"`

	// Specifies networking options for an monitoring job.
	NetworkConfig *NetworkConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume
	// to perform tasks on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies a time limit for how long the monitoring job is allowed to run.
	StoppingCondition *MonitoringStoppingCondition `type:"structure"`
}

// String returns the string representation
func (s MonitoringJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringJobDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringJobDefinition"}

	if s.MonitoringAppSpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringAppSpecification"))
	}

	if s.MonitoringInputs == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringInputs"))
	}
	if s.MonitoringInputs != nil && len(s.MonitoringInputs) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MonitoringInputs", 1))
	}

	if s.MonitoringOutputConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringOutputConfig"))
	}

	if s.MonitoringResources == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringResources"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}
	if s.MonitoringAppSpecification != nil {
		if err := s.MonitoringAppSpecification.Validate(); err != nil {
			invalidParams.AddNested("MonitoringAppSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.MonitoringInputs != nil {
		for i, v := range s.MonitoringInputs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MonitoringInputs", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.MonitoringOutputConfig != nil {
		if err := s.MonitoringOutputConfig.Validate(); err != nil {
			invalidParams.AddNested("MonitoringOutputConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.MonitoringResources != nil {
		if err := s.MonitoringResources.Validate(); err != nil {
			invalidParams.AddNested("MonitoringResources", err.(aws.ErrInvalidParams))
		}
	}
	if s.NetworkConfig != nil {
		if err := s.NetworkConfig.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output object for a monitoring job.
type MonitoringOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 storage location where the results of a monitoring job are
	// saved.
	//
	// S3Output is a required field
	S3Output *MonitoringS3Output `type:"structure" required:"true"`
}

// String returns the string representation
func (s MonitoringOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringOutput"}

	if s.S3Output == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Output"))
	}
	if s.S3Output != nil {
		if err := s.S3Output.Validate(); err != nil {
			invalidParams.AddNested("S3Output", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output configuration for monitoring jobs.
type MonitoringOutputConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt the model artifacts at rest using Amazon S3 server-side encryption.
	KmsKeyId *string `type:"string"`

	// Monitoring outputs for monitoring jobs. This is where the output of the periodic
	// monitoring jobs is uploaded.
	//
	// MonitoringOutputs is a required field
	MonitoringOutputs []MonitoringOutput `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s MonitoringOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringOutputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringOutputConfig"}

	if s.MonitoringOutputs == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringOutputs"))
	}
	if s.MonitoringOutputs != nil && len(s.MonitoringOutputs) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MonitoringOutputs", 1))
	}
	if s.MonitoringOutputs != nil {
		for i, v := range s.MonitoringOutputs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MonitoringOutputs", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Identifies the resources to deploy for a monitoring job.
type MonitoringResources struct {
	_ struct{} `type:"structure"`

	// The configuration for the cluster resources used to run the processing job.
	//
	// ClusterConfig is a required field
	ClusterConfig *MonitoringClusterConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s MonitoringResources) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringResources) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringResources"}

	if s.ClusterConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterConfig"))
	}
	if s.ClusterConfig != nil {
		if err := s.ClusterConfig.Validate(); err != nil {
			invalidParams.AddNested("ClusterConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about where and how you want to store the results of a monitoring
// job.
type MonitoringS3Output struct {
	_ struct{} `type:"structure"`

	// The local path to the Amazon S3 storage location where Amazon SageMaker saves
	// the results of a monitoring job. LocalPath is an absolute path for the output
	// data.
	//
	// LocalPath is a required field
	LocalPath *string `type:"string" required:"true"`

	// Whether to upload the results of the monitoring job continuously or after
	// the job completes.
	S3UploadMode ProcessingS3UploadMode `type:"string" enum:"true"`

	// A URI that identifies the Amazon S3 storage location where Amazon SageMaker
	// saves the results of a monitoring job.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MonitoringS3Output) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringS3Output) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringS3Output"}

	if s.LocalPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocalPath"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configures the monitoring schedule and defines the monitoring job.
type MonitoringScheduleConfig struct {
	_ struct{} `type:"structure"`

	// Defines the monitoring job.
	//
	// MonitoringJobDefinition is a required field
	MonitoringJobDefinition *MonitoringJobDefinition `type:"structure" required:"true"`

	// Configures the monitoring schedule.
	ScheduleConfig *ScheduleConfig `type:"structure"`
}

// String returns the string representation
func (s MonitoringScheduleConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringScheduleConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringScheduleConfig"}

	if s.MonitoringJobDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringJobDefinition"))
	}
	if s.MonitoringJobDefinition != nil {
		if err := s.MonitoringJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("MonitoringJobDefinition", err.(aws.ErrInvalidParams))
		}
	}
	if s.ScheduleConfig != nil {
		if err := s.ScheduleConfig.Validate(); err != nil {
			invalidParams.AddNested("ScheduleConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Summarizes the monitoring schedule.
type MonitoringScheduleSummary struct {
	_ struct{} `type:"structure"`

	// The creation time of the monitoring schedule.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The name of the endpoint using the monitoring schedule.
	EndpointName *string `type:"string"`

	// The last time the monitoring schedule was modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	//
	// MonitoringScheduleArn is a required field
	MonitoringScheduleArn *string `type:"string" required:"true"`

	// The name of the monitoring schedule.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`

	// The status of the monitoring schedule.
	//
	// MonitoringScheduleStatus is a required field
	MonitoringScheduleStatus ScheduleStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s MonitoringScheduleSummary) String() string {
	return awsutil.Prettify(s)
}

// The statistics resource for a monitoring job.
type MonitoringStatisticsResource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 URI for the statistics resource.
	S3Uri *string `type:"string"`
}

// String returns the string representation
func (s MonitoringStatisticsResource) String() string {
	return awsutil.Prettify(s)
}

// A time limit for how long the monitoring job is allowed to run before stopping.
type MonitoringStoppingCondition struct {
	_ struct{} `type:"structure"`

	// The maximum runtime allowed in seconds.
	//
	// MaxRuntimeInSeconds is a required field
	MaxRuntimeInSeconds *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s MonitoringStoppingCondition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringStoppingCondition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringStoppingCondition"}

	if s.MaxRuntimeInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxRuntimeInSeconds"))
	}
	if s.MaxRuntimeInSeconds != nil && *s.MaxRuntimeInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRuntimeInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of nested Filter objects. A resource must satisfy the conditions of
// all filters to be included in the results returned from the Search API.
//
// For example, to filter on a training job's InputDataConfig property with
// a specific channel name and S3Uri prefix, define the following filters:
//
//    * '{Name:"InputDataConfig.ChannelName", "Operator":"Equals", "Value":"train"}',
//
//    * '{Name:"InputDataConfig.DataSource.S3DataSource.S3Uri", "Operator":"Contains",
//    "Value":"mybucket/catdata"}'
type NestedFilters struct {
	_ struct{} `type:"structure"`

	// A list of filters. Each filter acts on a property. Filters must contain at
	// least one Filters value. For example, a NestedFilters call might include
	// a filter on the PropertyName parameter of the InputDataConfig property: InputDataConfig.DataSource.S3DataSource.S3Uri.
	//
	// Filters is a required field
	Filters []Filter `min:"1" type:"list" required:"true"`

	// The name of the property to use in the nested filters. The value must match
	// a listed property name, such as InputDataConfig.
	//
	// NestedPropertyName is a required field
	NestedPropertyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s NestedFilters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NestedFilters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NestedFilters"}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}

	if s.NestedPropertyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NestedPropertyName"))
	}
	if s.NestedPropertyName != nil && len(*s.NestedPropertyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NestedPropertyName", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Networking options for a job, such as network traffic encryption between
// containers, whether to allow inbound and outbound network calls to and from
// containers, and the VPC subnets and security groups to use for VPC-enabled
// jobs.
type NetworkConfig struct {
	_ struct{} `type:"structure"`

	// Whether to encrypt all communications between distributed processing jobs.
	// Choose True to encrypt communications. Encryption provides greater security
	// for distributed processing jobs, but the processing might take longer.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// Whether to allow inbound and outbound network calls to and from the containers
	// used for the processing job.
	EnableNetworkIsolation *bool `type:"boolean"`

	// Specifies a VPC that your training jobs and hosted models have access to.
	// Control access to and from your training and model containers by configuring
	// the VPC. For more information, see Protect Endpoints by Using an Amazon Virtual
	// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
	// and Protect Training Jobs by Using an Amazon Virtual Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s NetworkConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NetworkConfig"}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a summary of a notebook instance lifecycle configuration.
type NotebookInstanceLifecycleConfigSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that tells when the lifecycle configuration was created.
	CreationTime *time.Time `type:"timestamp"`

	// A timestamp that tells when the lifecycle configuration was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigArn is a required field
	NotebookInstanceLifecycleConfigArn *string `type:"string" required:"true"`

	// The name of the lifecycle configuration.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NotebookInstanceLifecycleConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// Contains the notebook instance lifecycle configuration script.
//
// Each lifecycle configuration script has a limit of 16384 characters.
//
// The value of the $PATH environment variable that is available to both scripts
// is /sbin:bin:/usr/sbin:/usr/bin.
//
// View CloudWatch Logs for notebook instance lifecycle configurations in log
// group /aws/sagemaker/NotebookInstances in log stream [notebook-instance-name]/[LifecycleConfigHook].
//
// Lifecycle configuration scripts cannot run for longer than 5 minutes. If
// a script runs for longer than 5 minutes, it fails and the notebook instance
// is not created or started.
//
// For information about notebook instance lifestyle configurations, see Step
// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
type NotebookInstanceLifecycleHook struct {
	_ struct{} `type:"structure"`

	// A base64-encoded string that contains a shell script for a notebook instance
	// lifecycle configuration.
	Content *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NotebookInstanceLifecycleHook) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotebookInstanceLifecycleHook) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotebookInstanceLifecycleHook"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Content", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides summary information for an Amazon SageMaker notebook instance.
type NotebookInstanceSummary struct {
	_ struct{} `type:"structure"`

	// An array of up to three Git repositories associated with the notebook instance.
	// These can be either the names of Git repositories stored as resources in
	// your account, or the URL of Git repositories in AWS CodeCommit (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
	// or in any other Git repository. These repositories are cloned at the same
	// level as the default repository of your notebook instance. For more information,
	// see Associating Git Repositories with Amazon SageMaker Notebook Instances
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	AdditionalCodeRepositories []string `type:"list"`

	// A timestamp that shows when the notebook instance was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Git repository associated with the notebook instance as its default code
	// repository. This can be either the name of a Git repository stored as a resource
	// in your account, or the URL of a Git repository in AWS CodeCommit (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
	// or in any other Git repository. When you open a notebook instance, it opens
	// in the directory that contains this repository. For more information, see
	// Associating Git Repositories with Amazon SageMaker Notebook Instances (https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
	DefaultCodeRepository *string `min:"1" type:"string"`

	// The type of ML compute instance that the notebook instance is running on.
	InstanceType InstanceType `type:"string" enum:"true"`

	// A timestamp that shows when the notebook instance was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the notebook instance.
	//
	// NotebookInstanceArn is a required field
	NotebookInstanceArn *string `type:"string" required:"true"`

	// The name of a notebook instance lifecycle configuration associated with this
	// notebook instance.
	//
	// For information about notebook instance lifestyle configurations, see Step
	// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
	NotebookInstanceLifecycleConfigName *string `type:"string"`

	// The name of the notebook instance that you want a summary for.
	//
	// NotebookInstanceName is a required field
	NotebookInstanceName *string `type:"string" required:"true"`

	// The status of the notebook instance.
	NotebookInstanceStatus NotebookInstanceStatus `type:"string" enum:"true"`

	// The URL that you use to connect to the Jupyter instance running in your notebook
	// instance.
	Url *string `type:"string"`
}

// String returns the string representation
func (s NotebookInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// Configures SNS notifications of available or expiring work items for work
// teams.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN for the SNS topic to which notifications should be published.
	NotificationTopicArn *string `type:"string"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Specifies the number of training jobs that this hyperparameter tuning job
// launched, categorized by the status of their objective metric. The objective
// metric status shows whether the final objective metric for the training job
// has been evaluated by the tuning job and used in the hyperparameter tuning
// process.
type ObjectiveStatusCounters struct {
	_ struct{} `type:"structure"`

	// The number of training jobs whose final objective metric was not evaluated
	// and used in the hyperparameter tuning process. This typically occurs when
	// the training job failed or did not emit an objective metric.
	Failed *int64 `type:"integer"`

	// The number of training jobs that are in progress and pending evaluation of
	// their final objective metric.
	Pending *int64 `type:"integer"`

	// The number of training jobs whose final objective metric was evaluated by
	// the hyperparameter tuning job and used in the hyperparameter tuning process.
	Succeeded *int64 `type:"integer"`
}

// String returns the string representation
func (s ObjectiveStatusCounters) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the output location for the compiled model and
// the device (target) that the model runs on.
type OutputConfig struct {
	_ struct{} `type:"structure"`

	// Identifies the S3 path where you want Amazon SageMaker to store the model
	// artifacts. For example, s3://bucket-name/key-name-prefix.
	//
	// S3OutputLocation is a required field
	S3OutputLocation *string `type:"string" required:"true"`

	// Identifies the device that you want to run your model on after it has been
	// compiled. For example: ml_c5.
	//
	// TargetDevice is a required field
	TargetDevice TargetDevice `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s OutputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputConfig"}

	if s.S3OutputLocation == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputLocation"))
	}
	if len(s.TargetDevice) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TargetDevice"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about how to store model training results (model artifacts).
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt the model artifacts at rest using Amazon S3 server-side encryption.
	// The KmsKeyId can be any of the following formats:
	//
	//    * // KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // KMS Key Alias "alias/ExampleAlias"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key Alias "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	//
	// If you use a KMS key ID or an alias of your master key, the Amazon SageMaker
	// execution role must include permissions to call kms:Encrypt. If you don't
	// provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon
	// S3 for your role's account. Amazon SageMaker uses server-side encryption
	// with KMS-managed keys for OutputDataConfig. If you use a bucket policy with
	// an s3:PutObject permission that only allows objects with server-side encryption,
	// set the condition key of s3:x-amz-server-side-encryption to "aws:kms". For
	// more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// The KMS key policy must grant permission to the IAM role that you specify
	// in your CreateTrainingJob, CreateTransformJob, or CreateHyperParameterTuningJob
	// requests. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	// in the AWS Key Management Service Developer Guide.
	KmsKeyId *string `type:"string"`

	// Identifies the S3 path where you want Amazon SageMaker to store the model
	// artifacts. For example, s3://bucket-name/key-name-prefix.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputDataConfig"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the possible values for categorical, continuous, and integer hyperparameters
// to be used by an algorithm.
type ParameterRange struct {
	_ struct{} `type:"structure"`

	// A CategoricalParameterRangeSpecification object that defines the possible
	// values for a categorical hyperparameter.
	CategoricalParameterRangeSpecification *CategoricalParameterRangeSpecification `type:"structure"`

	// A ContinuousParameterRangeSpecification object that defines the possible
	// values for a continuous hyperparameter.
	ContinuousParameterRangeSpecification *ContinuousParameterRangeSpecification `type:"structure"`

	// A IntegerParameterRangeSpecification object that defines the possible values
	// for an integer hyperparameter.
	IntegerParameterRangeSpecification *IntegerParameterRangeSpecification `type:"structure"`
}

// String returns the string representation
func (s ParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParameterRange"}
	if s.CategoricalParameterRangeSpecification != nil {
		if err := s.CategoricalParameterRangeSpecification.Validate(); err != nil {
			invalidParams.AddNested("CategoricalParameterRangeSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.ContinuousParameterRangeSpecification != nil {
		if err := s.ContinuousParameterRangeSpecification.Validate(); err != nil {
			invalidParams.AddNested("ContinuousParameterRangeSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.IntegerParameterRangeSpecification != nil {
		if err := s.IntegerParameterRangeSpecification.Validate(); err != nil {
			invalidParams.AddNested("IntegerParameterRangeSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies ranges of integer, continuous, and categorical hyperparameters
// that a hyperparameter tuning job searches. The hyperparameter tuning job
// launches training jobs with hyperparameter values within these ranges to
// find the combination of values that result in the training job with the best
// performance as measured by the objective metric of the hyperparameter tuning
// job.
//
// You can specify a maximum of 20 hyperparameters that a hyperparameter tuning
// job can search over. Every possible value of a categorical parameter range
// counts against this limit.
type ParameterRanges struct {
	_ struct{} `type:"structure"`

	// The array of CategoricalParameterRange objects that specify ranges of categorical
	// hyperparameters that a hyperparameter tuning job searches.
	CategoricalParameterRanges []CategoricalParameterRange `type:"list"`

	// The array of ContinuousParameterRange objects that specify ranges of continuous
	// hyperparameters that a hyperparameter tuning job searches.
	ContinuousParameterRanges []ContinuousParameterRange `type:"list"`

	// The array of IntegerParameterRange objects that specify ranges of integer
	// hyperparameters that a hyperparameter tuning job searches.
	IntegerParameterRanges []IntegerParameterRange `type:"list"`
}

// String returns the string representation
func (s ParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterRanges) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParameterRanges"}
	if s.CategoricalParameterRanges != nil {
		for i, v := range s.CategoricalParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CategoricalParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ContinuousParameterRanges != nil {
		for i, v := range s.ContinuousParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContinuousParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.IntegerParameterRanges != nil {
		for i, v := range s.IntegerParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IntegerParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The trial that a trial component is associated with and the experiment the
// trial is part of. A component might not be associated with a trial. A component
// can be associated with multiple trials.
type Parent struct {
	_ struct{} `type:"structure"`

	// The name of the experiment.
	ExperimentName *string `min:"1" type:"string"`

	// The name of the trial.
	TrialName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Parent) String() string {
	return awsutil.Prettify(s)
}

// A previously completed or stopped hyperparameter tuning job to be used as
// a starting point for a new hyperparameter tuning job.
type ParentHyperParameterTuningJob struct {
	_ struct{} `type:"structure"`

	// The name of the hyperparameter tuning job to be used as a starting point
	// for a new hyperparameter tuning job.
	HyperParameterTuningJobName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ParentHyperParameterTuningJob) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParentHyperParameterTuningJob) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParentHyperParameterTuningJob"}
	if s.HyperParameterTuningJobName != nil && len(*s.HyperParameterTuningJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HyperParameterTuningJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration for the cluster used to run a processing job.
type ProcessingClusterConfig struct {
	_ struct{} `type:"structure"`

	// The number of ML compute instances to use in the processing job. For distributed
	// processing jobs, specify a value greater than 1. The default value is 1.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// The ML compute instance type for the processing job.
	//
	// InstanceType is a required field
	InstanceType ProcessingInstanceType `type:"string" required:"true" enum:"true"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt data on the storage volume attached to the ML compute instance(s)
	// that run the processing job.
	VolumeKmsKeyId *string `type:"string"`

	// The size of the ML storage volume in gigabytes that you want to provision.
	// You must specify sufficient ML storage for your scenario.
	//
	// VolumeSizeInGB is a required field
	VolumeSizeInGB *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ProcessingClusterConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingClusterConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProcessingClusterConfig"}

	if s.InstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceCount"))
	}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("InstanceCount", 1))
	}
	if len(s.InstanceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}

	if s.VolumeSizeInGB == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeSizeInGB"))
	}
	if s.VolumeSizeInGB != nil && *s.VolumeSizeInGB < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VolumeSizeInGB", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The inputs for a processing job.
type ProcessingInput struct {
	_ struct{} `type:"structure"`

	// The name of the inputs for the processing job.
	//
	// InputName is a required field
	InputName *string `type:"string" required:"true"`

	// The S3 inputs for the processing job.
	//
	// S3Input is a required field
	S3Input *ProcessingS3Input `type:"structure" required:"true"`
}

// String returns the string representation
func (s ProcessingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProcessingInput"}

	if s.InputName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputName"))
	}

	if s.S3Input == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Input"))
	}
	if s.S3Input != nil {
		if err := s.S3Input.Validate(); err != nil {
			invalidParams.AddNested("S3Input", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An Amazon SageMaker processing job that is used to analyze data and evaluate
// models. For more information, see Process Data and Evaluate Models (https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html).
type ProcessingJob struct {
	_ struct{} `type:"structure"`

	// Configuration to run a processing job in a specified container image.
	AppSpecification *AppSpecification `type:"structure"`

	// The Amazon Resource Name (ARN) of the AutoML job associated with this processing
	// job.
	AutoMLJobArn *string `min:"1" type:"string"`

	// The time the processing job was created.
	CreationTime *time.Time `type:"timestamp"`

	// Sets the environment variables in the Docker container.
	Environment map[string]string `type:"map"`

	// A string, up to one KB in size, that contains metadata from the processing
	// container when the processing job exits.
	ExitMessage *string `type:"string"`

	// Configuration for the experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// A string, up to one KB in size, that contains the reason a processing job
	// failed, if it failed.
	FailureReason *string `type:"string"`

	// The time the processing job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The ARN of a monitoring schedule for an endpoint associated with this processing
	// job.
	MonitoringScheduleArn *string `type:"string"`

	// Networking options for a job, such as network traffic encryption between
	// containers, whether to allow inbound and outbound network calls to and from
	// containers, and the VPC subnets and security groups to use for VPC-enabled
	// jobs.
	NetworkConfig *NetworkConfig `type:"structure"`

	// The time that the processing job ended.
	ProcessingEndTime *time.Time `type:"timestamp"`

	// For each input, data is downloaded from S3 into the processing container
	// before the processing job begins running if "S3InputMode" is set to File.
	ProcessingInputs []ProcessingInput `type:"list"`

	// The ARN of the processing job.
	ProcessingJobArn *string `type:"string"`

	// The name of the processing job.
	ProcessingJobName *string `min:"1" type:"string"`

	// The status of the processing job.
	ProcessingJobStatus ProcessingJobStatus `type:"string" enum:"true"`

	// The output configuration for the processing job.
	ProcessingOutputConfig *ProcessingOutputConfig `type:"structure"`

	// Identifies the resources, ML compute instances, and ML storage volumes to
	// deploy for a processing job. In distributed training, you specify more than
	// one instance.
	ProcessingResources *ProcessingResources `type:"structure"`

	// The time that the processing job started.
	ProcessingStartTime *time.Time `type:"timestamp"`

	// The ARN of the role used to create the processing job.
	RoleArn *string `min:"20" type:"string"`

	// Specifies a time limit for how long the processing job is allowed to run.
	StoppingCondition *ProcessingStoppingCondition `type:"structure"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
	// in the AWS Billing and Cost Management User Guide.
	Tags []Tag `type:"list"`

	// The ARN of the training job associated with this processing job.
	TrainingJobArn *string `type:"string"`
}

// String returns the string representation
func (s ProcessingJob) String() string {
	return awsutil.Prettify(s)
}

// Summary of information about a processing job.
type ProcessingJobSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the processing job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// An optional string, up to one KB in size, that contains metadata from the
	// processing container when the processing job exits.
	ExitMessage *string `type:"string"`

	// A string, up to one KB in size, that contains the reason a processing job
	// failed, if it failed.
	FailureReason *string `type:"string"`

	// A timestamp that indicates the last time the processing job was modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The time at which the processing job completed.
	ProcessingEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the processing job..
	//
	// ProcessingJobArn is a required field
	ProcessingJobArn *string `type:"string" required:"true"`

	// The name of the processing job.
	//
	// ProcessingJobName is a required field
	ProcessingJobName *string `min:"1" type:"string" required:"true"`

	// The status of the processing job.
	//
	// ProcessingJobStatus is a required field
	ProcessingJobStatus ProcessingJobStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ProcessingJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes the results of a processing job.
type ProcessingOutput struct {
	_ struct{} `type:"structure"`

	// The name for the processing job output.
	//
	// OutputName is a required field
	OutputName *string `type:"string" required:"true"`

	// Configuration for processing job outputs in Amazon S3.
	//
	// S3Output is a required field
	S3Output *ProcessingS3Output `type:"structure" required:"true"`
}

// String returns the string representation
func (s ProcessingOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProcessingOutput"}

	if s.OutputName == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputName"))
	}

	if s.S3Output == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Output"))
	}
	if s.S3Output != nil {
		if err := s.S3Output.Validate(); err != nil {
			invalidParams.AddNested("S3Output", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output configuration for the processing job.
type ProcessingOutputConfig struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt the processing job output. KmsKeyId can be an ID of a KMS key, ARN
	// of a KMS key, alias of a KMS key, or alias of a KMS key. The KmsKeyId is
	// applied to all outputs.
	KmsKeyId *string `type:"string"`

	// Output configuration information for a processing job.
	//
	// Outputs is a required field
	Outputs []ProcessingOutput `type:"list" required:"true"`
}

// String returns the string representation
func (s ProcessingOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingOutputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProcessingOutputConfig"}

	if s.Outputs == nil {
		invalidParams.Add(aws.NewErrParamRequired("Outputs"))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Identifies the resources, ML compute instances, and ML storage volumes to
// deploy for a processing job. In distributed training, you specify more than
// one instance.
type ProcessingResources struct {
	_ struct{} `type:"structure"`

	// The configuration for the resources in a cluster used to run the processing
	// job.
	//
	// ClusterConfig is a required field
	ClusterConfig *ProcessingClusterConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s ProcessingResources) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingResources) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProcessingResources"}

	if s.ClusterConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterConfig"))
	}
	if s.ClusterConfig != nil {
		if err := s.ClusterConfig.Validate(); err != nil {
			invalidParams.AddNested("ClusterConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about where and how you want to obtain the inputs for an processing
// job.
type ProcessingS3Input struct {
	_ struct{} `type:"structure"`

	// The local path to the Amazon S3 bucket where you want Amazon SageMaker to
	// download the inputs to run a processing job. LocalPath is an absolute path
	// to the input data.
	//
	// LocalPath is a required field
	LocalPath *string `type:"string" required:"true"`

	// Whether to use Gzip compression for Amazon S3 storage.
	S3CompressionType ProcessingS3CompressionType `type:"string" enum:"true"`

	// Whether the data stored in Amazon S3 is FullyReplicated or ShardedByS3Key.
	S3DataDistributionType ProcessingS3DataDistributionType `type:"string" enum:"true"`

	// Whether you use an S3Prefix or a ManifestFile for the data type. If you choose
	// S3Prefix, S3Uri identifies a key name prefix. Amazon SageMaker uses all objects
	// with the specified key name prefix for the processing job. If you choose
	// ManifestFile, S3Uri identifies an object that is a manifest file containing
	// a list of object keys that you want Amazon SageMaker to use for the processing
	// job.
	//
	// S3DataType is a required field
	S3DataType ProcessingS3DataType `type:"string" required:"true" enum:"true"`

	// Whether to use File or Pipe input mode. In File mode, Amazon SageMaker copies
	// the data from the input source onto the local Amazon Elastic Block Store
	// (Amazon EBS) volumes before starting your training algorithm. This is the
	// most commonly used input mode. In Pipe mode, Amazon SageMaker streams input
	// data from the source directly to your algorithm without using the EBS volume.
	//
	// S3InputMode is a required field
	S3InputMode ProcessingS3InputMode `type:"string" required:"true" enum:"true"`

	// The URI for the Amazon S3 storage where you want Amazon SageMaker to download
	// the artifacts needed to run a processing job.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProcessingS3Input) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingS3Input) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProcessingS3Input"}

	if s.LocalPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocalPath"))
	}
	if len(s.S3DataType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("S3DataType"))
	}
	if len(s.S3InputMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("S3InputMode"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about where and how you want to store the results of an processing
// job.
type ProcessingS3Output struct {
	_ struct{} `type:"structure"`

	// The local path to the Amazon S3 bucket where you want Amazon SageMaker to
	// save the results of an processing job. LocalPath is an absolute path to the
	// input data.
	//
	// LocalPath is a required field
	LocalPath *string `type:"string" required:"true"`

	// Whether to upload the results of the processing job continuously or after
	// the job completes.
	//
	// S3UploadMode is a required field
	S3UploadMode ProcessingS3UploadMode `type:"string" required:"true" enum:"true"`

	// A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker
	// to save the results of a processing job.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProcessingS3Output) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingS3Output) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProcessingS3Output"}

	if s.LocalPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocalPath"))
	}
	if len(s.S3UploadMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("S3UploadMode"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a time limit for how long the processing job is allowed to run.
type ProcessingStoppingCondition struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum runtime in seconds.
	//
	// MaxRuntimeInSeconds is a required field
	MaxRuntimeInSeconds *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ProcessingStoppingCondition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingStoppingCondition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProcessingStoppingCondition"}

	if s.MaxRuntimeInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxRuntimeInSeconds"))
	}
	if s.MaxRuntimeInSeconds != nil && *s.MaxRuntimeInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRuntimeInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Identifies a model that you want to host and the resources to deploy for
// hosting it. If you are deploying multiple models, tell Amazon SageMaker how
// to distribute traffic among the models by specifying variant weights.
type ProductionVariant struct {
	_ struct{} `type:"structure"`

	// The size of the Elastic Inference (EI) instance to use for the production
	// variant. EI instances provide on-demand GPU computing for inference. For
	// more information, see Using Elastic Inference in Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
	AcceleratorType ProductionVariantAcceleratorType `type:"string" enum:"true"`

	// Number of instances to launch initially.
	//
	// InitialInstanceCount is a required field
	InitialInstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// Determines initial traffic distribution among all of the models that you
	// specify in the endpoint configuration. The traffic to a production variant
	// is determined by the ratio of the VariantWeight to the sum of all VariantWeight
	// values across all ProductionVariants. If unspecified, it defaults to 1.0.
	InitialVariantWeight *float64 `type:"float"`

	// The ML compute instance type.
	//
	// InstanceType is a required field
	InstanceType ProductionVariantInstanceType `type:"string" required:"true" enum:"true"`

	// The name of the model that you want to host. This is the name that you specified
	// when creating the model.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// The name of the production variant.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProductionVariant) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProductionVariant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProductionVariant"}

	if s.InitialInstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InitialInstanceCount"))
	}
	if s.InitialInstanceCount != nil && *s.InitialInstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("InitialInstanceCount", 1))
	}
	if len(s.InstanceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}

	if s.ModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelName"))
	}

	if s.VariantName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VariantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes weight and capacities for a production variant associated with
// an endpoint. If you sent a request to the UpdateEndpointWeightsAndCapacities
// API and the endpoint status is Updating, you get different desired and current
// values.
type ProductionVariantSummary struct {
	_ struct{} `type:"structure"`

	// The number of instances associated with the variant.
	CurrentInstanceCount *int64 `min:"1" type:"integer"`

	// The weight associated with the variant.
	CurrentWeight *float64 `type:"float"`

	// An array of DeployedImage objects that specify the Amazon EC2 Container Registry
	// paths of the inference images deployed on instances of this ProductionVariant.
	DeployedImages []DeployedImage `type:"list"`

	// The number of instances requested in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredInstanceCount *int64 `min:"1" type:"integer"`

	// The requested weight, as specified in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredWeight *float64 `type:"float"`

	// The name of the variant.
	//
	// VariantName is a required field
	VariantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProductionVariantSummary) String() string {
	return awsutil.Prettify(s)
}

// Part of the SuggestionQuery type. Specifies a hint for retrieving property
// names that begin with the specified text.
type PropertyNameQuery struct {
	_ struct{} `type:"structure"`

	// Text that begins a property's name.
	//
	// PropertyNameHint is a required field
	PropertyNameHint *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PropertyNameQuery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyNameQuery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PropertyNameQuery"}

	if s.PropertyNameHint == nil {
		invalidParams.Add(aws.NewErrParamRequired("PropertyNameHint"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A property name returned from a GetSearchSuggestions call that specifies
// a value in the PropertyNameQuery field.
type PropertyNameSuggestion struct {
	_ struct{} `type:"structure"`

	// A suggested property name based on what you entered in the search textbox
	// in the Amazon SageMaker console.
	PropertyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PropertyNameSuggestion) String() string {
	return awsutil.Prettify(s)
}

// Defines the amount of money paid to an Amazon Mechanical Turk worker for
// each task performed.
//
// Use one of the following prices for bounding box tasks. Prices are in US
// dollars and should be based on the complexity of the task; the longer it
// takes in your initial testing, the more you should offer.
//
//    * 0.036
//
//    * 0.048
//
//    * 0.060
//
//    * 0.072
//
//    * 0.120
//
//    * 0.240
//
//    * 0.360
//
//    * 0.480
//
//    * 0.600
//
//    * 0.720
//
//    * 0.840
//
//    * 0.960
//
//    * 1.080
//
//    * 1.200
//
// Use one of the following prices for image classification, text classification,
// and custom tasks. Prices are in US dollars.
//
//    * 0.012
//
//    * 0.024
//
//    * 0.036
//
//    * 0.048
//
//    * 0.060
//
//    * 0.072
//
//    * 0.120
//
//    * 0.240
//
//    * 0.360
//
//    * 0.480
//
//    * 0.600
//
//    * 0.720
//
//    * 0.840
//
//    * 0.960
//
//    * 1.080
//
//    * 1.200
//
// Use one of the following prices for semantic segmentation tasks. Prices are
// in US dollars.
//
//    * 0.840
//
//    * 0.960
//
//    * 1.080
//
//    * 1.200
//
// Use one of the following prices for Textract AnalyzeDocument Important Form
// Key Amazon Augmented AI review tasks. Prices are in US dollars.
//
//    * 2.400
//
//    * 2.280
//
//    * 2.160
//
//    * 2.040
//
//    * 1.920
//
//    * 1.800
//
//    * 1.680
//
//    * 1.560
//
//    * 1.440
//
//    * 1.320
//
//    * 1.200
//
//    * 1.080
//
//    * 0.960
//
//    * 0.840
//
//    * 0.720
//
//    * 0.600
//
//    * 0.480
//
//    * 0.360
//
//    * 0.240
//
//    * 0.120
//
//    * 0.072
//
//    * 0.060
//
//    * 0.048
//
//    * 0.036
//
//    * 0.024
//
//    * 0.012
//
// Use one of the following prices for Rekognition DetectModerationLabels Amazon
// Augmented AI review tasks. Prices are in US dollars.
//
//    * 1.200
//
//    * 1.080
//
//    * 0.960
//
//    * 0.840
//
//    * 0.720
//
//    * 0.600
//
//    * 0.480
//
//    * 0.360
//
//    * 0.240
//
//    * 0.120
//
//    * 0.072
//
//    * 0.060
//
//    * 0.048
//
//    * 0.036
//
//    * 0.024
//
//    * 0.012
//
// Use one of the following prices for Amazon Augmented AI custom human review
// tasks. Prices are in US dollars.
//
//    * 1.200
//
//    * 1.080
//
//    * 0.960
//
//    * 0.840
//
//    * 0.720
//
//    * 0.600
//
//    * 0.480
//
//    * 0.360
//
//    * 0.240
//
//    * 0.120
//
//    * 0.072
//
//    * 0.060
//
//    * 0.048
//
//    * 0.036
//
//    * 0.024
//
//    * 0.012
type PublicWorkforceTaskPrice struct {
	_ struct{} `type:"structure"`

	// Defines the amount of money paid to an Amazon Mechanical Turk worker in United
	// States dollars.
	AmountInUsd *USD `type:"structure"`
}

// String returns the string representation
func (s PublicWorkforceTaskPrice) String() string {
	return awsutil.Prettify(s)
}

// Contains input values for a task.
type RenderableTask struct {
	_ struct{} `type:"structure"`

	// A JSON object that contains values for the variables defined in the template.
	// It is made available to the template under the substitution variable task.input.
	// For example, if you define a variable task.input.text in your template, you
	// can supply the variable in the JSON object as "text": "sample text".
	//
	// Input is a required field
	Input *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s RenderableTask) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenderableTask) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RenderableTask"}

	if s.Input == nil {
		invalidParams.Add(aws.NewErrParamRequired("Input"))
	}
	if s.Input != nil && len(*s.Input) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Input", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A description of an error that occurred while rendering the template.
type RenderingError struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a specific class of errors.
	//
	// Code is a required field
	Code *string `type:"string" required:"true"`

	// A human-readable message describing the error.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RenderingError) String() string {
	return awsutil.Prettify(s)
}

// The resolved attributes.
type ResolvedAttributes struct {
	_ struct{} `type:"structure"`

	// Applies a metric to minimize or maximize for the job's objective.
	AutoMLJobObjective *AutoMLJobObjective `type:"structure"`

	// How long a job is allowed to run, or how many candidates a job is allowed
	// to generate.
	CompletionCriteria *AutoMLJobCompletionCriteria `type:"structure"`

	// The problem type.
	ProblemType ProblemType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ResolvedAttributes) String() string {
	return awsutil.Prettify(s)
}

// Describes the resources, including ML compute instances and ML storage volumes,
// to use for model training.
type ResourceConfig struct {
	_ struct{} `type:"structure"`

	// The number of ML compute instances to use. For distributed training, provide
	// a value greater than 1.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// The ML compute instance type.
	//
	// InstanceType is a required field
	InstanceType TrainingInstanceType `type:"string" required:"true" enum:"true"`

	// The AWS KMS key that Amazon SageMaker uses to encrypt data on the storage
	// volume attached to the ML compute instance(s) that run the training job.
	//
	// Certain Nitro-based instances include local storage, dependent on the instance
	// type. Local storage volumes are encrypted using a hardware module on the
	// instance. You can't request a VolumeKmsKeyId when using an instance type
	// with local storage.
	//
	// For a list of instance types that support local instance storage, see Instance
	// Store Volumes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
	//
	// For more information about local instance storage encryption, see SSD Instance
	// Store Volumes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
	//
	// The VolumeKmsKeyId can be in any of the following formats:
	//
	//    * // KMS Key ID "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * // Amazon Resource Name (ARN) of a KMS Key "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// The size of the ML storage volume that you want to provision.
	//
	// ML storage volumes store model artifacts and incremental states. Training
	// algorithms might also use the ML storage volume for scratch space. If you
	// want to store the training data in the ML storage volume, choose File as
	// the TrainingInputMode in the algorithm specification.
	//
	// You must specify sufficient ML storage for your scenario.
	//
	// Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume
	// type.
	//
	// Certain Nitro-based instances include local storage with a fixed total size,
	// dependent on the instance type. When using these instances for training,
	// Amazon SageMaker mounts the local instance storage instead of Amazon EBS
	// gp2 storage. You can't request a VolumeSizeInGB greater than the total size
	// of the local instance storage.
	//
	// For a list of instance types that support local instance storage, including
	// the total size per instance type, see Instance Store Volumes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
	//
	// VolumeSizeInGB is a required field
	VolumeSizeInGB *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceConfig"}

	if s.InstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceCount"))
	}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("InstanceCount", 1))
	}
	if len(s.InstanceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}

	if s.VolumeSizeInGB == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeSizeInGB"))
	}
	if s.VolumeSizeInGB != nil && *s.VolumeSizeInGB < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VolumeSizeInGB", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the maximum number of training jobs and parallel training jobs
// that a hyperparameter tuning job can launch.
type ResourceLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of training jobs that a hyperparameter tuning job can
	// launch.
	//
	// MaxNumberOfTrainingJobs is a required field
	MaxNumberOfTrainingJobs *int64 `min:"1" type:"integer" required:"true"`

	// The maximum number of concurrent training jobs that a hyperparameter tuning
	// job can launch.
	//
	// MaxParallelTrainingJobs is a required field
	MaxParallelTrainingJobs *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ResourceLimits) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceLimits) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceLimits"}

	if s.MaxNumberOfTrainingJobs == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxNumberOfTrainingJobs"))
	}
	if s.MaxNumberOfTrainingJobs != nil && *s.MaxNumberOfTrainingJobs < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxNumberOfTrainingJobs", 1))
	}

	if s.MaxParallelTrainingJobs == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxParallelTrainingJobs"))
	}
	if s.MaxParallelTrainingJobs != nil && *s.MaxParallelTrainingJobs < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxParallelTrainingJobs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The instance type and the Amazon Resource Name (ARN) of the SageMaker image
// created on the instance. The ARN is stored as metadata in SageMaker Studio
// notebooks.
type ResourceSpec struct {
	_ struct{} `type:"structure"`

	// The instance type.
	InstanceType AppInstanceType `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
	SageMakerImageArn *string `type:"string"`
}

// String returns the string representation
func (s ResourceSpec) String() string {
	return awsutil.Prettify(s)
}

// The retention policy for data stored on an Amazon Elastic File System (EFS)
// volume.
type RetentionPolicy struct {
	_ struct{} `type:"structure"`

	// The default is Retain, which specifies to keep the data stored on the EFS
	// volume.
	//
	// Specify Delete to delete the data stored on the EFS volume.
	HomeEfsFileSystem RetentionType `type:"string" enum:"true"`
}

// String returns the string representation
func (s RetentionPolicy) String() string {
	return awsutil.Prettify(s)
}

// Describes the S3 data source.
type S3DataSource struct {
	_ struct{} `type:"structure"`

	// A list of one or more attribute names to use that are found in a specified
	// augmented manifest file.
	AttributeNames []string `type:"list"`

	// If you want Amazon SageMaker to replicate the entire dataset on each ML compute
	// instance that is launched for model training, specify FullyReplicated.
	//
	// If you want Amazon SageMaker to replicate a subset of data on each ML compute
	// instance that is launched for model training, specify ShardedByS3Key. If
	// there are n ML compute instances launched for a training job, each instance
	// gets approximately 1/n of the number of S3 objects. In this case, model training
	// on each machine uses only the subset of training data.
	//
	// Don't choose more ML compute instances for training than available S3 objects.
	// If you do, some nodes won't get any data and you will pay for nodes that
	// aren't getting any training data. This applies in both File and Pipe modes.
	// Keep this in mind when developing algorithms.
	//
	// In distributed training, where you use multiple ML compute EC2 instances,
	// you might choose ShardedByS3Key. If the algorithm requires copying training
	// data to the ML storage volume (when TrainingInputMode is set to File), this
	// copies 1/n of the number of objects.
	S3DataDistributionType S3DataDistribution `type:"string" enum:"true"`

	// If you choose S3Prefix, S3Uri identifies a key name prefix. Amazon SageMaker
	// uses all objects that match the specified key name prefix for model training.
	//
	// If you choose ManifestFile, S3Uri identifies an object that is a manifest
	// file containing a list of object keys that you want Amazon SageMaker to use
	// for model training.
	//
	// If you choose AugmentedManifestFile, S3Uri identifies an object that is an
	// augmented manifest file in JSON lines format. This file contains the data
	// you want to use for model training. AugmentedManifestFile can only be used
	// if the Channel's input mode is Pipe.
	//
	// S3DataType is a required field
	S3DataType S3DataType `type:"string" required:"true" enum:"true"`

	// Depending on the value specified for the S3DataType, identifies either a
	// key name prefix or a manifest. For example:
	//
	//    * A key name prefix might look like this: s3://bucketname/exampleprefix
	//
	//    * A manifest might look like this: s3://bucketname/example.manifest A
	//    manifest is an S3 object which is a JSON file consisting of an array of
	//    elements. The first element is a prefix which is followed by one or more
	//    suffixes. SageMaker appends the suffix elements to the prefix to get a
	//    full set of S3Uri. Note that the prefix must be a valid non-empty S3Uri
	//    that precludes users from specifying a manifest whose individual S3Uri
	//    is sourced from different S3 buckets. The following code example shows
	//    a valid manifest format: [ {"prefix": "s3://customer_bucket/some/prefix/"},
	//    "relative/path/to/custdata-1", "relative/path/custdata-2", ... "relative/path/custdata-N"
	//    ] This JSON is equivalent to the following S3Uri list: s3://customer_bucket/some/prefix/relative/path/to/custdata-1
	//    s3://customer_bucket/some/prefix/relative/path/custdata-2 ... s3://customer_bucket/some/prefix/relative/path/custdata-N
	//    The complete set of S3Uri in this manifest is the input data for the channel
	//    for this data source. The object that each S3Uri points to must be readable
	//    by the IAM role that Amazon SageMaker uses to perform tasks on your behalf.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3DataSource"}
	if len(s.S3DataType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("S3DataType"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration details about the monitoring schedule.
type ScheduleConfig struct {
	_ struct{} `type:"structure"`

	// A cron expression that describes details about the monitoring schedule.
	//
	// Currently the only supported cron expressions are:
	//
	//    * If you want to set the job to start every hour, please use the following:
	//    Hourly: cron(0 * ? * * *)
	//
	//    * If you want to start the job daily: cron(0 [00-23] ? * * *)
	//
	// For example, the following are valid cron expressions:
	//
	//    * Daily at noon UTC: cron(0 12 ? * * *)
	//
	//    * Daily at midnight UTC: cron(0 0 ? * * *)
	//
	// To support running every 6, 12 hours, the following are also supported:
	//
	// cron(0 [00-23]/[01-24] ? * * *)
	//
	// For example, the following are valid cron expressions:
	//
	//    * Every 12 hours, starting at 5pm UTC: cron(0 17/12 ? * * *)
	//
	//    * Every two hours starting at midnight: cron(0 0/2 ? * * *)
	//
	//    * Even though the cron expression is set to start at 5PM UTC, note that
	//    there could be a delay of 0-20 minutes from the actual requested time
	//    to run the execution.
	//
	//    * We recommend that if you would like a daily schedule, you do not provide
	//    this parameter. Amazon SageMaker will pick a time for running every day.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ScheduleConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduleConfig"}

	if s.ScheduleExpression == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduleExpression"))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScheduleExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A multi-expression that searches for the specified resource or resources
// in a search. All resource objects that satisfy the expression's condition
// are included in the search results. You must specify at least one subexpression,
// filter, or nested filter. A SearchExpression can contain up to twenty elements.
//
// A SearchExpression contains the following components:
//
//    * A list of Filter objects. Each filter defines a simple Boolean expression
//    comprised of a resource property name, Boolean operator, and value.
//
//    * A list of NestedFilter objects. Each nested filter defines a list of
//    Boolean expressions using a list of resource properties. A nested filter
//    is satisfied if a single object in the list satisfies all Boolean expressions.
//
//    * A list of SearchExpression objects. A search expression object can be
//    nested in a list of search expression objects.
//
//    * A Boolean operator: And or Or.
type SearchExpression struct {
	_ struct{} `type:"structure"`

	// A list of filter objects.
	Filters []Filter `min:"1" type:"list"`

	// A list of nested filter objects.
	NestedFilters []NestedFilters `min:"1" type:"list"`

	// A Boolean operator used to evaluate the search expression. If you want every
	// conditional statement in all lists to be satisfied for the entire search
	// expression to be true, specify And. If only a single conditional statement
	// needs to be true for the entire search expression to be true, specify Or.
	// The default value is And.
	Operator BooleanOperator `type:"string" enum:"true"`

	// A list of search expression objects.
	SubExpressions []SearchExpression `min:"1" type:"list"`
}

// String returns the string representation
func (s SearchExpression) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchExpression) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchExpression"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}
	if s.NestedFilters != nil && len(s.NestedFilters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NestedFilters", 1))
	}
	if s.SubExpressions != nil && len(s.SubExpressions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubExpressions", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.NestedFilters != nil {
		for i, v := range s.NestedFilters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NestedFilters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SubExpressions != nil {
		for i, v := range s.SubExpressions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubExpressions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A single resource returned as part of the Search API response.
type SearchRecord struct {
	_ struct{} `type:"structure"`

	// The properties of an experiment.
	Experiment *Experiment `type:"structure"`

	// The properties of a training job.
	TrainingJob *TrainingJob `type:"structure"`

	// The properties of a trial.
	Trial *Trial `type:"structure"`

	// The properties of a trial component.
	TrialComponent *TrialComponent `type:"structure"`
}

// String returns the string representation
func (s SearchRecord) String() string {
	return awsutil.Prettify(s)
}

// An array element of DescribeTrainingJobResponse$SecondaryStatusTransitions.
// It provides additional details about a status that the training job has transitioned
// through. A training job can be in one of several states, for example, starting,
// downloading, training, or uploading. Within each state, there are a number
// of intermediate states. For example, within the starting state, Amazon SageMaker
// could be starting the training job or launching the ML instances. These transitional
// states are referred to as the job's secondary status.
type SecondaryStatusTransition struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the training job transitioned out of this secondary
	// status state into another secondary status state or when the training job
	// has ended.
	EndTime *time.Time `type:"timestamp"`

	// A timestamp that shows when the training job transitioned to the current
	// secondary status state.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// Contains a secondary status information from a training job.
	//
	// Status might be one of the following secondary statuses:
	//
	// InProgress
	//
	//    * Starting - Starting the training job.
	//
	//    * Downloading - An optional stage for algorithms that support File training
	//    input mode. It indicates that data is being downloaded to the ML storage
	//    volumes.
	//
	//    * Training - Training is in progress.
	//
	//    * Uploading - Training is complete and the model artifacts are being uploaded
	//    to the S3 location.
	//
	// Completed
	//
	//    * Completed - The training job has completed.
	//
	// Failed
	//
	//    * Failed - The training job has failed. The reason for the failure is
	//    returned in the FailureReason field of DescribeTrainingJobResponse.
	//
	// Stopped
	//
	//    * MaxRuntimeExceeded - The job stopped because it exceeded the maximum
	//    allowed runtime.
	//
	//    * Stopped - The training job has stopped.
	//
	// Stopping
	//
	//    * Stopping - Stopping the training job.
	//
	// We no longer support the following secondary statuses:
	//
	//    * LaunchingMLInstances
	//
	//    * PreparingTrainingStack
	//
	//    * DownloadingTrainingImage
	//
	// Status is a required field
	Status SecondaryStatus `type:"string" required:"true" enum:"true"`

	// A detailed description of the progress within a secondary status.
	//
	// Amazon SageMaker provides secondary statuses and status messages that apply
	// to each of them:
	//
	// Starting
	//
	//    * Starting the training job.
	//
	//    * Launching requested ML instances.
	//
	//    * Insufficient capacity error from EC2 while launching instances, retrying!
	//
	//    * Launched instance was unhealthy, replacing it!
	//
	//    * Preparing the instances for training.
	//
	// Training
	//
	//    * Downloading the training image.
	//
	//    * Training image download completed. Training in progress.
	//
	// Status messages are subject to change. Therefore, we recommend not including
	// them in code that programmatically initiates actions. For examples, don't
	// use status messages in if statements.
	//
	// To have an overview of your training job's progress, view TrainingJobStatus
	// and SecondaryStatus in DescribeTrainingJob, and StatusMessage together. For
	// example, at the start of a training job, you might see the following:
	//
	//    * TrainingJobStatus - InProgress
	//
	//    * SecondaryStatus - Training
	//
	//    * StatusMessage - Downloading the training image
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s SecondaryStatusTransition) String() string {
	return awsutil.Prettify(s)
}

// Specifies options when sharing an Amazon SageMaker Studio notebook. These
// settings are specified as part of DefaultUserSettings when the CreateDomain
// API is called, and as part of UserSettings when the CreateUserProfile API
// is called.
type SharingSettings struct {
	_ struct{} `type:"structure"`

	// Whether to include the notebook cell output when sharing the notebook. The
	// default is Disabled.
	NotebookOutputOption NotebookOutputOption `type:"string" enum:"true"`

	// When NotebookOutputOption is Allowed, the AWS Key Management Service (KMS)
	// encryption key ID used to encrypt the notebook cell output in the Amazon
	// S3 bucket.
	S3KmsKeyId *string `type:"string"`

	// When NotebookOutputOption is Allowed, the Amazon S3 bucket used to save the
	// notebook cell output. If S3OutputPath isn't specified, a default bucket is
	// used.
	S3OutputPath *string `type:"string"`
}

// String returns the string representation
func (s SharingSettings) String() string {
	return awsutil.Prettify(s)
}

// A configuration for a shuffle option for input data in a channel. If you
// use S3Prefix for S3DataType, the results of the S3 key prefix matches are
// shuffled. If you use ManifestFile, the order of the S3 object references
// in the ManifestFile is shuffled. If you use AugmentedManifestFile, the order
// of the JSON lines in the AugmentedManifestFile is shuffled. The shuffling
// order is determined using the Seed value.
//
// For Pipe input mode, when ShuffleConfig is specified shuffling is done at
// the start of every epoch. With large datasets, this ensures that the order
// of the training data is different for each epoch, and it helps reduce bias
// and possible overfitting. In a multi-node training job when ShuffleConfig
// is combined with S3DataDistributionType of ShardedByS3Key, the data is shuffled
// across nodes so that the content sent to a particular node on the first epoch
// might be sent to a different node on the second epoch.
type ShuffleConfig struct {
	_ struct{} `type:"structure"`

	// Determines the shuffling order in ShuffleConfig value.
	//
	// Seed is a required field
	Seed *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s ShuffleConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShuffleConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ShuffleConfig"}

	if s.Seed == nil {
		invalidParams.Add(aws.NewErrParamRequired("Seed"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an algorithm that was used to create the model package. The algorithm
// must be either an algorithm resource in your Amazon SageMaker account or
// an algorithm in AWS Marketplace that you are subscribed to.
type SourceAlgorithm struct {
	_ struct{} `type:"structure"`

	// The name of an algorithm that was used to create the model package. The algorithm
	// must be either an algorithm resource in your Amazon SageMaker account or
	// an algorithm in AWS Marketplace that you are subscribed to.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix).
	ModelDataUrl *string `type:"string"`
}

// String returns the string representation
func (s SourceAlgorithm) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceAlgorithm) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceAlgorithm"}

	if s.AlgorithmName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlgorithmName"))
	}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlgorithmName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of algorithms that were used to create a model package.
type SourceAlgorithmSpecification struct {
	_ struct{} `type:"structure"`

	// A list of the algorithms that were used to create a model package.
	//
	// SourceAlgorithms is a required field
	SourceAlgorithms []SourceAlgorithm `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s SourceAlgorithmSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceAlgorithmSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceAlgorithmSpecification"}

	if s.SourceAlgorithms == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceAlgorithms"))
	}
	if s.SourceAlgorithms != nil && len(s.SourceAlgorithms) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceAlgorithms", 1))
	}
	if s.SourceAlgorithms != nil {
		for i, v := range s.SourceAlgorithms {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceAlgorithms", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of IP address ranges (CIDRs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)).
// Used to create an allow list of IP addresses for a private workforce. For
// more information, see .
type SourceIpConfig struct {
	_ struct{} `type:"structure"`

	// A list of one to ten Classless Inter-Domain Routing (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
	// (CIDR) values.
	//
	// Maximum: Ten CIDR values
	//
	// The following Length Constraints apply to individual CIDR values in the CIDR
	// value list.
	//
	// Cidrs is a required field
	Cidrs []string `type:"list" required:"true"`
}

// String returns the string representation
func (s SourceIpConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceIpConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceIpConfig"}

	if s.Cidrs == nil {
		invalidParams.Add(aws.NewErrParamRequired("Cidrs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a limit to how long a model training or compilation job can run.
// It also specifies how long you are willing to wait for a managed spot training
// job to complete. When the job reaches the time limit, Amazon SageMaker ends
// the training or compilation job. Use this API to cap model training costs.
//
// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
// delays job termination for 120 seconds. Algorithms can use this 120-second
// window to save the model artifacts, so the results of training are not lost.
//
// The training algorithms provided by Amazon SageMaker automatically save the
// intermediate results of a model training job when possible. This attempt
// to save artifacts is only a best effort case as model might not be in a state
// from which it can be saved. For example, if training has just started, the
// model might not be ready to save. When saved, this intermediate data is a
// valid model artifact. You can use it to create a model with CreateModel.
//
// The Neural Topic Model (NTM) currently does not support saving intermediate
// model artifacts. When training NTMs, make sure that the maximum runtime is
// sufficient for the training job to complete.
type StoppingCondition struct {
	_ struct{} `type:"structure"`

	// The maximum length of time, in seconds, that the training or compilation
	// job can run. If job does not complete during this time, Amazon SageMaker
	// ends the job. If value is not specified, default value is 1 day. The maximum
	// value is 28 days.
	MaxRuntimeInSeconds *int64 `min:"1" type:"integer"`

	// The maximum length of time, in seconds, how long you are willing to wait
	// for a managed spot training job to complete. It is the amount of time spent
	// waiting for Spot capacity plus the amount of time the training job runs.
	// It must be equal to or greater than MaxRuntimeInSeconds.
	MaxWaitTimeInSeconds *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s StoppingCondition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StoppingCondition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StoppingCondition"}
	if s.MaxRuntimeInSeconds != nil && *s.MaxRuntimeInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxRuntimeInSeconds", 1))
	}
	if s.MaxWaitTimeInSeconds != nil && *s.MaxWaitTimeInSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxWaitTimeInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a work team of a vendor that does the a labelling job.
type SubscribedWorkteam struct {
	_ struct{} `type:"structure"`

	// Marketplace product listing ID.
	ListingId *string `type:"string"`

	// The description of the vendor from the Amazon Marketplace.
	MarketplaceDescription *string `min:"1" type:"string"`

	// The title of the service provided by the vendor in the Amazon Marketplace.
	MarketplaceTitle *string `min:"1" type:"string"`

	// The name of the vendor in the Amazon Marketplace.
	SellerName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the vendor that you have subscribed.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SubscribedWorkteam) String() string {
	return awsutil.Prettify(s)
}

// Specified in the GetSearchSuggestions request. Limits the property names
// that are included in the response.
type SuggestionQuery struct {
	_ struct{} `type:"structure"`

	// Defines a property name hint. Only property names that begin with the specified
	// hint are included in the response.
	PropertyNameQuery *PropertyNameQuery `type:"structure"`
}

// String returns the string representation
func (s SuggestionQuery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SuggestionQuery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SuggestionQuery"}
	if s.PropertyNameQuery != nil {
		if err := s.PropertyNameQuery.Validate(); err != nil {
			invalidParams.AddNested("PropertyNameQuery", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The tag value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The TensorBoard app settings.
type TensorBoardAppSettings struct {
	_ struct{} `type:"structure"`

	// The default instance type and the Amazon Resource Name (ARN) of the SageMaker
	// image created on the instance.
	DefaultResourceSpec *ResourceSpec `type:"structure"`
}

// String returns the string representation
func (s TensorBoardAppSettings) String() string {
	return awsutil.Prettify(s)
}

// Configuration of storage locations for TensorBoard output.
type TensorBoardOutputConfig struct {
	_ struct{} `type:"structure"`

	// Path to local storage location for tensorBoard output. Defaults to /opt/ml/output/tensorboard.
	LocalPath *string `type:"string"`

	// Path to Amazon S3 storage location for TensorBoard output.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TensorBoardOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TensorBoardOutputConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TensorBoardOutputConfig"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about a training job.
type TrainingJob struct {
	_ struct{} `type:"structure"`

	// Information about the algorithm used for training, and algorithm metadata.
	AlgorithmSpecification *AlgorithmSpecification `type:"structure"`

	// The Amazon Resource Name (ARN) of the job.
	AutoMLJobArn *string `min:"1" type:"string"`

	// The billable time in seconds.
	BillableTimeInSeconds *int64 `min:"1" type:"integer"`

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig `type:"structure"`

	// A timestamp that indicates when the training job was created.
	CreationTime *time.Time `type:"timestamp"`

	// Configuration information for the debug hook parameters, collection configuration,
	// and storage paths.
	DebugHookConfig *DebugHookConfig `type:"structure"`

	// Information about the debug rule configuration.
	DebugRuleConfigurations []DebugRuleConfiguration `type:"list"`

	// Information about the evaluation status of the rules for the training job.
	DebugRuleEvaluationStatuses []DebugRuleEvaluationStatus `type:"list"`

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use
	// a deep learning algorithm in distributed training.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// When true, enables managed spot training using Amazon EC2 Spot instances
	// to run training jobs instead of on-demand instances. For more information,
	// see Managed Spot Training (https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html).
	EnableManagedSpotTraining *bool `type:"boolean"`

	// If the TrainingJob was created with network isolation, the value is set to
	// true. If network isolation is enabled, nodes can't communicate beyond the
	// VPC they run in.
	EnableNetworkIsolation *bool `type:"boolean"`

	// Configuration for the experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// If the training job failed, the reason it failed.
	FailureReason *string `type:"string"`

	// A list of final metric values that are set when the training job completes.
	// Used only if the training job was configured to use metrics.
	FinalMetricDataList []MetricData `type:"list"`

	// Algorithm-specific parameters.
	HyperParameters map[string]string `type:"map"`

	// An array of Channel objects that describes each data input channel.
	InputDataConfig []Channel `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the labeling job.
	LabelingJobArn *string `type:"string"`

	// A timestamp that indicates when the status of the training job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// Information about the Amazon S3 location that is configured for storing model
	// artifacts.
	ModelArtifacts *ModelArtifacts `type:"structure"`

	// The S3 path where model artifacts that you configured when creating the job
	// are stored. Amazon SageMaker creates subfolders for model artifacts.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// Resources, including ML compute instances and ML storage volumes, that are
	// configured for model training.
	ResourceConfig *ResourceConfig `type:"structure"`

	// The AWS Identity and Access Management (IAM) role configured for the training
	// job.
	RoleArn *string `min:"20" type:"string"`

	// Provides detailed information about the state of the training job. For detailed
	// information about the secondary status of the training job, see StatusMessage
	// under SecondaryStatusTransition.
	//
	// Amazon SageMaker provides primary statuses and secondary statuses that apply
	// to each of them:
	//
	// InProgress
	//
	//    * Starting - Starting the training job.
	//
	//    * Downloading - An optional stage for algorithms that support File training
	//    input mode. It indicates that data is being downloaded to the ML storage
	//    volumes.
	//
	//    * Training - Training is in progress.
	//
	//    * Uploading - Training is complete and the model artifacts are being uploaded
	//    to the S3 location.
	//
	// Completed
	//
	//    * Completed - The training job has completed.
	//
	// Failed
	//
	//    * Failed - The training job has failed. The reason for the failure is
	//    returned in the FailureReason field of DescribeTrainingJobResponse.
	//
	// Stopped
	//
	//    * MaxRuntimeExceeded - The job stopped because it exceeded the maximum
	//    allowed runtime.
	//
	//    * Stopped - The training job has stopped.
	//
	// Stopping
	//
	//    * Stopping - Stopping the training job.
	//
	// Valid values for SecondaryStatus are subject to change.
	//
	// We no longer support the following secondary statuses:
	//
	//    * LaunchingMLInstances
	//
	//    * PreparingTrainingStack
	//
	//    * DownloadingTrainingImage
	SecondaryStatus SecondaryStatus `type:"string" enum:"true"`

	// A history of all of the secondary statuses that the training job has transitioned
	// through.
	SecondaryStatusTransitions []SecondaryStatusTransition `type:"list"`

	// Specifies a limit to how long a model training job can run. When the job
	// reaches the time limit, Amazon SageMaker ends the training job. Use this
	// API to cap model training costs.
	//
	// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts, so the results of training are not lost.
	StoppingCondition *StoppingCondition `type:"structure"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []Tag `type:"list"`

	// Configuration of storage locations for TensorBoard output.
	TensorBoardOutputConfig *TensorBoardOutputConfig `type:"structure"`

	// Indicates the time when the training job ends on training instances. You
	// are billed for the time interval between the value of TrainingStartTime and
	// this time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker
	// detects a job failure.
	TrainingEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the training job.
	TrainingJobArn *string `type:"string"`

	// The name of the training job.
	TrainingJobName *string `min:"1" type:"string"`

	// The status of the training job.
	//
	// Training job statuses are:
	//
	//    * InProgress - The training is in progress.
	//
	//    * Completed - The training job has completed.
	//
	//    * Failed - The training job has failed. To see the reason for the failure,
	//    see the FailureReason field in the response to a DescribeTrainingJobResponse
	//    call.
	//
	//    * Stopping - The training job is stopping.
	//
	//    * Stopped - The training job has stopped.
	//
	// For more detailed information, see SecondaryStatus.
	TrainingJobStatus TrainingJobStatus `type:"string" enum:"true"`

	// Indicates the time when the training job starts on training instances. You
	// are billed for the time interval between this time and the value of TrainingEndTime.
	// The start time in CloudWatch Logs might be later than this time. The difference
	// is due to the time it takes to download the training data and to the size
	// of the training container.
	TrainingStartTime *time.Time `type:"timestamp"`

	// The training time in seconds.
	TrainingTimeInSeconds *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the associated hyperparameter tuning job
	// if the training job was launched by a hyperparameter tuning job.
	TuningJobArn *string `type:"string"`

	// A VpcConfig object that specifies the VPC that this training job has access
	// to. For more information, see Protect Training Jobs by Using an Amazon Virtual
	// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s TrainingJob) String() string {
	return awsutil.Prettify(s)
}

// Defines the input needed to run a training job using the algorithm.
type TrainingJobDefinition struct {
	_ struct{} `type:"structure"`

	// The hyperparameters used for the training job.
	HyperParameters map[string]string `type:"map"`

	// An array of Channel objects, each of which specifies an input source.
	//
	// InputDataConfig is a required field
	InputDataConfig []Channel `min:"1" type:"list" required:"true"`

	// the path to the S3 bucket where you want to store model artifacts. Amazon
	// SageMaker creates subfolders for the artifacts.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The resources, including the ML compute instances and ML storage volumes,
	// to use for model training.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// Specifies a limit to how long a model training job can run. When the job
	// reaches the time limit, Amazon SageMaker ends the training job. Use this
	// API to cap model training costs.
	//
	// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// The input mode used by the algorithm for the training job. For the input
	// modes that Amazon SageMaker algorithms support, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	//
	// If an algorithm supports the File input mode, Amazon SageMaker downloads
	// the training data from S3 to the provisioned ML storage Volume, and mounts
	// the directory to docker volume for training container. If an algorithm supports
	// the Pipe input mode, Amazon SageMaker streams data directly from S3 to the
	// container.
	//
	// TrainingInputMode is a required field
	TrainingInputMode TrainingInputMode `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TrainingJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingJobDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrainingJobDefinition"}

	if s.InputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputDataConfig"))
	}
	if s.InputDataConfig != nil && len(s.InputDataConfig) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputDataConfig", 1))
	}

	if s.OutputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputDataConfig"))
	}

	if s.ResourceConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceConfig"))
	}

	if s.StoppingCondition == nil {
		invalidParams.Add(aws.NewErrParamRequired("StoppingCondition"))
	}
	if len(s.TrainingInputMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TrainingInputMode"))
	}
	if s.InputDataConfig != nil {
		for i, v := range s.InputDataConfig {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputDataConfig", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The numbers of training jobs launched by a hyperparameter tuning job, categorized
// by status.
type TrainingJobStatusCounters struct {
	_ struct{} `type:"structure"`

	// The number of completed training jobs launched by the hyperparameter tuning
	// job.
	Completed *int64 `type:"integer"`

	// The number of in-progress training jobs launched by a hyperparameter tuning
	// job.
	InProgress *int64 `type:"integer"`

	// The number of training jobs that failed and can't be retried. A failed training
	// job can't be retried if it failed because a client error occurred.
	NonRetryableError *int64 `type:"integer"`

	// The number of training jobs that failed, but can be retried. A failed training
	// job can be retried only if it failed because an internal service error occurred.
	RetryableError *int64 `type:"integer"`

	// The number of training jobs launched by a hyperparameter tuning job that
	// were manually stopped.
	Stopped *int64 `type:"integer"`
}

// String returns the string representation
func (s TrainingJobStatusCounters) String() string {
	return awsutil.Prettify(s)
}

// Provides summary information about a training job.
type TrainingJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the training job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Timestamp when the training job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// A timestamp that shows when the training job ended. This field is set only
	// if the training job has one of the terminal statuses (Completed, Failed,
	// or Stopped).
	TrainingEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`

	// The name of the training job that you want a summary for.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// The status of the training job.
	//
	// TrainingJobStatus is a required field
	TrainingJobStatus TrainingJobStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TrainingJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Defines how the algorithm is used for a training job.
type TrainingSpecification struct {
	_ struct{} `type:"structure"`

	// A list of MetricDefinition objects, which are used for parsing metrics generated
	// by the algorithm.
	MetricDefinitions []MetricDefinition `type:"list"`

	// A list of the HyperParameterSpecification objects, that define the supported
	// hyperparameters. This is required if the algorithm supports automatic model
	// tuning.>
	SupportedHyperParameters []HyperParameterSpecification `type:"list"`

	// A list of the instance types that this algorithm can use for training.
	//
	// SupportedTrainingInstanceTypes is a required field
	SupportedTrainingInstanceTypes []TrainingInstanceType `type:"list" required:"true"`

	// A list of the metrics that the algorithm emits that can be used as the objective
	// metric in a hyperparameter tuning job.
	SupportedTuningJobObjectiveMetrics []HyperParameterTuningJobObjective `type:"list"`

	// Indicates whether the algorithm supports distributed training. If set to
	// false, buyers can't request more than one instance during training.
	SupportsDistributedTraining *bool `type:"boolean"`

	// A list of ChannelSpecification objects, which specify the input sources to
	// be used by the algorithm.
	//
	// TrainingChannels is a required field
	TrainingChannels []ChannelSpecification `min:"1" type:"list" required:"true"`

	// The Amazon ECR registry path of the Docker image that contains the training
	// algorithm.
	//
	// TrainingImage is a required field
	TrainingImage *string `type:"string" required:"true"`

	// An MD5 hash of the training algorithm that identifies the Docker image used
	// for training.
	TrainingImageDigest *string `type:"string"`
}

// String returns the string representation
func (s TrainingSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrainingSpecification"}

	if s.SupportedTrainingInstanceTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("SupportedTrainingInstanceTypes"))
	}

	if s.TrainingChannels == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingChannels"))
	}
	if s.TrainingChannels != nil && len(s.TrainingChannels) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrainingChannels", 1))
	}

	if s.TrainingImage == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingImage"))
	}
	if s.MetricDefinitions != nil {
		for i, v := range s.MetricDefinitions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDefinitions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SupportedHyperParameters != nil {
		for i, v := range s.SupportedHyperParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SupportedHyperParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SupportedTuningJobObjectiveMetrics != nil {
		for i, v := range s.SupportedTuningJobObjectiveMetrics {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SupportedTuningJobObjectiveMetrics", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TrainingChannels != nil {
		for i, v := range s.TrainingChannels {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TrainingChannels", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the location of the channel data.
type TransformDataSource struct {
	_ struct{} `type:"structure"`

	// The S3 location of the data source that is associated with a channel.
	//
	// S3DataSource is a required field
	S3DataSource *TransformS3DataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s TransformDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformDataSource"}

	if s.S3DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the input source of a transform job and the way the transform job
// consumes it.
type TransformInput struct {
	_ struct{} `type:"structure"`

	// If your transform data is compressed, specify the compression type. Amazon
	// SageMaker automatically decompresses the data for the transform job accordingly.
	// The default value is None.
	CompressionType CompressionType `type:"string" enum:"true"`

	// The multipurpose internet mail extension (MIME) type of the data. Amazon
	// SageMaker uses the MIME type with each http call to transfer data to the
	// transform job.
	ContentType *string `type:"string"`

	// Describes the location of the channel data, which is, the S3 location of
	// the input data that the model can consume.
	//
	// DataSource is a required field
	DataSource *TransformDataSource `type:"structure" required:"true"`

	// The method to use to split the transform job's data files into smaller batches.
	// Splitting is necessary when the total size of each object is too large to
	// fit in a single request. You can also use data splitting to improve performance
	// by processing multiple concurrent mini-batches. The default value for SplitType
	// is None, which indicates that input data files are not split, and request
	// payloads contain the entire contents of an input object. Set the value of
	// this parameter to Line to split records on a newline character boundary.
	// SplitType also supports a number of record-oriented binary data formats.
	//
	// When splitting is enabled, the size of a mini-batch depends on the values
	// of the BatchStrategy and MaxPayloadInMB parameters. When the value of BatchStrategy
	// is MultiRecord, Amazon SageMaker sends the maximum number of records in each
	// request, up to the MaxPayloadInMB limit. If the value of BatchStrategy is
	// SingleRecord, Amazon SageMaker sends individual records in each request.
	//
	// Some data formats represent a record as a binary payload wrapped with extra
	// padding bytes. When splitting is applied to a binary data format, padding
	// is removed if the value of BatchStrategy is set to SingleRecord. Padding
	// is not removed if the value of BatchStrategy is set to MultiRecord.
	//
	// For more information about RecordIO, see Create a Dataset Using RecordIO
	// (https://mxnet.apache.org/api/faq/recordio) in the MXNet documentation. For
	// more information about TFRecord, see Consuming TFRecord data (https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data)
	// in the TensorFlow documentation.
	SplitType SplitType `type:"string" enum:"true"`
}

// String returns the string representation
func (s TransformInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformInput"}

	if s.DataSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSource"))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the input needed to run a transform job using the inference specification
// specified in the algorithm.
type TransformJobDefinition struct {
	_ struct{} `type:"structure"`

	// A string that determines the number of records included in a single mini-batch.
	//
	// SingleRecord means only one record is used per mini-batch. MultiRecord means
	// a mini-batch is set to contain as many records that can fit within the MaxPayloadInMB
	// limit.
	BatchStrategy BatchStrategy `type:"string" enum:"true"`

	// The environment variables to set in the Docker container. We support up to
	// 16 key and values entries in the map.
	Environment map[string]string `type:"map"`

	// The maximum number of parallel requests that can be sent to each instance
	// in a transform job. The default value is 1.
	MaxConcurrentTransforms *int64 `type:"integer"`

	// The maximum payload size allowed, in MB. A payload is the data portion of
	// a record (without metadata).
	MaxPayloadInMB *int64 `type:"integer"`

	// A description of the input source and the way the transform job consumes
	// it.
	//
	// TransformInput is a required field
	TransformInput *TransformInput `type:"structure" required:"true"`

	// Identifies the Amazon S3 location where you want Amazon SageMaker to save
	// the results from the transform job.
	//
	// TransformOutput is a required field
	TransformOutput *TransformOutput `type:"structure" required:"true"`

	// Identifies the ML compute instances for the transform job.
	//
	// TransformResources is a required field
	TransformResources *TransformResources `type:"structure" required:"true"`
}

// String returns the string representation
func (s TransformJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformJobDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformJobDefinition"}

	if s.TransformInput == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformInput"))
	}

	if s.TransformOutput == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformOutput"))
	}

	if s.TransformResources == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformResources"))
	}
	if s.TransformInput != nil {
		if err := s.TransformInput.Validate(); err != nil {
			invalidParams.AddNested("TransformInput", err.(aws.ErrInvalidParams))
		}
	}
	if s.TransformOutput != nil {
		if err := s.TransformOutput.Validate(); err != nil {
			invalidParams.AddNested("TransformOutput", err.(aws.ErrInvalidParams))
		}
	}
	if s.TransformResources != nil {
		if err := s.TransformResources.Validate(); err != nil {
			invalidParams.AddNested("TransformResources", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a summary of a transform job. Multiple TransformJobSummary objects
// are returned as a list after in response to a ListTransformJobs call.
type TransformJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the transform Job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// If the transform job failed, the reason it failed.
	FailureReason *string `type:"string"`

	// Indicates when the transform job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// Indicates when the transform job ends on compute instances. For successful
	// jobs and stopped jobs, this is the exact time recorded after the results
	// are uploaded. For failed jobs, this is when Amazon SageMaker detected that
	// the job failed.
	TransformEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the transform job.
	//
	// TransformJobArn is a required field
	TransformJobArn *string `type:"string" required:"true"`

	// The name of the transform job.
	//
	// TransformJobName is a required field
	TransformJobName *string `min:"1" type:"string" required:"true"`

	// The status of the transform job.
	//
	// TransformJobStatus is a required field
	TransformJobStatus TransformJobStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TransformJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes the results of a transform job.
type TransformOutput struct {
	_ struct{} `type:"structure"`

	// The MIME type used to specify the output data. Amazon SageMaker uses the
	// MIME type with each http call to transfer data from the transform job.
	Accept *string `type:"string"`

	// Defines how to assemble the results of the transform job as a single S3 object.
	// Choose a format that is most convenient to you. To concatenate the results
	// in binary format, specify None. To add a newline character at the end of
	// every transformed record, specify Line.
	AssembleWith AssemblyType `type:"string" enum:"true"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt the model artifacts at rest using Amazon S3 server-side encryption.
	// The KmsKeyId can be any of the following formats:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	//
	// If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS
	// key for Amazon S3 for your role's account. For more information, see KMS-Managed
	// Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// The KMS key policy must grant permission to the IAM role that you specify
	// in your CreateModel request. For more information, see Using Key Policies
	// in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	// in the AWS Key Management Service Developer Guide.
	KmsKeyId *string `type:"string"`

	// The Amazon S3 path where you want Amazon SageMaker to store the results of
	// the transform job. For example, s3://bucket-name/key-name-prefix.
	//
	// For every S3 object used as input for the transform job, batch transform
	// stores the transformed data with an .out suffix in a corresponding subfolder
	// in the location in the output prefix. For example, for the input data stored
	// at s3://bucket-name/input-name-prefix/dataset01/data.csv, batch transform
	// stores the transformed data at s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out.
	// Batch transform doesn't upload partially processed objects. For an input
	// S3 object that contains multiple records, it creates an .out file only if
	// the transform job succeeds on the entire file. When the input contains multiple
	// S3 objects, the batch transform job processes the listed S3 objects and uploads
	// only the output for successfully processed objects. If any object fails in
	// the transform job batch transform marks the job as failed to prompt investigation.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TransformOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformOutput"}

	if s.S3OutputPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the resources, including ML instance types and ML instance count,
// to use for transform job.
type TransformResources struct {
	_ struct{} `type:"structure"`

	// The number of ML compute instances to use in the transform job. For distributed
	// transform jobs, specify a value greater than 1. The default value is 1.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `min:"1" type:"integer" required:"true"`

	// The ML compute instance type for the transform job. If you are using built-in
	// algorithms to transform moderately sized datasets, we recommend using ml.m4.xlarge
	// or ml.m5.large instance types.
	//
	// InstanceType is a required field
	InstanceType TransformInstanceType `type:"string" required:"true" enum:"true"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt model data on the storage volume attached to the ML compute instance(s)
	// that run the batch transform job. The VolumeKmsKeyId can be any of the following
	// formats:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	VolumeKmsKeyId *string `type:"string"`
}

// String returns the string representation
func (s TransformResources) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformResources) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformResources"}

	if s.InstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceCount"))
	}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("InstanceCount", 1))
	}
	if len(s.InstanceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the S3 data source.
type TransformS3DataSource struct {
	_ struct{} `type:"structure"`

	// If you choose S3Prefix, S3Uri identifies a key name prefix. Amazon SageMaker
	// uses all objects with the specified key name prefix for batch transform.
	//
	// If you choose ManifestFile, S3Uri identifies an object that is a manifest
	// file containing a list of object keys that you want Amazon SageMaker to use
	// for batch transform.
	//
	// The following values are compatible: ManifestFile, S3Prefix
	//
	// The following value is not compatible: AugmentedManifestFile
	//
	// S3DataType is a required field
	S3DataType S3DataType `type:"string" required:"true" enum:"true"`

	// Depending on the value specified for the S3DataType, identifies either a
	// key name prefix or a manifest. For example:
	//
	//    * A key name prefix might look like this: s3://bucketname/exampleprefix.
	//
	//    * A manifest might look like this: s3://bucketname/example.manifest The
	//    manifest is an S3 object which is a JSON file with the following format:
	//    [ {"prefix": "s3://customer_bucket/some/prefix/"}, "relative/path/to/custdata-1",
	//    "relative/path/custdata-2", ... "relative/path/custdata-N" ] The preceding
	//    JSON matches the following s3Uris: s3://customer_bucket/some/prefix/relative/path/to/custdata-1
	//    s3://customer_bucket/some/prefix/relative/path/custdata-2 ... s3://customer_bucket/some/prefix/relative/path/custdata-N
	//    The complete set of S3Uris in this manifest constitutes the input data
	//    for the channel for this datasource. The object that each S3Uris points
	//    to must be readable by the IAM role that Amazon SageMaker uses to perform
	//    tasks on your behalf.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TransformS3DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformS3DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransformS3DataSource"}
	if len(s.S3DataType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("S3DataType"))
	}

	if s.S3Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The properties of a trial as returned by the Search API.
type Trial struct {
	_ struct{} `type:"structure"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	CreatedBy *UserContext `type:"structure"`

	// When the trial was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the trial as displayed. If DisplayName isn't specified, TrialName
	// is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The name of the experiment the trial is part of.
	ExperimentName *string `min:"1" type:"string"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	LastModifiedBy *UserContext `type:"structure"`

	// Who last modified the trial.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The source of the trial.
	Source *TrialSource `type:"structure"`

	// The list of tags that are associated with the trial. You can use Search API
	// to search on the tags.
	Tags []Tag `type:"list"`

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string `type:"string"`

	// A list of the components associated with the trial. For each component, a
	// summary of the component's properties is included.
	TrialComponentSummaries []TrialComponentSimpleSummary `type:"list"`

	// The name of the trial.
	TrialName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Trial) String() string {
	return awsutil.Prettify(s)
}

// The properties of a trial component as returned by the Search API.
type TrialComponent struct {
	_ struct{} `type:"structure"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	CreatedBy *UserContext `type:"structure"`

	// When the component was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the component as displayed. If DisplayName isn't specified, TrialComponentName
	// is displayed.
	DisplayName *string `min:"1" type:"string"`

	// When the component ended.
	EndTime *time.Time `type:"timestamp"`

	// The input artifacts of the component.
	InputArtifacts map[string]TrialComponentArtifact `type:"map"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	LastModifiedBy *UserContext `type:"structure"`

	// When the component was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The metrics for the component.
	Metrics []TrialComponentMetricSummary `type:"list"`

	// The output artifacts of the component.
	OutputArtifacts map[string]TrialComponentArtifact `type:"map"`

	// The hyperparameters of the component.
	Parameters map[string]TrialComponentParameterValue `type:"map"`

	// An array of the parents of the component. A parent is a trial the component
	// is associated with and the experiment the trial is part of. A component might
	// not have any parents.
	Parents []Parent `type:"list"`

	// The Amazon Resource Name (ARN) and job type of the source of the component.
	Source *TrialComponentSource `type:"structure"`

	// Details of the source of the component.
	SourceDetail *TrialComponentSourceDetail `type:"structure"`

	// When the component started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the trial component.
	Status *TrialComponentStatus `type:"structure"`

	// The list of tags that are associated with the component. You can use Search
	// API to search on the tags.
	Tags []Tag `type:"list"`

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string `type:"string"`

	// The name of the trial component.
	TrialComponentName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TrialComponent) String() string {
	return awsutil.Prettify(s)
}

// Represents an input or output artifact of a trial component. You specify
// TrialComponentArtifact as part of the InputArtifacts and OutputArtifacts
// parameters in the CreateTrialComponent request.
//
// Examples of input artifacts are datasets, algorithms, hyperparameters, source
// code, and instance types. Examples of output artifacts are metrics, snapshots,
// logs, and images.
type TrialComponentArtifact struct {
	_ struct{} `type:"structure"`

	// The media type of the artifact, which indicates the type of data in the artifact
	// file. The media type consists of a type and a subtype concatenated with a
	// slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The type
	// specifies the category of the media. The subtype specifies the kind of data.
	MediaType *string `type:"string"`

	// The location of the artifact.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TrialComponentArtifact) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrialComponentArtifact) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrialComponentArtifact"}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A summary of the metrics of a trial component.
type TrialComponentMetricSummary struct {
	_ struct{} `type:"structure"`

	// The average value of the metric.
	Avg *float64 `type:"double"`

	// The number of samples used to generate the metric.
	Count *int64 `type:"integer"`

	// The most recent value of the metric.
	Last *float64 `type:"double"`

	// The maximum value of the metric.
	Max *float64 `type:"double"`

	// The name of the metric.
	MetricName *string `min:"1" type:"string"`

	// The minimum value of the metric.
	Min *float64 `type:"double"`

	// The Amazon Resource Name (ARN) of the source.
	SourceArn *string `type:"string"`

	// The standard deviation of the metric.
	StdDev *float64 `type:"double"`

	// When the metric was last updated.
	TimeStamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TrialComponentMetricSummary) String() string {
	return awsutil.Prettify(s)
}

// The value of a hyperparameter. Only one of NumberValue or StringValue can
// be specified.
//
// This object is specified in the CreateTrialComponent request.
type TrialComponentParameterValue struct {
	_ struct{} `type:"structure"`

	// The numeric value of a numeric hyperparameter. If you specify a value for
	// this parameter, you can't specify the StringValue parameter.
	NumberValue *float64 `type:"double"`

	// The string value of a categorical hyperparameter. If you specify a value
	// for this parameter, you can't specify the NumberValue parameter.
	StringValue *string `type:"string"`
}

// String returns the string representation
func (s TrialComponentParameterValue) String() string {
	return awsutil.Prettify(s)
}

// A short summary of a trial component.
type TrialComponentSimpleSummary struct {
	_ struct{} `type:"structure"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	CreatedBy *UserContext `type:"structure"`

	// When the component was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string `type:"string"`

	// The name of the trial component.
	TrialComponentName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) and job type of the source of a trial component.
	TrialComponentSource *TrialComponentSource `type:"structure"`
}

// String returns the string representation
func (s TrialComponentSimpleSummary) String() string {
	return awsutil.Prettify(s)
}

// The Amazon Resource Name (ARN) and job type of the source of a trial component.
type TrialComponentSource struct {
	_ struct{} `type:"structure"`

	// The source ARN.
	//
	// SourceArn is a required field
	SourceArn *string `type:"string" required:"true"`

	// The source job type.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s TrialComponentSource) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about the source of a trial component. Either ProcessingJob
// or TrainingJob is returned.
type TrialComponentSourceDetail struct {
	_ struct{} `type:"structure"`

	// Information about a processing job that's the source of a trial component.
	ProcessingJob *ProcessingJob `type:"structure"`

	// The Amazon Resource Name (ARN) of the source.
	SourceArn *string `type:"string"`

	// Information about a training job that's the source of a trial component.
	TrainingJob *TrainingJob `type:"structure"`
}

// String returns the string representation
func (s TrialComponentSourceDetail) String() string {
	return awsutil.Prettify(s)
}

// The status of the trial component.
type TrialComponentStatus struct {
	_ struct{} `type:"structure"`

	// If the component failed, a message describing why.
	Message *string `type:"string"`

	// The status of the trial component.
	PrimaryStatus TrialComponentPrimaryStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s TrialComponentStatus) String() string {
	return awsutil.Prettify(s)
}

// A summary of the properties of a trial component. To get all the properties,
// call the DescribeTrialComponent API and provide the TrialComponentName.
type TrialComponentSummary struct {
	_ struct{} `type:"structure"`

	// Who created the component.
	CreatedBy *UserContext `type:"structure"`

	// When the component was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the component as displayed. If DisplayName isn't specified, TrialComponentName
	// is displayed.
	DisplayName *string `min:"1" type:"string"`

	// When the component ended.
	EndTime *time.Time `type:"timestamp"`

	// Who last modified the component.
	LastModifiedBy *UserContext `type:"structure"`

	// When the component was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// When the component started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the component. States include:
	//
	//    * InProgress
	//
	//    * Completed
	//
	//    * Failed
	Status *TrialComponentStatus `type:"structure"`

	// The ARN of the trial component.
	TrialComponentArn *string `type:"string"`

	// The name of the trial component.
	TrialComponentName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) and job type of the source of a trial component.
	TrialComponentSource *TrialComponentSource `type:"structure"`
}

// String returns the string representation
func (s TrialComponentSummary) String() string {
	return awsutil.Prettify(s)
}

// The source of the trial.
type TrialSource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source.
	//
	// SourceArn is a required field
	SourceArn *string `type:"string" required:"true"`

	// The source job type.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s TrialSource) String() string {
	return awsutil.Prettify(s)
}

// A summary of the properties of a trial. To get the complete set of properties,
// call the DescribeTrial API and provide the TrialName.
type TrialSummary struct {
	_ struct{} `type:"structure"`

	// When the trial was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the trial as displayed. If DisplayName isn't specified, TrialName
	// is displayed.
	DisplayName *string `min:"1" type:"string"`

	// When the trial was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string `type:"string"`

	// The name of the trial.
	TrialName *string `min:"1" type:"string"`

	// The source of the trial.
	TrialSource *TrialSource `type:"structure"`
}

// String returns the string representation
func (s TrialSummary) String() string {
	return awsutil.Prettify(s)
}

// The job completion criteria.
type TuningJobCompletionCriteria struct {
	_ struct{} `type:"structure"`

	// The objective metric's value.
	//
	// TargetObjectiveMetricValue is a required field
	TargetObjectiveMetricValue *float64 `type:"float" required:"true"`
}

// String returns the string representation
func (s TuningJobCompletionCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TuningJobCompletionCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TuningJobCompletionCriteria"}

	if s.TargetObjectiveMetricValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetObjectiveMetricValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents an amount of money in United States dollars/
type USD struct {
	_ struct{} `type:"structure"`

	// The fractional portion, in cents, of the amount.
	Cents *int64 `type:"integer"`

	// The whole number of dollars in the amount.
	Dollars *int64 `type:"integer"`

	// Fractions of a cent, in tenths.
	TenthFractionsOfACent *int64 `type:"integer"`
}

// String returns the string representation
func (s USD) String() string {
	return awsutil.Prettify(s)
}

// Provided configuration information for the worker UI for a labeling job.
type UiConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of the worker task template used to render the worker UI and tools
	// for labeling job tasks.
	//
	// Use this parameter when you are creating a labeling job for 3D point cloud
	// labeling modalities. Use your labeling job task type to select one of the
	// following ARN's and use it with this parameter when you create a labeling
	// job. Replace aws-region with the AWS region you are creating your labeling
	// job in.
	//
	// Use this HumanTaskUiArn for 3D point cloud object detection and 3D point
	// cloud object detection adjustment labeling jobs.
	//
	//    * arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection
	//
	// Use this HumanTaskUiArn for 3D point cloud object tracking and 3D point cloud
	// object tracking adjustment labeling jobs.
	//
	//    * arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking
	//
	// Use this HumanTaskUiArn for 3D point cloud semantic segmentation and 3D point
	// cloud semantic segmentation adjustment labeling jobs.
	//
	//    * arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation
	HumanTaskUiArn *string `type:"string"`

	// The Amazon S3 bucket location of the UI template, or worker task template.
	// This is the template used to render the worker UI and tools for labeling
	// job tasks. For more information about the contents of a UI template, see
	// Creating Your Custom Labeling Task Template (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html).
	UiTemplateS3Uri *string `type:"string"`
}

// String returns the string representation
func (s UiConfig) String() string {
	return awsutil.Prettify(s)
}

// The Liquid template for the worker user interface.
type UiTemplate struct {
	_ struct{} `type:"structure"`

	// The content of the Liquid template for the worker user interface.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UiTemplate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UiTemplate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UiTemplate"}

	if s.Content == nil {
		invalidParams.Add(aws.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Content", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Container for user interface template information.
type UiTemplateInfo struct {
	_ struct{} `type:"structure"`

	// The SHA-256 digest of the contents of the template.
	ContentSha256 *string `min:"1" type:"string"`

	// The URL for the user interface template.
	Url *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UiTemplateInfo) String() string {
	return awsutil.Prettify(s)
}

// Information about the user who created or modified an experiment, trial,
// or trial component.
type UserContext struct {
	_ struct{} `type:"structure"`

	// The domain associated with the user.
	DomainId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the user's profile.
	UserProfileArn *string `type:"string"`

	// The name of the user's profile.
	UserProfileName *string `type:"string"`
}

// String returns the string representation
func (s UserContext) String() string {
	return awsutil.Prettify(s)
}

// The user profile details.
type UserProfileDetails struct {
	_ struct{} `type:"structure"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The last modified time.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The status.
	Status UserProfileStatus `type:"string" enum:"true"`

	// The user profile name.
	UserProfileName *string `type:"string"`
}

// String returns the string representation
func (s UserProfileDetails) String() string {
	return awsutil.Prettify(s)
}

// A collection of settings.
type UserSettings struct {
	_ struct{} `type:"structure"`

	// The execution role for the user.
	ExecutionRole *string `min:"20" type:"string"`

	// The Jupyter server's app settings.
	JupyterServerAppSettings *JupyterServerAppSettings `type:"structure"`

	// The kernel gateway app settings.
	KernelGatewayAppSettings *KernelGatewayAppSettings `type:"structure"`

	// The security groups.
	SecurityGroups []string `type:"list"`

	// The sharing settings.
	SharingSettings *SharingSettings `type:"structure"`

	// The TensorBoard app settings.
	TensorBoardAppSettings *TensorBoardAppSettings `type:"structure"`
}

// String returns the string representation
func (s UserSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserSettings"}
	if s.ExecutionRole != nil && len(*s.ExecutionRole) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ExecutionRole", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a production variant property type for an Endpoint.
//
// If you are updating an endpoint with the UpdateEndpointInput$RetainAllVariantProperties
// option set to true, the VariantProperty objects listed in UpdateEndpointInput$ExcludeRetainedVariantProperties
// override the existing variant properties of the endpoint.
type VariantProperty struct {
	_ struct{} `type:"structure"`

	// The type of variant property. The supported values are:
	//
	//    * DesiredInstanceCount: Overrides the existing variant instance counts
	//    using the ProductionVariant$InitialInstanceCount values in the CreateEndpointConfigInput$ProductionVariants.
	//
	//    * DesiredWeight: Overrides the existing variant weights using the ProductionVariant$InitialVariantWeight
	//    values in the CreateEndpointConfigInput$ProductionVariants.
	//
	//    * DataCaptureConfig: (Not currently supported.)
	//
	// VariantPropertyType is a required field
	VariantPropertyType VariantPropertyType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s VariantProperty) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariantProperty) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VariantProperty"}
	if len(s.VariantPropertyType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("VariantPropertyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a VPC that your training jobs and hosted models have access to.
// Control access to and from your training and model containers by configuring
// the VPC. For more information, see Protect Endpoints by Using an Amazon Virtual
// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
// and Protect Training Jobs by Using an Amazon Virtual Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security
	// groups for the VPC that is specified in the Subnets field.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []string `min:"1" type:"list" required:"true"`

	// The ID of the subnets in the VPC to which you want to connect your training
	// job or model. For information about the availability of specific instance
	// types, see Supported Instance Types and Availability Zones (https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html).
	//
	// Subnets is a required field
	Subnets []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VpcConfig"}

	if s.SecurityGroupIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityGroupIds", 1))
	}

	if s.Subnets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subnets"))
	}
	if s.Subnets != nil && len(s.Subnets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Subnets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A single private workforce, which is automatically created when you create
// your first private work team. You can create one private work force in each
// AWS Region. By default, any workforce-related API operation used in a specific
// region will apply to the workforce created in that region. To learn how to
// create a private workforce, see Create a Private Workforce (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html).
type Workforce struct {
	_ struct{} `type:"structure"`

	// The most recent date that was used to successfully add one or more IP address
	// ranges (CIDRs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html))
	// to a private workforce's allow list.
	LastUpdatedDate *time.Time `type:"timestamp"`

	// A list of one to ten IP address ranges (CIDRs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html))
	// to be added to the workforce allow list.
	SourceIpConfig *SourceIpConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the private workforce.
	//
	// WorkforceArn is a required field
	WorkforceArn *string `type:"string" required:"true"`

	// The name of the private workforce whose access you want to restrict. WorkforceName
	// is automatically set to default when a workforce is created and cannot be
	// modified.
	//
	// WorkforceName is a required field
	WorkforceName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Workforce) String() string {
	return awsutil.Prettify(s)
}

// Provides details about a labeling work team.
type Workteam struct {
	_ struct{} `type:"structure"`

	// The date and time that the work team was created (timestamp).
	CreateDate *time.Time `type:"timestamp"`

	// A description of the work team.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The date and time that the work team was last updated (timestamp).
	LastUpdatedDate *time.Time `type:"timestamp"`

	// The Amazon Cognito user groups that make up the work team.
	//
	// MemberDefinitions is a required field
	MemberDefinitions []MemberDefinition `min:"1" type:"list" required:"true"`

	// Configures SNS notifications of available or expiring work items for work
	// teams.
	NotificationConfiguration *NotificationConfiguration `type:"structure"`

	// The Amazon Marketplace identifier for a vendor's work team.
	ProductListingIds []string `type:"list"`

	// The URI of the labeling job's user interface. Workers open this URI to start
	// labeling your data objects.
	SubDomain *string `type:"string"`

	// The Amazon Resource Name (ARN) that identifies the work team.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`

	// The name of the work team.
	//
	// WorkteamName is a required field
	WorkteamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Workteam) String() string {
	return awsutil.Prettify(s)
}
