// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeRegistryInput struct {
	_ struct{} `type:"structure"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRegistryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRegistryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeRegistryInput"}

	if s.RegistryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegistryName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRegistryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RegistryName != nil {
		v := *s.RegistryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "registryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeRegistryOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	RegistryArn *string `type:"string"`

	RegistryName *string `type:"string"`

	// Key-value pairs associated with a resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeRegistryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRegistryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegistryArn != nil {
		v := *s.RegistryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RegistryArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegistryName != nil {
		v := *s.RegistryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RegistryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opDescribeRegistry = "DescribeRegistry"

// DescribeRegistryRequest returns a request value for making API operation for
// Schemas.
//
// Describes the registry.
//
//    // Example sending a request using DescribeRegistryRequest.
//    req := client.DescribeRegistryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeRegistry
func (c *Client) DescribeRegistryRequest(input *DescribeRegistryInput) DescribeRegistryRequest {
	op := &aws.Operation{
		Name:       opDescribeRegistry,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries/name/{registryName}",
	}

	if input == nil {
		input = &DescribeRegistryInput{}
	}

	req := c.newRequest(op, input, &DescribeRegistryOutput{})

	return DescribeRegistryRequest{Request: req, Input: input, Copy: c.DescribeRegistryRequest}
}

// DescribeRegistryRequest is the request type for the
// DescribeRegistry API operation.
type DescribeRegistryRequest struct {
	*aws.Request
	Input *DescribeRegistryInput
	Copy  func(*DescribeRegistryInput) DescribeRegistryRequest
}

// Send marshals and sends the DescribeRegistry API request.
func (r DescribeRegistryRequest) Send(ctx context.Context) (*DescribeRegistryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRegistryResponse{
		DescribeRegistryOutput: r.Request.Data.(*DescribeRegistryOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRegistryResponse is the response type for the
// DescribeRegistry API operation.
type DescribeRegistryResponse struct {
	*DescribeRegistryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRegistry request.
func (r *DescribeRegistryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
