// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeStandardsControlsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of security standard controls to return.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeStandardsControls
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ARN of a resource that represents your subscription to a supported standard.
	//
	// StandardsSubscriptionArn is a required field
	StandardsSubscriptionArn *string `location:"uri" locationName:"StandardsSubscriptionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStandardsControlsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStandardsControlsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStandardsControlsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.StandardsSubscriptionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("StandardsSubscriptionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeStandardsControlsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.StandardsSubscriptionArn != nil {
		v := *s.StandardsSubscriptionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "StandardsSubscriptionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeStandardsControlsOutput struct {
	_ struct{} `type:"structure"`

	// A list of security standards controls.
	Controls []StandardsControl `type:"list"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeStandardsControlsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeStandardsControlsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Controls != nil {
		v := s.Controls

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Controls", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeStandardsControls = "DescribeStandardsControls"

// DescribeStandardsControlsRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Returns a list of security standards controls.
//
// For each control, the results include information about whether it is currently
// enabled, the severity, and a link to remediation information.
//
//    // Example sending a request using DescribeStandardsControlsRequest.
//    req := client.DescribeStandardsControlsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls
func (c *Client) DescribeStandardsControlsRequest(input *DescribeStandardsControlsInput) DescribeStandardsControlsRequest {
	op := &aws.Operation{
		Name:       opDescribeStandardsControls,
		HTTPMethod: "GET",
		HTTPPath:   "/standards/controls/{StandardsSubscriptionArn+}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStandardsControlsInput{}
	}

	req := c.newRequest(op, input, &DescribeStandardsControlsOutput{})

	return DescribeStandardsControlsRequest{Request: req, Input: input, Copy: c.DescribeStandardsControlsRequest}
}

// DescribeStandardsControlsRequest is the request type for the
// DescribeStandardsControls API operation.
type DescribeStandardsControlsRequest struct {
	*aws.Request
	Input *DescribeStandardsControlsInput
	Copy  func(*DescribeStandardsControlsInput) DescribeStandardsControlsRequest
}

// Send marshals and sends the DescribeStandardsControls API request.
func (r DescribeStandardsControlsRequest) Send(ctx context.Context) (*DescribeStandardsControlsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeStandardsControlsResponse{
		DescribeStandardsControlsOutput: r.Request.Data.(*DescribeStandardsControlsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeStandardsControlsRequestPaginator returns a paginator for DescribeStandardsControls.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeStandardsControlsRequest(input)
//   p := securityhub.NewDescribeStandardsControlsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeStandardsControlsPaginator(req DescribeStandardsControlsRequest) DescribeStandardsControlsPaginator {
	return DescribeStandardsControlsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeStandardsControlsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeStandardsControlsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeStandardsControlsPaginator struct {
	aws.Pager
}

func (p *DescribeStandardsControlsPaginator) CurrentPage() *DescribeStandardsControlsOutput {
	return p.Pager.CurrentPage().(*DescribeStandardsControlsOutput)
}

// DescribeStandardsControlsResponse is the response type for the
// DescribeStandardsControls API operation.
type DescribeStandardsControlsResponse struct {
	*DescribeStandardsControlsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeStandardsControls request.
func (r *DescribeStandardsControlsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
