// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateTagOptionInput struct {
	_ struct{} `type:"structure"`

	// The TagOption key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The TagOption value.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTagOptionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagOptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTagOptionInput"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateTagOptionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the TagOption.
	TagOptionDetail *TagOptionDetail `type:"structure"`
}

// String returns the string representation
func (s CreateTagOptionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTagOption = "CreateTagOption"

// CreateTagOptionRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Creates a TagOption.
//
//    // Example sending a request using CreateTagOptionRequest.
//    req := client.CreateTagOptionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateTagOption
func (c *Client) CreateTagOptionRequest(input *CreateTagOptionInput) CreateTagOptionRequest {
	op := &aws.Operation{
		Name:       opCreateTagOption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagOptionInput{}
	}

	req := c.newRequest(op, input, &CreateTagOptionOutput{})

	return CreateTagOptionRequest{Request: req, Input: input, Copy: c.CreateTagOptionRequest}
}

// CreateTagOptionRequest is the request type for the
// CreateTagOption API operation.
type CreateTagOptionRequest struct {
	*aws.Request
	Input *CreateTagOptionInput
	Copy  func(*CreateTagOptionInput) CreateTagOptionRequest
}

// Send marshals and sends the CreateTagOption API request.
func (r CreateTagOptionRequest) Send(ctx context.Context) (*CreateTagOptionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTagOptionResponse{
		CreateTagOptionOutput: r.Request.Data.(*CreateTagOptionOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTagOptionResponse is the response type for the
// CreateTagOption API operation.
type CreateTagOptionResponse struct {
	*CreateTagOptionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTagOption request.
func (r *CreateTagOptionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
