// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAWSOrganizationsAccessStatusInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAWSOrganizationsAccessStatusInput) String() string {
	return awsutil.Prettify(s)
}

type GetAWSOrganizationsAccessStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the portfolio share feature.
	AccessStatus AccessStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetAWSOrganizationsAccessStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAWSOrganizationsAccessStatus = "GetAWSOrganizationsAccessStatus"

// GetAWSOrganizationsAccessStatusRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Get the Access Status for AWS Organization portfolio share feature. This
// API can only be called by the master account in the organization or by a
// delegated admin.
//
//    // Example sending a request using GetAWSOrganizationsAccessStatusRequest.
//    req := client.GetAWSOrganizationsAccessStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetAWSOrganizationsAccessStatus
func (c *Client) GetAWSOrganizationsAccessStatusRequest(input *GetAWSOrganizationsAccessStatusInput) GetAWSOrganizationsAccessStatusRequest {
	op := &aws.Operation{
		Name:       opGetAWSOrganizationsAccessStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAWSOrganizationsAccessStatusInput{}
	}

	req := c.newRequest(op, input, &GetAWSOrganizationsAccessStatusOutput{})

	return GetAWSOrganizationsAccessStatusRequest{Request: req, Input: input, Copy: c.GetAWSOrganizationsAccessStatusRequest}
}

// GetAWSOrganizationsAccessStatusRequest is the request type for the
// GetAWSOrganizationsAccessStatus API operation.
type GetAWSOrganizationsAccessStatusRequest struct {
	*aws.Request
	Input *GetAWSOrganizationsAccessStatusInput
	Copy  func(*GetAWSOrganizationsAccessStatusInput) GetAWSOrganizationsAccessStatusRequest
}

// Send marshals and sends the GetAWSOrganizationsAccessStatus API request.
func (r GetAWSOrganizationsAccessStatusRequest) Send(ctx context.Context) (*GetAWSOrganizationsAccessStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAWSOrganizationsAccessStatusResponse{
		GetAWSOrganizationsAccessStatusOutput: r.Request.Data.(*GetAWSOrganizationsAccessStatusOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAWSOrganizationsAccessStatusResponse is the response type for the
// GetAWSOrganizationsAccessStatus API operation.
type GetAWSOrganizationsAccessStatusResponse struct {
	*GetAWSOrganizationsAccessStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAWSOrganizationsAccessStatus request.
func (r *GetAWSOrganizationsAccessStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
