// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdatePortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The tags to add.
	AddTags []Tag `type:"list"`

	// The updated description of the portfolio.
	Description *string `type:"string"`

	// The name to use for display purposes.
	DisplayName *string `min:"1" type:"string"`

	// The portfolio identifier.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The updated name of the portfolio provider.
	ProviderName *string `min:"1" type:"string"`

	// The tags to remove.
	RemoveTags []string `type:"list"`
}

// String returns the string representation
func (s UpdatePortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePortfolioInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdatePortfolioInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DisplayName", 1))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProviderName", 1))
	}
	if s.AddTags != nil {
		for i, v := range s.AddTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdatePortfolioOutput struct {
	_ struct{} `type:"structure"`

	// Information about the portfolio.
	PortfolioDetail *PortfolioDetail `type:"structure"`

	// Information about the tags associated with the portfolio.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s UpdatePortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdatePortfolio = "UpdatePortfolio"

// UpdatePortfolioRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Updates the specified portfolio.
//
// You cannot update a product that was shared with you.
//
//    // Example sending a request using UpdatePortfolioRequest.
//    req := client.UpdatePortfolioRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolio
func (c *Client) UpdatePortfolioRequest(input *UpdatePortfolioInput) UpdatePortfolioRequest {
	op := &aws.Operation{
		Name:       opUpdatePortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePortfolioInput{}
	}

	req := c.newRequest(op, input, &UpdatePortfolioOutput{})

	return UpdatePortfolioRequest{Request: req, Input: input, Copy: c.UpdatePortfolioRequest}
}

// UpdatePortfolioRequest is the request type for the
// UpdatePortfolio API operation.
type UpdatePortfolioRequest struct {
	*aws.Request
	Input *UpdatePortfolioInput
	Copy  func(*UpdatePortfolioInput) UpdatePortfolioRequest
}

// Send marshals and sends the UpdatePortfolio API request.
func (r UpdatePortfolioRequest) Send(ctx context.Context) (*UpdatePortfolioResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdatePortfolioResponse{
		UpdatePortfolioOutput: r.Request.Data.(*UpdatePortfolioOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdatePortfolioResponse is the response type for the
// UpdatePortfolio API operation.
type UpdatePortfolioResponse struct {
	*UpdatePortfolioOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdatePortfolio request.
func (r *UpdatePortfolioResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
