// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type UpdateInstanceCustomHealthStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance that you want to change the health status for.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the service that includes the configuration for the custom health
	// check that you want to change the status for.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`

	// The new status of the instance, HEALTHY or UNHEALTHY.
	//
	// Status is a required field
	Status CustomHealthStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateInstanceCustomHealthStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInstanceCustomHealthStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateInstanceCustomHealthStatusInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if s.ServiceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceId"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateInstanceCustomHealthStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateInstanceCustomHealthStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateInstanceCustomHealthStatus = "UpdateInstanceCustomHealthStatus"

// UpdateInstanceCustomHealthStatusRequest returns a request value for making API operation for
// AWS Cloud Map.
//
// Submits a request to change the health status of a custom health check to
// healthy or unhealthy.
//
// You can use UpdateInstanceCustomHealthStatus to change the status only for
// custom health checks, which you define using HealthCheckCustomConfig when
// you create a service. You can't use it to change the status for Route 53
// health checks, which you define using HealthCheckConfig.
//
// For more information, see HealthCheckCustomConfig (https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html).
//
//    // Example sending a request using UpdateInstanceCustomHealthStatusRequest.
//    req := client.UpdateInstanceCustomHealthStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateInstanceCustomHealthStatus
func (c *Client) UpdateInstanceCustomHealthStatusRequest(input *UpdateInstanceCustomHealthStatusInput) UpdateInstanceCustomHealthStatusRequest {
	op := &aws.Operation{
		Name:       opUpdateInstanceCustomHealthStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceCustomHealthStatusInput{}
	}

	req := c.newRequest(op, input, &UpdateInstanceCustomHealthStatusOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return UpdateInstanceCustomHealthStatusRequest{Request: req, Input: input, Copy: c.UpdateInstanceCustomHealthStatusRequest}
}

// UpdateInstanceCustomHealthStatusRequest is the request type for the
// UpdateInstanceCustomHealthStatus API operation.
type UpdateInstanceCustomHealthStatusRequest struct {
	*aws.Request
	Input *UpdateInstanceCustomHealthStatusInput
	Copy  func(*UpdateInstanceCustomHealthStatusInput) UpdateInstanceCustomHealthStatusRequest
}

// Send marshals and sends the UpdateInstanceCustomHealthStatus API request.
func (r UpdateInstanceCustomHealthStatusRequest) Send(ctx context.Context) (*UpdateInstanceCustomHealthStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateInstanceCustomHealthStatusResponse{
		UpdateInstanceCustomHealthStatusOutput: r.Request.Data.(*UpdateInstanceCustomHealthStatusOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateInstanceCustomHealthStatusResponse is the response type for the
// UpdateInstanceCustomHealthStatus API operation.
type UpdateInstanceCustomHealthStatusResponse struct {
	*UpdateInstanceCustomHealthStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateInstanceCustomHealthStatus request.
func (r *UpdateInstanceCustomHealthStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
