// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to enable or disable whether Amazon SES forwards you
// bounce and complaint notifications through email. For information about email
// feedback forwarding, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-email.html).
type SetIdentityFeedbackForwardingEnabledInput struct {
	_ struct{} `type:"structure"`

	// Sets whether Amazon SES will forward bounce and complaint notifications as
	// email. true specifies that Amazon SES will forward bounce and complaint notifications
	// as email, in addition to any Amazon SNS topic publishing otherwise specified.
	// false specifies that Amazon SES will publish bounce and complaint notifications
	// only through Amazon SNS. This value can only be set to false when Amazon
	// SNS topics are set for both Bounce and Complaint notification types.
	//
	// ForwardingEnabled is a required field
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	// The identity for which to set bounce and complaint notification forwarding.
	// Examples: user@example.com, example.com.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetIdentityFeedbackForwardingEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityFeedbackForwardingEnabledInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetIdentityFeedbackForwardingEnabledInput"}

	if s.ForwardingEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForwardingEnabled"))
	}

	if s.Identity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
type SetIdentityFeedbackForwardingEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityFeedbackForwardingEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetIdentityFeedbackForwardingEnabled = "SetIdentityFeedbackForwardingEnabled"

// SetIdentityFeedbackForwardingEnabledRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Given an identity (an email address or a domain), enables or disables whether
// Amazon SES forwards bounce and complaint notifications as email. Feedback
// forwarding can only be disabled when Amazon Simple Notification Service (Amazon
// SNS) topics are specified for both bounces and complaints.
//
// Feedback forwarding does not apply to delivery notifications. Delivery notifications
// are only available through Amazon SNS.
//
// You can execute this operation no more than once per second.
//
// For more information about using notifications with Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
//
//    // Example sending a request using SetIdentityFeedbackForwardingEnabledRequest.
//    req := client.SetIdentityFeedbackForwardingEnabledRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabled
func (c *Client) SetIdentityFeedbackForwardingEnabledRequest(input *SetIdentityFeedbackForwardingEnabledInput) SetIdentityFeedbackForwardingEnabledRequest {
	op := &aws.Operation{
		Name:       opSetIdentityFeedbackForwardingEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityFeedbackForwardingEnabledInput{}
	}

	req := c.newRequest(op, input, &SetIdentityFeedbackForwardingEnabledOutput{})

	return SetIdentityFeedbackForwardingEnabledRequest{Request: req, Input: input, Copy: c.SetIdentityFeedbackForwardingEnabledRequest}
}

// SetIdentityFeedbackForwardingEnabledRequest is the request type for the
// SetIdentityFeedbackForwardingEnabled API operation.
type SetIdentityFeedbackForwardingEnabledRequest struct {
	*aws.Request
	Input *SetIdentityFeedbackForwardingEnabledInput
	Copy  func(*SetIdentityFeedbackForwardingEnabledInput) SetIdentityFeedbackForwardingEnabledRequest
}

// Send marshals and sends the SetIdentityFeedbackForwardingEnabled API request.
func (r SetIdentityFeedbackForwardingEnabledRequest) Send(ctx context.Context) (*SetIdentityFeedbackForwardingEnabledResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetIdentityFeedbackForwardingEnabledResponse{
		SetIdentityFeedbackForwardingEnabledOutput: r.Request.Data.(*SetIdentityFeedbackForwardingEnabledOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetIdentityFeedbackForwardingEnabledResponse is the response type for the
// SetIdentityFeedbackForwardingEnabled API operation.
type SetIdentityFeedbackForwardingEnabledResponse struct {
	*SetIdentityFeedbackForwardingEnabledOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetIdentityFeedbackForwardingEnabled request.
func (r *SetIdentityFeedbackForwardingEnabledResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
