// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateActivityInput struct {
	_ struct{} `type:"structure"`

	// The name of the activity to create. This name must be unique for your AWS
	// account and region for 90 days. For more information, see Limits Related
	// to State Machine Executions (https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions)
	// in the AWS Step Functions Developer Guide.
	//
	// A name must not contain:
	//
	//    * white space
	//
	//    * brackets < > { } [ ]
	//
	//    * wildcard characters ? *
	//
	//    * special characters " # % \ ^ | ~ ` $ & , ; : /
	//
	//    * control characters (U+0000-001F, U+007F-009F)
	//
	// To enable logging with CloudWatch Logs, the name should only contain 0-9,
	// A-Z, a-z, - and _.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The list of tags to add to a resource.
	//
	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
	// in the AWS Billing and Cost Management User Guide, and Controlling Access
	// Using IAM Tags (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
	//
	// Tags may only contain Unicode letters, digits, white space, or these symbols:
	// _ . : / = + - @.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateActivityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateActivityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateActivityInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateActivityOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the created activity.
	//
	// ActivityArn is a required field
	ActivityArn *string `locationName:"activityArn" min:"1" type:"string" required:"true"`

	// The date the activity is created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s CreateActivityOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateActivity = "CreateActivity"

// CreateActivityRequest returns a request value for making API operation for
// AWS Step Functions.
//
// Creates an activity. An activity is a task that you write in any programming
// language and host on any machine that has access to AWS Step Functions. Activities
// must poll Step Functions using the GetActivityTask API action and respond
// using SendTask* API actions. This function lets Step Functions know the existence
// of your activity and returns an identifier for use in a state machine and
// when polling from the activity.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// CreateActivity is an idempotent API. Subsequent requests won’t create a
// duplicate resource if it was already created. CreateActivity's idempotency
// check is based on the activity name. If a following request has different
// tags values, Step Functions will ignore these differences and treat it as
// an idempotent request of the previous. In this case, tags will not be updated,
// even if they are different.
//
//    // Example sending a request using CreateActivityRequest.
//    req := client.CreateActivityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/CreateActivity
func (c *Client) CreateActivityRequest(input *CreateActivityInput) CreateActivityRequest {
	op := &aws.Operation{
		Name:       opCreateActivity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateActivityInput{}
	}

	req := c.newRequest(op, input, &CreateActivityOutput{})

	return CreateActivityRequest{Request: req, Input: input, Copy: c.CreateActivityRequest}
}

// CreateActivityRequest is the request type for the
// CreateActivity API operation.
type CreateActivityRequest struct {
	*aws.Request
	Input *CreateActivityInput
	Copy  func(*CreateActivityInput) CreateActivityRequest
}

// Send marshals and sends the CreateActivity API request.
func (r CreateActivityRequest) Send(ctx context.Context) (*CreateActivityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateActivityResponse{
		CreateActivityOutput: r.Request.Data.(*CreateActivityOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateActivityResponse is the response type for the
// CreateActivity API operation.
type CreateActivityResponse struct {
	*CreateActivityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateActivity request.
func (r *CreateActivityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
